/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.MultiValueFormattedOperator;
import com.sas.storage.simplesqlmodel.OperatorInterface;
import java.util.Map;

public class OperatorFactory {
    public static String getOperatorType(OperatorInterface operator) {
        OperatorInterface value;
        Map operatorMap;
        if (operator instanceof FormattedOperator) {
            operatorMap = FormattedOperator.getOperatorMap();
            for (String key : operatorMap.keySet()) {
                value = (OperatorInterface)operatorMap.get(key);
                if (value != operator) continue;
                return key;
            }
        }
        if (operator instanceof MultiValueFormattedOperator) {
            operatorMap = MultiValueFormattedOperator.getOperatorMap();
            for (String key : operatorMap.keySet()) {
                value = (OperatorInterface)operatorMap.get(key);
                if (value != operator) continue;
                return key;
            }
        }
        return null;
    }

    public static OperatorInterface getOperatorByType(String type) {
        Map operatorMap = FormattedOperator.getOperatorMap();
        if (operatorMap.containsKey(type)) {
            return (OperatorInterface)operatorMap.get(type);
        }
        operatorMap = MultiValueFormattedOperator.getOperatorMap();
        if (operatorMap.containsKey(type)) {
            return (OperatorInterface)operatorMap.get(type);
        }
        return null;
    }
}

