/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever.dto;

import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.storage.retriever.dto.QueryItemInterface;
import com.sas.storage.retriever.dto.ValueDataType;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.BaseAbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class QueryItem
extends BaseAbstractPersistence
implements QueryItemInterface {
    private static final long serialVersionUID = -9141975583708120161L;
    public static final String SORT_ASCENDING = "Ascending";
    public static final String SORT_DESCENDING = "Descending";
    public static final String SORT_NONE = "None";
    private DataSourceInterface _dataSource;
    private String _uniqueName;
    private String _label;
    private String _format;
    private boolean _trimValues;
    private ValueDataType _dataType;
    private boolean _isFormattedValues;
    private String _sortDirection;
    private boolean _isSearchable;
    private String _vrConfigId;

    public QueryItem() {
    }

    public QueryItem(DataSourceInterface ds, String un) {
        this._dataSource = ds;
        this._uniqueName = un;
        this.setDefaultProperties();
    }

    public QueryItem(DataSourceInterface ds, String un, ValueDataType dataType) {
        this._dataSource = ds;
        this._uniqueName = un;
        this.setDataType(dataType);
        this.setDefaultProperties();
    }

    protected void setDefaultProperties() {
        this._isFormattedValues = false;
        this._trimValues = true;
        this._label = this._uniqueName;
    }

    @Override
    public String getVrConfigId() {
        return this._vrConfigId;
    }

    @Override
    public void setVrConfigId(String id) {
        this._vrConfigId = id;
    }

    @Override
    public DataSourceInterface getDataSource() {
        return this._dataSource;
    }

    @Override
    public void setDataSource(DataSourceInterface ds) {
        this._dataSource = ds;
    }

    @Override
    public boolean isFormattedValues() {
        return this._isFormattedValues;
    }

    public boolean getIsFormattedValues() {
        return this._isFormattedValues;
    }

    @Override
    public void setIsFormattedValues(boolean flag) {
        this._isFormattedValues = flag;
    }

    @Override
    public boolean isSearchable() {
        return this._isSearchable;
    }

    public void setIsSearchable(boolean flag) {
        this._isSearchable = flag;
    }

    @Override
    public String getUniqueName() {
        return this._uniqueName;
    }

    @Override
    public void setUniqueName(String name) {
        this._uniqueName = name;
    }

    @Override
    public String getLabel() {
        return this._label != null ? this._label : this._uniqueName;
    }

    @Override
    public void setLabel(String name) {
        this._label = name;
    }

    @Override
    public void setFormat(String formatName) {
        this._format = formatName;
    }

    @Override
    public boolean getTrimValues() {
        return this._trimValues;
    }

    @Override
    public void setTrimValues(boolean trim) {
        this._trimValues = trim;
    }

    @Override
    public ValueDataType getDataType() {
        return this._dataType;
    }

    @Override
    public void setDataType(ValueDataType dataType) {
        this._dataType = dataType;
        if (dataType != null && !dataType.equals((Object)ValueDataType.DATE) && !dataType.equals((Object)ValueDataType.TIME)) {
            this._isSearchable = true;
        }
    }

    @Override
    public String getSortDirection() {
        return this._sortDirection;
    }

    @Override
    public void setSortDirection(String direction) {
        this._sortDirection = direction;
    }

    @Override
    public String getFormat() {
        return this._format;
    }

    public String toString() {
        String name = "";
        String dsLoc = "";
        if (null != this._uniqueName) {
            name = this._uniqueName;
        }
        if (null != this._dataSource) {
            dsLoc = this._dataSource.getDataSourceLocation();
        }
        return "location: " + dsLoc + "name: " + name;
    }

    public Object clone() throws CloneNotSupportedException {
        QueryItem clone = (QueryItem)super.clone();
        DataSourceInterface ds = this.getDataSource();
        if (ds != null) {
            clone.setDataSource((DataSourceInterface)ds.clone());
        }
        clone.setUniqueName(this.getUniqueName());
        clone.setLabel(this.getLabel());
        clone.setFormat(this.getFormat());
        clone.setDataType(this.getDataType());
        clone.setIsFormattedValues(this.isFormattedValues());
        clone.setTrimValues(this.getTrimValues());
        clone.setSortDirection(this.getSortDirection());
        return clone;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        this.setDataSource((DataSourceInterface)roHolder.consumeObject("DataSource"));
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String dtString = provider.consumeAttr("dataType");
        if (null != dtString) {
            this.setDataType(ValueDataType.valueOf(dtString));
        }
        this.setUniqueName(provider.consumeAttr("name"));
        this.setLabel(provider.consumeAttr("label"));
        this.setSortDirection(provider.consumeAttr("sortOrder"));
        this.setIsFormattedValues(provider.consumeBooleanAttr("formatValues", false));
        this.setFormat(provider.consumeAttr("formatValues"));
        this.setTrimValues(provider.consumeBooleanAttr("trimValues", true));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr(element, "dataType", this.getDataType().toString());
        XmlUtil.setAttr(element, "name", this.getUniqueName());
        XmlUtil.setAttr(element, "label", this.getLabel());
        XmlUtil.setAttr(element, "sortOrder", this.getSortDirection());
        XmlUtil.setBooleanAttr(element, "formatValues", this.isFormattedValues(), false);
        XmlUtil.setAttr(element, "formatValues", this.getFormat());
        XmlUtil.setBooleanAttr(element, "trimValues", this.getTrimValues(), true);
        DataSourceInterface ds = this.getDataSource();
        ArrayList<PersistenceInterface> valueObjects = new ArrayList<PersistenceInterface>();
        PersistenceInterface itemValue = ValueUtil.getPersistableValue(ds);
        valueObjects.add(itemValue);
        QueryItem.writeRelatedObjects(valueObjects, element, writingContext, "DataSource");
    }
}

