/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;

public class TupleElementNode
extends MetadataEntityTreeNode {
    private TupleElementInterface tupleElement;

    public TupleElementNode() {
    }

    public TupleElementNode(TupleElementInterface element) {
        this.tupleElement = element;
    }

    @Override
    public String toString() {
        try {
            return this.tupleElement != null ? this.tupleElement.getName() : this.name;
        }
        catch (OLAPException oe) {
            return null;
        }
    }

    @Override
    public int getChildCount() {
        try {
            if (this.childCount == -1) {
                int min = this.tupleElement.getMinimumCoordinate();
                int max = this.tupleElement.getMaximumCoordinate();
                TupleInterface[] tuples = this.tupleElement.getTuple().getAxis().getTuples(min, max - min + 1);
                TupleElementInterface[] elements = this.tupleElement.getTuple().getElements(0, this.tupleElement.getTupleElementIndex() + 1);
                int level = 0;
                for (int i = 0; i < elements.length; ++i) {
                    level += elements[i].getSpan();
                }
                elements = OLAPUtil.getTupleElementsForLevel(level, tuples, false, -1);
                this.childCount = elements.length;
            }
        }
        catch (OLAPException oe) {
            return 0;
        }
        return this.childCount;
    }

    @Override
    protected synchronized boolean populateChildren() {
        try {
            if (this.getChildCount() > 0) {
                int min = this.tupleElement.getMinimumCoordinate();
                int max = this.tupleElement.getMaximumCoordinate();
                TupleInterface[] tuples = this.tupleElement.getTuple().getAxis().getTuples(min, max - min + 1);
                TupleElementInterface[] elements = this.tupleElement.getTuple().getElements(0, this.tupleElement.getTupleElementIndex() + 1);
                int level = 0;
                for (int i = 0; i < elements.length; ++i) {
                    level += elements[i].getSpan();
                }
                elements = OLAPUtil.getTupleElementsForLevel(level, tuples, false, -1);
                for (int j = 0; j < elements.length; ++j) {
                    TupleElementNode elementNode = new TupleElementNode(elements[j]);
                    super.insert(elementNode, j);
                    elementNode.setParent(this);
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

