/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.tree.AxisNode;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class OLAPDataTreeNode
extends DefaultMutableTreeNode {
    private OLAPDataSetInterface olapDataSet;
    protected int childCount;
    protected boolean initialized;
    protected String name;

    public OLAPDataTreeNode(OLAPDataSetInterface olapDataSet) {
        this.olapDataSet = olapDataSet;
        this.name = "Root";
    }

    @Override
    public String toString() {
        return this.name;
    }

    protected void init() {
    }

    @Override
    public int getChildCount() {
        try {
            AxisInterface[] axes = this.olapDataSet.getResultSetMetadata().getAxes(0, -1);
            this.childCount = axes.length;
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.childCount;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() <= 0;
    }

    public Enumeration children() {
        if (!this.initialized) {
            this.populateChildren();
        }
        return super.children();
    }

    @Override
    public TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (!this.initialized) {
            this.populateChildren();
        }
        return super.getChildAt(index);
    }

    protected synchronized boolean populateChildren() {
        try {
            AxisInterface[] axes = this.olapDataSet.getResultSetMetadata().getAxes(0, -1);
            for (int i = 0; i < axes.length; ++i) {
                AxisNode a = new AxisNode(axes[i]);
                super.insert(a, i);
                a.setParent(this);
            }
            return true;
        }
        catch (OLAPException oLAPException) {
            return false;
        }
    }

    protected void createDummyNode(String name) {
        this.name = name;
        this.childCount = 0;
    }
}

