/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.OLAPException;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MetadataEntityTreeNode
extends DefaultMutableTreeNode {
    public static int MEMBER_TREE = 2;
    public static int METADATA_TREE = 4;
    public static int DEFAULT_TREE = MEMBER_TREE | METADATA_TREE;
    private boolean displayAllMember;
    protected int treeType;
    protected int childCount;
    protected int threshold;
    protected boolean initialized;
    protected String name;

    public MetadataEntityTreeNode(String name) {
        this.name = name;
        this.init();
    }

    public MetadataEntityTreeNode() {
        this.init();
    }

    protected void init() {
        this.childCount = -1;
        this.initialized = false;
        this.treeType = DEFAULT_TREE;
        this.displayAllMember = false;
        this.threshold = -1;
    }

    public int getTreeType() {
        return this.treeType;
    }

    public void setTreeType(int treeType) {
        this.treeType = treeType;
    }

    public boolean displayAllMember() {
        return this.displayAllMember;
    }

    public void setDisplayAllMember(boolean allMemberDisplayed) {
        this.displayAllMember = allMemberDisplayed;
    }

    @Override
    public String toString() {
        try {
            return this.userObject != null ? ((MetadataEntityInterface)this.userObject).getName() : this.name;
        }
        catch (OLAPException oe) {
            return this.name;
        }
    }

    public String getUniqueName() {
        try {
            return this.userObject != null ? ((MetadataEntityInterface)this.userObject).getUniqueName() : this.name;
        }
        catch (OLAPException oe) {
            return this.name;
        }
    }

    public String getURL() {
        return this.getUniqueName();
    }

    @Override
    public int getChildCount() {
        if (this.childCount == -1 && this.children != null) {
            this.childCount = this.children.size();
        }
        if (this.threshold > this.childCount) {
            this.threshold = this.childCount;
        }
        return this.childCount;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() <= 0;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public Enumeration children() {
        if (!this.initialized) {
            this.populateChildren();
        }
        return super.children();
    }

    @Override
    public TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (!this.initialized) {
            this.populateChildren();
        }
        return super.getChildAt(index);
    }

    protected synchronized boolean populateChildren() {
        return true;
    }

    protected void createDummyNode(String name) {
        this.name = name;
        this.childCount = 0;
    }
}

