/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.tree.LevelNode;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.util.log.LoggerRepository2;

public class HierarchyNode
extends MetadataEntityTreeNode {
    private HierarchyInterface hierarchy;

    public HierarchyNode(HierarchyInterface hierarchy) {
        this(hierarchy, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public HierarchyNode(HierarchyInterface hierarchy, int treeType) {
        this(hierarchy, treeType, false);
    }

    public HierarchyNode(HierarchyInterface hierarchy, int treeType, boolean displayAllMember) {
        this.hierarchy = hierarchy;
        this.userObject = hierarchy;
        this.setTreeType(treeType);
        this.setDisplayAllMember(displayAllMember);
    }

    public HierarchyNode(MetadataInterface metadata, String cubeName, String hierarchyUniqueName) {
        this(metadata, cubeName, hierarchyUniqueName, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public HierarchyNode(MetadataInterface metadata, String cubeName, String hierarchyUniqueName, int treeType) {
        this(metadata, cubeName, hierarchyUniqueName, treeType, false);
    }

    public HierarchyNode(MetadataInterface metadata, String cubeName, String hierarchyUniqueName, int treeType, boolean displayAllMember) {
        this.findHierarchy(metadata, cubeName, hierarchyUniqueName);
        if (this.hierarchy == null) {
            this.createDummyNode(hierarchyUniqueName);
        }
        this.setTreeType(treeType);
        this.setDisplayAllMember(displayAllMember);
    }

    @Override
    public int getChildCount() {
        try {
            if (this.childCount == -1) {
                this.childCount = this.hierarchy.getLevels().length;
                if (this.childCount > 0 && !this.displayAllMember() && this.hierarchy.getDimension().getType() != 2) {
                    --this.childCount;
                }
                if (this.childCount > 0 && (this.treeType & MEMBER_TREE) == this.treeType) {
                    this.childCount = 1;
                }
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger(HierarchyNode.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            return 0;
        }
        return this.childCount;
    }

    @Override
    public synchronized boolean populateChildren() {
        if ((this.treeType & MEMBER_TREE) == this.treeType) {
            return this.populateMemberChildren();
        }
        return this.populateLevelChildren();
    }

    private boolean populateLevelChildren() {
        try {
            if (this.getChildCount() > 0) {
                LevelInterface[] levels = this.hierarchy.getLevels();
                int j = 0;
                int k = 0;
                if (!this.displayAllMember() && this.hierarchy.getDimension().getType() != 2) {
                    this.childCount = levels.length - 1;
                    j = 1;
                }
                while (j < levels.length) {
                    LevelNode l = new LevelNode(levels[j], this.treeType, this.displayAllMember());
                    super.insert(l, k++);
                    l.setParent(this);
                    l.setThreshold(this.threshold);
                    ++j;
                }
            }
            this.initialized = true;
        }
        catch (Exception e) {
            LoggerRepository2.getLogger(HierarchyNode.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return this.initialized;
    }

    private boolean populateMemberChildren() {
        try {
            if (this.getChildCount() > 0) {
                LevelInterface[] levels = this.hierarchy.getLevels();
                this.childCount = 1;
                LevelInterface level = this.displayAllMember() || this.hierarchy.getDimension().getType() == 2 ? levels[0] : levels[1];
                LevelNode l = new LevelNode(level, this.treeType, this.displayAllMember());
                super.insert(l, 0);
                l.setParent(this);
                l.setThreshold(this.threshold);
            }
            this.initialized = true;
        }
        catch (Exception e) {
            LoggerRepository2.getLogger(HierarchyNode.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return this.initialized;
    }

    private HierarchyInterface findHierarchy(MetadataInterface metadata, String cubeName, String uniqueName) {
        try {
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            filter.setUniqueHierarchyName(uniqueName);
            this.hierarchy = metadata.getHierarchy(filter);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger(HierarchyNode.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return this.hierarchy;
    }
}

