/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.tree.DimensionNode;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;

public class CubeNode
extends MetadataEntityTreeNode {
    private CubeInterface cube;

    public CubeNode() {
    }

    public CubeNode(CubeInterface cube) {
        this(cube, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public CubeNode(CubeInterface cube, int treeType) {
        this(cube, treeType, false);
    }

    public CubeNode(CubeInterface cube, int treeType, boolean displayAllMember) {
        this.cube = cube;
        this.userObject = cube;
        super.setTreeType(treeType);
        super.setDisplayAllMember(displayAllMember);
    }

    public CubeNode(MetadataInterface metadata, String cubeName) {
        this(metadata, cubeName, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public CubeNode(MetadataInterface metadata, String cubeName, int treeType) {
        this(metadata, cubeName, treeType, false);
    }

    public CubeNode(MetadataInterface metadata, String cubeName, int treeType, boolean displayAllMember) {
        if (this.findCube(metadata, cubeName) == null) {
            this.createDummyNode(cubeName);
        }
        super.setTreeType(treeType);
        super.setDisplayAllMember(displayAllMember);
    }

    @Override
    public String toString() {
        try {
            return this.cube != null ? this.cube.getName() : this.name;
        }
        catch (OLAPException oe) {
            return null;
        }
    }

    @Override
    public int getChildCount() {
        try {
            if (this.childCount == -1) {
                this.childCount = this.cube.getDimensions().length;
            }
        }
        catch (OLAPException oe) {
            return 0;
        }
        return this.childCount;
    }

    @Override
    protected synchronized boolean populateChildren() {
        try {
            if (this.getChildCount() > 0) {
                DimensionInterface[] dimensions = this.cube.getDimensions();
                this.childCount = dimensions.length;
                for (int j = 0; j < dimensions.length; ++j) {
                    DimensionNode d = new DimensionNode(dimensions[j], this.treeType, this.displayAllMember());
                    super.insert(d, j);
                    d.setParent(this);
                    d.setThreshold(this.threshold);
                }
            }
            this.initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.initialized;
    }

    private CubeInterface findCube(MetadataInterface metadata, String cubeName) {
        try {
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            this.cube = metadata.getCube(filter);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.cube;
    }
}

