/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASMDX.IMDDataSet;
import com.sas.iom.SASMDX.ISession;
import com.sas.models.SequentialCache;
import com.sas.models.StaticCacheInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.Axis;
import com.sas.storage.olap.sasmdx.AxisCache;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.storage.olap.sasmdx.RemoteMetadata;
import com.sas.storage.olap.sasmdx.Tuple;
import com.sas.storage.olap.sasmdx.TupleElement;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.IntHolder;

@SASScope
public class TupleCache
extends SequentialCache {
    private int contextType;
    private AxisInterface axis;
    private String[][] propertyNames;
    private String cubeName;
    private MetadataInterface metadata;
    private OLAPDataSetInterface olapDataSet;
    private ISession _session;
    private AxisCache.TupleReader tupleReader;
    private int tupleCount;
    private String[] dimNames;
    private String[] hierNames;
    private String[] axisHeaders;
    private String[] uniqueLevelNames;
    private int maximumTupleDepth;
    private String CONSTANT_MEASURE = "[Measures].[&ConstMeasure]";
    private static int GROUP_MEASURE_DEPTH = -1;
    private StringBuffer mdxStatement;
    int ancestor;

    public TupleCache(StaticCacheInterface secondaryCache, int maxSize, int lookAheadSize, ISession _session, int contextType, AxisInterface axis, String[][] propertyNames, MetadataInterface metadata) throws OLAPException {
        super(secondaryCache, maxSize, lookAheadSize);
        this.contextType = contextType;
        this.axis = axis;
        this.tupleCount = axis.getTupleCount();
        this.setPropertyNames(propertyNames);
        this._session = _session;
        this.tupleReader = (AxisCache.TupleReader)secondaryCache;
        this.maximumTupleDepth = -1;
        this.metadata = metadata;
    }

    public TupleCache(StaticCacheInterface secondaryCache, int maxSize, int lookAheadSize, AxisInterface axis, String[][] propertyNames, OLAPDataSetInterface olapDataSet) throws OLAPException {
        super(secondaryCache, maxSize, lookAheadSize);
        this.olapDataSet = olapDataSet;
        this.contextType = olapDataSet.getContextType();
        this.axis = axis;
        this.tupleCount = axis.getTupleCount();
        this.setPropertyNames(propertyNames);
        this._session = this.getSession(olapDataSet);
        this.tupleReader = (AxisCache.TupleReader)secondaryCache;
        this.maximumTupleDepth = -1;
        this.metadata = olapDataSet.getDatabaseMetadata();
    }

    private ISession getSession(OLAPDataSetInterface olapDataSet) {
        ISession _session = null;
        try {
            Object o = olapDataSet.getConnection();
            if (o instanceof ISession) {
                _session = (ISession)o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _session;
    }

    private void setPropertyNames(String[][] baseProperties) {
        this.propertyNames = new String[baseProperties.length][];
        for (int j = 0; j < baseProperties.length; ++j) {
            this.propertyNames[j] = new String[baseProperties.length];
            ArrayList<String> a = new ArrayList<String>();
            for (int i = 0; i < baseProperties[j].length; ++i) {
                if (baseProperties[j][i].toUpperCase().indexOf(AxisCache.TOTAL_PROPERTY_KEY) >= 0 || baseProperties[j][i].toUpperCase().indexOf(AxisCache.GROUP_PROPERTY_KEY) >= 0) continue;
                a.add(baseProperties[j][i]);
            }
            this.propertyNames[j] = a.toArray(new String[0]);
        }
    }

    TupleInterface[] getTuplesWithContext(Object[] tuples) throws OLAPException {
        this.ancestor = 1;
        TupleInterface[] currentTuples = new TupleInterface[tuples.length];
        if (tuples == null || tuples.length <= 0) {
            return currentTuples;
        }
        System.arraycopy(tuples, 0, currentTuples, 0, currentTuples.length);
        boolean isContextDefined = false;
        boolean anyContextDefined = false;
        int tupleDepth = ((Axis)this.axis).getTupleDepth();
        ArrayList<String> uniqueLevelHeaders = new ArrayList<String>();
        ISession _nsession = this._session;
        if (_nsession == null) {
            _nsession = RemoteMetadata.createSession(this.metadata);
        }
        ArrayList<TupleElementInterface> elementList = new ArrayList<TupleElementInterface>();
        this.mdxStatement = new StringBuffer();
        ArrayList<TupleElementInterface> totalList = new ArrayList<TupleElementInterface>();
        for (int i = tupleDepth - 1; i >= 0; --i) {
            isContextDefined = false;
            boolean isSameParent = true;
            elementList.clear();
            int maxDepth = 0;
            int minLDepth = 0;
            boolean gmp = false;
            for (int j = 0; j < currentTuples.length; ++j) {
                int levelDepth;
                if (i > 0 && currentTuples[j].getElement(i - 1).isContextual()) continue;
                TupleElementInterface element = currentTuples[j].getElement(i);
                String levelName = element.getUniqueLevelName();
                if (!gmp && element.getType() == TupleElementType.GROUP) {
                    this.processGroupedMeasures(currentTuples, i, uniqueLevelHeaders, levelName);
                    gmp = true;
                    continue;
                }
                if (element.getType() == TupleElementType.TOTAL || element.getType() == TupleElementType.SUBTOTAL) {
                    totalList.add(0, element);
                    continue;
                }
                if (!uniqueLevelHeaders.contains(levelName)) {
                    uniqueLevelHeaders.add(0, levelName);
                }
                if ((levelDepth = element.getLevelDepth()) < minLDepth) {
                    minLDepth = levelDepth;
                }
                if (levelDepth == maxDepth) {
                    if (this.elemBelongsTo(elementList, element.getName()) < 0 && levelDepth > minLDepth && (j == 0 || j > 0 && (!element.isContinued() || element.isContextual()))) {
                        elementList.add(element);
                    }
                } else if (levelDepth > maxDepth) {
                    elementList.clear();
                    elementList.add(element);
                }
                if (levelDepth >= 0 && levelDepth < maxDepth && isSameParent) {
                    isSameParent = false;
                }
                maxDepth = Math.max(levelDepth, maxDepth);
            }
            TupleElementInterface[] al = elementList.toArray(new TupleElementInterface[0]);
            for (int l = 0; l < al.length; ++l) {
                if (this.tupleReader.getAncestorInfo(al[l].getName(), this.ancestor) == null) continue;
                elementList.remove(al[l]);
            }
            String[] axisTupleProperties = null;
            if (elementList.size() >= 1) {
                axisTupleProperties = this.executeParentQuery(_nsession, elementList);
            }
            if (this.needContext(currentTuples, i, axisTupleProperties, elementList, maxDepth) && (isContextDefined = this.hasContext(i, currentTuples, axisTupleProperties, elementList, maxDepth))) {
                anyContextDefined = isContextDefined;
            }
            if (!isContextDefined) continue;
            ++i;
        }
        if (!totalList.isEmpty()) {
            this.processTotals(totalList, uniqueLevelHeaders, currentTuples);
        }
        if (uniqueLevelHeaders.size() > 0 && this.axisHeaders == null || anyContextDefined) {
            if (this.axis.getAxisNumber() == -1) {
                this.setAxisHeaders(uniqueLevelHeaders, currentTuples[0]);
            } else {
                this.setAxisHeaders(uniqueLevelHeaders, null);
            }
        }
        RemoteMetadata.closeSession(_nsession);
        return currentTuples;
    }

    boolean processGroupedMeasures(TupleInterface[] currentTuples, int i, List uniqueLevelHeaders, String levelName) throws OLAPException {
        HashMap<String, String> prop = new HashMap<String, String>(5);
        boolean isContextDefined = false;
        int size = currentTuples.length;
        for (int j = 0; j < size; ++j) {
            TupleElementInterface te = currentTuples[j].getElement(i);
            Map properties = te.getProperties();
            if (properties == null || properties.isEmpty()) continue;
            int cnt = properties.size();
            for (int k = 0; k < cnt; ++k) {
                Set entrySet = properties.entrySet();
                for (Map.Entry entry : entrySet) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    prop.clear();
                    if (value != null && value.length() > 0) {
                        prop.put("MemberUniqueName", value);
                        prop.put("MemberLabel", this.parseName(value));
                        prop.put("LevelUniqueName", name);
                        prop.put("LevelDepth", Integer.toString(GROUP_MEASURE_DEPTH));
                        prop.put("DisplayInfo", "0");
                        currentTuples[j] = this.createContextTuple(i, currentTuples[j], prop, true);
                        isContextDefined = true;
                        if (j != 0) continue;
                        if (levelName != null && !uniqueLevelHeaders.contains(levelName)) {
                            uniqueLevelHeaders.add(0, levelName);
                        }
                        if (uniqueLevelHeaders.contains(name)) continue;
                        uniqueLevelHeaders.add(0, name);
                        continue;
                    }
                    if (te.getType() != TupleElementType.GROUP) continue;
                    Tuple rTuple = new Tuple(currentTuples[j].getAxis(), currentTuples[j].getTupleIndex());
                    TupleElementInterface[] ct = currentTuples[j].getElements(0, -1);
                    TupleElementInterface[] newElements = new TupleElementInterface[ct.length];
                    System.arraycopy(ct, 0, newElements, 0, ct.length);
                    for (int l = 0; l < ct.length; ++l) {
                        if (l != i) continue;
                        newElements[i] = new TupleElement(rTuple, te.getTupleElementIndex(), te.getName(), te.getLabel(), te.getUniqueLevelName(), Integer.toString(te.getLevelDepth()), "0", null, TupleElementType.MEASURE);
                        ((TupleElement)newElements[i]).setChildCount(te.getChildCount());
                        ((TupleElement)newElements[i]).setContextual(te.isContextual());
                        ((TupleElement)newElements[i]).setDrilledDown(te.isDrilledDown());
                        ((TupleElement)newElements[i]).setContinued(te.isContinued());
                        ((TupleElement)newElements[i]).setSpan(2);
                        ((TupleElement)newElements[i]).setSpanDepth(2);
                    }
                    rTuple.setElements(newElements);
                    rTuple.setTupleDepth(newElements.length);
                    currentTuples[j] = rTuple;
                    if (j != 0 || levelName == null || uniqueLevelHeaders.contains(levelName)) continue;
                    uniqueLevelHeaders.add(0, levelName);
                }
            }
        }
        return isContextDefined;
    }

    private void processTotals(List totalList, List uniqueLevelHeaders, TupleInterface[] currentTuples) throws OLAPException {
        int cnt = totalList.size();
        for (int listIndex = 0; listIndex < cnt; ++listIndex) {
            TupleElementInterface totalElement = (TupleElementInterface)totalList.get(listIndex);
            String levelName = totalElement.getUniqueLevelName();
            int index = totalElement.getTupleElementIndex();
            if (!uniqueLevelHeaders.contains(levelName)) {
                TupleElementInterface elem;
                int tupleIndex;
                for (tupleIndex = 0; tupleIndex < currentTuples.length && (index >= currentTuples[tupleIndex].getTupleDepth() || (elem = currentTuples[tupleIndex].getElement(index)).getType() == TupleElementType.SUBTOTAL || elem.getType() == TupleElementType.TOTAL); ++tupleIndex) {
                }
                if (tupleIndex != currentTuples.length) continue;
                uniqueLevelHeaders.add(index, levelName);
                continue;
            }
            int levelIndex = uniqueLevelHeaders.indexOf(levelName);
            if (index <= levelIndex) continue;
            uniqueLevelHeaders.remove(levelIndex);
            uniqueLevelHeaders.add(index, levelName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] executeParentQuery(ISession _session, List tupleElementList) throws OLAPException {
        this.createMDXStatement(tupleElementList);
        StringSeqHolder axisTupleProps = new StringSeqHolder();
        if (this.mdxStatement != null && this.mdxStatement.length() > 0) {
            IntHolder _numAxes = new IntHolder();
            IMDDataSet _mdDataSetContext = null;
            try {
                try {
                    _mdDataSetContext = _session.MDXQuery(this.mdxStatement.toString(), _numAxes);
                }
                catch (Exception ex) {
                    String[] stringArray = axisTupleProps.value;
                    try {
                        if (_mdDataSetContext != null) {
                            _mdDataSetContext.Close();
                        }
                    }
                    catch (GenericError genericError) {
                        // empty catch block
                    }
                    return stringArray;
                }
                int nAxes = _numAxes.value;
                int[] firstTuple = new int[nAxes];
                int[] maxTuples = new int[nAxes];
                boolean[] tuplePropInclusionMask = new boolean[]{};
                LongSeqHolder axisNumRead = new LongSeqHolder();
                for (int k = 0; k < nAxes; ++k) {
                    if (k == 1) {
                        firstTuple[k] = 0;
                        maxTuples[k] = -1;
                        continue;
                    }
                    firstTuple[k] = 0;
                    maxTuples[k] = 0;
                }
                try {
                    _mdDataSetContext.ReadTuples(firstTuple, maxTuples, tuplePropInclusionMask, axisTupleProps, axisNumRead);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (_mdDataSetContext != null) {
                        _mdDataSetContext.Close();
                    }
                }
                catch (GenericError genericError) {}
            }
        }
        return axisTupleProps.value;
    }

    private boolean needContext(TupleInterface[] currentTuples, int i, String[] axisTupleProperties, List elementList, int maxDepth) throws OLAPException {
        int axisTuplePropsOffset = 0;
        int offset = 0;
        String savedMemberUniqueName = null;
        String memberUniqueName = null;
        TupleElementInterface savedElement = null;
        int u = 0;
        boolean isTotal = false;
        while (u < currentTuples.length) {
            TupleElementInterface currentElement = currentTuples[u].getElement(i);
            if (currentElement.getType() == TupleElementType.TOTAL || currentElement.getType() == TupleElementType.SUBTOTAL) {
                ++u;
                isTotal = true;
                continue;
            }
            Map cachedProp = null;
            String currentElementName = currentElement.getName();
            offset = this.elemBelongsTo(elementList, currentElementName);
            int currentDepth = currentElement.getLevelDepth();
            if (currentDepth >= 0 && offset >= 0 && axisTupleProperties != null) {
                axisTuplePropsOffset = (5 + this.propertyNames[i].length) * offset;
                memberUniqueName = axisTupleProperties[axisTuplePropsOffset];
                savedElement = currentElement;
            } else if (currentDepth >= 0) {
                cachedProp = this.tupleReader.getAncestorInfo(currentElement.getName(), this.ancestor);
                if (cachedProp != null) {
                    memberUniqueName = (String)cachedProp.get("MemberUniqueName");
                } else if (currentElement.isContinued() && currentDepth == maxDepth) {
                    if (savedElement != null && (cachedProp = this.tupleReader.getAncestorInfo(savedElement.getName(), this.ancestor)) != null) {
                        memberUniqueName = (String)cachedProp.get("MemberUniqueName");
                    }
                } else {
                    memberUniqueName = null;
                }
            } else {
                memberUniqueName = null;
            }
            if (savedMemberUniqueName == null) {
                savedMemberUniqueName = memberUniqueName;
            }
            if (memberUniqueName == null || !savedMemberUniqueName.equals(memberUniqueName)) break;
            ++u;
        }
        return u != currentTuples.length || !isTotal && !Util.equal(savedMemberUniqueName, memberUniqueName);
    }

    private int elemBelongsTo(List elementList, String name) throws OLAPException {
        if (elementList != null && !elementList.isEmpty()) {
            int cnt = elementList.size();
            for (int i = 0; i < cnt; ++i) {
                if (!name.equals(((TupleElementInterface)elementList.get(i)).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean hasContext(int i, TupleInterface[] currentTuples, String[] axisTupleProperties, List elementList, int maxDepth) throws OLAPException {
        int axisTuplePropsOffset = 0;
        boolean isContextDefined = false;
        TupleElementInterface savedElement = null;
        for (int k = 0; k < currentTuples.length; ++k) {
            boolean found = false;
            HashMap<String, Object> cachedProp = null;
            TupleElementInterface currentElement = currentTuples[k].getElement(i);
            String currentElementName = currentElement.getName();
            int offset = this.elemBelongsTo(elementList, currentElementName);
            int currentDepth = currentElement.getLevelDepth();
            if (currentDepth > 0 && offset >= 0 && axisTupleProperties != null && currentDepth == maxDepth) {
                axisTuplePropsOffset = (5 + this.propertyNames[i].length) * offset;
                HashMap<String, Object> prop = new HashMap<String, Object>(5);
                prop.put("MemberUniqueName", axisTupleProperties[axisTuplePropsOffset]);
                prop.put("MemberLabel", axisTupleProperties[axisTuplePropsOffset + 1]);
                prop.put("LevelUniqueName", axisTupleProperties[axisTuplePropsOffset + 2]);
                prop.put("LevelDepth", axisTupleProperties[axisTuplePropsOffset + 3]);
                prop.put("DisplayInfo", axisTupleProperties[axisTuplePropsOffset + 4]);
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(this.propertyNames[i].length);
                for (int k1 = 0; k1 < this.propertyNames[i].length; ++k1) {
                    properties.put(this.propertyNames[i][k1], axisTupleProperties[axisTuplePropsOffset + 5 + k1]);
                }
                prop.put("Properties", properties);
                this.tupleReader.setAncestorInfo(currentElement.getName(), this.ancestor, prop);
                cachedProp = prop;
                savedElement = currentElement;
                found = true;
            } else if (currentDepth > 0) {
                cachedProp = this.tupleReader.getAncestorInfo(currentElement.getName(), this.ancestor);
                if (cachedProp != null) {
                    found = true;
                } else if (currentElement.isContinued() && currentDepth == maxDepth && savedElement != null && (cachedProp = this.tupleReader.getAncestorInfo(savedElement.getName(), this.ancestor)) != null) {
                    this.tupleReader.setAncestorInfo(currentElement.getName(), this.ancestor, cachedProp);
                    found = true;
                }
            }
            if (found) {
                currentTuples[k] = this.createContextTuple(i, currentTuples[k], cachedProp, false);
                isContextDefined = true;
                continue;
            }
            currentTuples[k] = this.createNonContextTuple(i, currentTuples[k]);
            savedElement = null;
        }
        return isContextDefined;
    }

    private TupleInterface createContextTuple(int i, TupleInterface currentTuple, Map prop, boolean isGroupElement) throws OLAPException {
        Tuple rTuple = new Tuple(currentTuple.getAxis(), currentTuple.getTupleIndex());
        int tupleDepth = currentTuple.getTupleDepth();
        TupleElementInterface[] newElements = new TupleElementInterface[tupleDepth + 1];
        int insertOffset = 0;
        for (int l = 0; l < tupleDepth; ++l) {
            TupleElementInterface ce = currentTuple.getElement(l);
            if (l + insertOffset != i) {
                newElements[l + insertOffset] = ce;
                ((TupleElement)newElements[l + insertOffset]).setTupleElementIndex(l + insertOffset);
                if (((TupleElement)newElements[l + insertOffset]).getType() == TupleElementType.GROUP && !((TupleElement)newElements[l + insertOffset]).isContextual() && l + insertOffset > 0 && ((TupleElement)newElements[l + insertOffset - 1]).isContextual()) {
                    newElements[l + insertOffset] = new TupleElement(rTuple, l + insertOffset, ce.getName(), ce.getLabel(), ce.getUniqueLevelName(), Integer.toString(ce.getLevelDepth()), "0", null);
                    ((TupleElement)newElements[l + insertOffset]).setType(TupleElementType.MEASURE);
                }
                ((TupleElement)newElements[l + insertOffset]).setTuple(rTuple);
                continue;
            }
            newElements[l] = new TupleElement(rTuple, i, (String)prop.get("MemberUniqueName"), (String)prop.get("MemberLabel"), (String)prop.get("LevelUniqueName"), (String)prop.get("LevelDepth"), (String)prop.get("DisplayInfo"), (Map)prop.get("Properties"));
            ((TupleElement)newElements[l--]).setContextual(true);
            if (isGroupElement) {
                ((TupleElement)newElements[l + 1]).setType(TupleElementType.GROUP);
            }
            ++insertOffset;
        }
        rTuple.setElements(newElements);
        rTuple.setTupleDepth(newElements.length);
        this.maximumTupleDepth = newElements.length;
        return rTuple;
    }

    private TupleInterface createNonContextTuple(int i, TupleInterface currentTuple) throws OLAPException {
        int tupleDepth = currentTuple.getTupleDepth();
        for (int l = 0; l < tupleDepth; ++l) {
            TupleElementInterface ce = currentTuple.getElement(l);
            if (ce.getType() == TupleElementType.MEASURE) continue;
            ((TupleElement)ce).setSpan(1);
        }
        return currentTuple;
    }

    private void createMDXStatement(List elementList) throws OLAPException {
        String id;
        this.mdxStatement.delete(0, this.mdxStatement.length());
        if (elementList.size() > 0) {
            if (this.cubeName == null) {
                this.cubeName = this.tupleReader.getCubeNameHint();
            }
            this.mdxStatement.append("WITH MEMBER ");
            this.mdxStatement.append(this.CONSTANT_MEASURE);
            this.mdxStatement.append(" AS '2' ");
            this.mdxStatement.append("SELECT {");
            Iterator iterator = elementList.iterator();
            Iterator iter2 = elementList.iterator();
            while (iterator.hasNext()) {
                String name = ((TupleElementInterface)iterator.next()).getName();
                this.mdxStatement.append("ANCESTOR( ");
                this.mdxStatement.append(name);
                this.mdxStatement.append(", ");
                this.mdxStatement.append(this.ancestor);
                this.mdxStatement.append("),");
            }
            if (this.mdxStatement.charAt(this.mdxStatement.length() - 1) == ',') {
                this.mdxStatement.deleteCharAt(this.mdxStatement.length() - 1);
                this.mdxStatement.append("} ");
                TupleElement element = (TupleElement)iter2.next();
                Map m = element.getProperties();
                String propName = "";
                if (m != null && !m.isEmpty()) {
                    Iterator i = m.keySet().iterator();
                    while (i.hasNext()) {
                        String pn = (String)i.next();
                        if (pn.indexOf(AxisCache.GROUP_PROPERTY_KEY) >= 0) continue;
                        propName = propName + pn;
                        if (!i.hasNext()) continue;
                        propName = propName + ", ";
                    }
                }
                if (propName.length() > 0) {
                    this.mdxStatement.append("DIMENSION PROPERTIES ");
                    this.mdxStatement.append(propName);
                }
                this.mdxStatement.append(" ON ROWS ");
                this.mdxStatement.append(", ");
                this.mdxStatement.append(this.CONSTANT_MEASURE);
                this.mdxStatement.append(" ON COLUMNS ");
                this.mdxStatement.append("FROM ");
                this.mdxStatement.append("[");
                this.mdxStatement.append(this.cubeName);
                this.mdxStatement.append("]");
            }
        }
        if (this.mdxStatement != null && this.olapDataSet != null && this.olapDataSet instanceof OLAPDataSet && (id = ((OLAPDataSet)this.olapDataSet).getQueryId()) != null) {
            this.mdxStatement.append(id);
        }
    }

    void setAxisHeaders(List levelNamesList, TupleInterface tuple) throws OLAPException {
        if (levelNamesList == null) {
            this.axisHeaders = null;
            return;
        }
        int cnt = levelNamesList.size();
        ArrayList<LevelInterface> levelsList = new ArrayList<LevelInterface>(cnt);
        String[][] headersList = new String[4][cnt];
        this.axisHeaders = new String[cnt];
        this.uniqueLevelNames = new String[cnt];
        if (this.contextType == 0) {
            Filter levelFilter = new Filter();
            if (this.cubeName == null) {
                this.cubeName = this.tupleReader.getCubeNameHint();
            }
            if (this.cubeName != null) {
                levelFilter.setCubeName(this.cubeName);
            }
            for (int m = 0; m < cnt; ++m) {
                String levelUName = (String)levelNamesList.get(m);
                levelFilter.setUniqueLevelName(levelUName);
                if (this.metadata == null) {
                    this.metadata = new Metadata(this._session);
                }
                LevelInterface level = null;
                level = ((Metadata)this.metadata).getLevel(levelFilter);
                int size = levelsList.size();
                if (level == null && m + 1 < cnt) {
                    String name = levelUName;
                    levelUName = (String)levelNamesList.get(++m);
                    levelFilter.setUniqueLevelName(levelUName);
                    level = ((Metadata)this.metadata).getLevel(levelFilter);
                    if (level != null) {
                        GroupLevel groupLevel = new GroupLevel(name, name, level.getDepth() - 1, level.getHierarchy());
                        levelsList.add(m - 1, groupLevel);
                        levelsList.add(m, level);
                        continue;
                    }
                }
                int insertIndex = levelsList.size();
                for (int i = levelsList.size() - 1; i >= 0; --i) {
                    LevelInterface tempL = (LevelInterface)levelsList.get(i);
                    if (!level.getHierarchy().getUniqueName().equals(tempL.getHierarchy().getUniqueName()) || level.getDepth() >= tempL.getDepth()) continue;
                    --insertIndex;
                }
                levelsList.add(insertIndex, level);
            }
            int size = levelsList.size();
            for (int k = 0; k < size; ++k) {
                LevelInterface l = (LevelInterface)levelsList.get(k);
                HierarchyInterface hier = l.getHierarchy();
                headersList[0][k] = hier.getUniqueName();
                DimensionInterface dim = hier.getDimension();
                if (tuple != null) {
                    if (dim.getType() == 2) {
                        ((TupleElement)tuple.getElements(k, 1)[0]).setType(TupleElementType.MEASURE);
                    } else {
                        ((TupleElement)tuple.getElements(k, 1)[0]).setType(TupleElementType.UNSPECIFIED);
                    }
                }
                headersList[1][k] = dim.getName();
                headersList[2][k] = l.getLabel();
                headersList[3][k] = l.getUniqueName();
            }
        } else {
            for (int i = 0; i < headersList.length; ++i) {
                Arrays.fill(headersList[i], "");
            }
        }
        this.hierNames = headersList[0];
        this.dimNames = headersList[1];
        this.axisHeaders = headersList[2];
        this.uniqueLevelNames = headersList[3];
        this.maximumTupleDepth = headersList[0].length;
    }

    public int getMaximumTupleDepth() throws OLAPException {
        if (this.tupleCount == 0) {
            this.maximumTupleDepth = 0;
        }
        if (this.maximumTupleDepth == -1) {
            this.axis.getTuples(0, 1);
        }
        return this.maximumTupleDepth;
    }

    void setMaximumTupleDepth(int depth) {
        this.maximumTupleDepth = depth;
    }

    public String[] getUniqueLevelNames() throws OLAPException {
        if (this.uniqueLevelNames == null && this.tupleCount > 0) {
            this.axis.getTuples(0, 1);
        }
        return this.uniqueLevelNames == null || this.tupleCount == 0 ? OLAPUtil.EMPTY_STRING_ARRAY : this.uniqueLevelNames;
    }

    public String[] getAxisHeaders() throws OLAPException {
        if (this.axisHeaders == null && this.tupleCount > 0) {
            this.axis.getTuples(0, 1);
        }
        return this.axisHeaders == null || this.tupleCount == 0 ? OLAPUtil.EMPTY_STRING_ARRAY : this.axisHeaders;
    }

    public String[] getDimensionNames() throws OLAPException {
        if (this.dimNames == null && this.tupleCount > 0) {
            this.axis.getTuples(0, 1);
        }
        return this.dimNames == null || this.tupleCount == 0 ? OLAPUtil.EMPTY_STRING_ARRAY : this.dimNames;
    }

    public String[] getHierarchyNames() throws OLAPException {
        if (this.hierNames == null && this.tupleCount > 0) {
            this.axis.getTuples(0, 1);
        }
        return this.hierNames == null || this.tupleCount == 0 ? OLAPUtil.EMPTY_STRING_ARRAY : this.hierNames;
    }

    public void setAxis(AxisInterface axis) {
        this.axis = axis;
    }

    private String parseName(String uniqueName) {
        String label = uniqueName;
        int lastClosingIndex = uniqueName.lastIndexOf("]");
        if (lastClosingIndex < 0) {
            return label;
        }
        int lastOpenIndex = uniqueName.lastIndexOf("[");
        if (lastOpenIndex < 0) {
            return label;
        }
        label = uniqueName.substring(lastOpenIndex + 1, lastClosingIndex);
        return label;
    }

    class GroupLevel
    implements LevelInterface {
        String uniqueName;
        String label;
        int depth;
        HierarchyInterface hierarchy;

        public GroupLevel(String label, String uniqueName, int depth, HierarchyInterface hierarchy) {
            this.label = TupleCache.this.parseName(label);
            this.uniqueName = uniqueName;
            this.depth = depth;
            this.hierarchy = hierarchy;
        }

        @Override
        public CubeInterface getCube() throws OLAPException {
            return this.hierarchy.getCube();
        }

        @Override
        public int getDepth() throws OLAPException {
            return this.depth;
        }

        @Override
        public Filter getFilter() throws OLAPException {
            return null;
        }

        @Override
        public HierarchyInterface getHierarchy() throws OLAPException {
            return this.hierarchy;
        }

        @Override
        public int getMemberCount() throws OLAPException {
            return 0;
        }

        @Override
        public MemberInterface[] getMembers(int index, int count) throws OLAPException {
            return null;
        }

        @Override
        public MemberInterface[] getMembers() throws OLAPException {
            return null;
        }

        @Override
        public PropertyInterface[] getProperties() throws OLAPException {
            return null;
        }

        @Override
        public int getType() throws OLAPException {
            return 32768;
        }

        @Override
        public Date getCreationDateTime() throws OLAPException {
            return null;
        }

        @Override
        public String getDescription() throws OLAPException {
            return null;
        }

        @Override
        public String getLabel() throws OLAPException {
            return this.label;
        }

        @Override
        public MetadataInterface getMetadata() throws OLAPException {
            return null;
        }

        @Override
        public String getName() throws OLAPException {
            return this.label;
        }

        @Override
        public String getUniqueName() throws OLAPException {
            return this.uniqueName;
        }

        @Override
        public Date getUpdateDateTime() throws OLAPException {
            return null;
        }
    }
}

