/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;

@SASScope(value="ALL")
public class Tuple
implements TupleInterface {
    @SASScope
    protected AxisInterface axis;
    @SASScope
    protected int tupleIndex;
    @SASScope
    protected int tupleDepth;
    @SASScope
    protected TupleElementInterface[] tupleElements;

    @SASScope
    public Tuple(AxisInterface axis, int tupleIndex) throws OLAPException {
        this.axis = axis;
        this.tupleIndex = tupleIndex;
    }

    @Override
    public AxisInterface getAxis() throws OLAPException {
        return this.axis;
    }

    @SASScope
    public int getTupleCoordinate() throws OLAPException {
        return this.getTupleIndex();
    }

    @Override
    public int getTupleIndex() throws OLAPException {
        return this.tupleIndex;
    }

    @Override
    public int getTupleDepth() throws OLAPException {
        return this.tupleDepth;
    }

    @Override
    public TupleElementInterface[] getElements(int index, int count) throws OLAPException {
        count = count == -1 ? this.getTupleDepth() - index : count;
        TupleElementInterface[] requestedTupleElements = new TupleElementInterface[count];
        System.arraycopy(this.tupleElements, index, requestedTupleElements, 0, count);
        return requestedTupleElements;
    }

    @Override
    public TupleElementInterface getElement(int index) throws OLAPException {
        if (index >= 0 && index < this.tupleElements.length) {
            return this.tupleElements[index];
        }
        throw new IllegalArgumentException("Invalid Index");
    }

    void setTupleIndex(int tupleIndex) {
        this.tupleIndex = tupleIndex;
    }

    void setTupleDepth(int tupleDepth) {
        this.tupleDepth = tupleDepth;
    }

    void setElements(TupleElementInterface[] tupleElements) {
        this.tupleElements = tupleElements;
    }
}

