/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.AxisCache;
import com.sas.storage.olap.sasmdx.DataCache;

@SASScope(value="ALL")
public class ResultSetMetadata
implements ResultSetMetadataInterface {
    @SASScope
    protected ResultSetInterface resultSet;
    @SASScope
    protected DataCache cache;

    @SASScope
    public ResultSetMetadata() throws OLAPException {
        this(null, null);
    }

    @SASScope
    public ResultSetMetadata(DataCache cache, ResultSetInterface resultSet) throws OLAPException {
        this.cache = cache;
        this.resultSet = resultSet;
    }

    @Override
    public ResultSetInterface getResultSet() throws OLAPException {
        return this.resultSet;
    }

    @Override
    public AxisInterface getAxis(int index) throws OLAPException {
        AxisCache[] axesCaches = this.cache.getAxisCache(index, 1);
        if (axesCaches == null) {
            return null;
        }
        return axesCaches[0].getAxis();
    }

    @Override
    public AxisInterface[] getAxes(int index, int count) throws OLAPException {
        AxisCache[] axesCaches = this.cache.getAxisCache(index, count);
        if (axesCaches == null) {
            return null;
        }
        AxisInterface[] requestedAxes = new AxisInterface[axesCaches.length];
        for (int i = 0; i < axesCaches.length; ++i) {
            requestedAxes[i] = axesCaches[i].getAxis();
        }
        return requestedAxes;
    }

    @Override
    public TupleInterface[] getTuples(int axisNumber, int index, int count) throws OLAPException {
        AxisInterface[] tempAxis = this.getAxes(axisNumber, 1);
        TupleInterface[] tempTuples = tempAxis[0].getTuples(index, count);
        return tempTuples;
    }

    @Override
    public TupleElementInterface[] getElements(int axisNumber, int tupleCoordinate, int index, int count) throws OLAPException {
        AxisInterface[] tempAxis = this.getAxes(axisNumber, 1);
        TupleInterface[] tempTuple = tempAxis[0].getTuples(tupleCoordinate, 1);
        TupleElementInterface[] tempElements = tempTuple[0].getElements(index, count);
        return tempElements;
    }
}

