/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.DoubleSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.ShortSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.SASMDX.EmptySet;
import com.sas.iom.SASMDX.ICubeSet;
import com.sas.iom.SASMDX.IDimSet;
import com.sas.iom.SASMDX.IHierSet;
import com.sas.iom.SASMDX.ILvlSet;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMeasureSet;
import com.sas.iom.SASMDX.IMemSet;
import com.sas.iom.SASMDX.IPropSet;
import com.sas.iom.SASMDX.ISchemaSet;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.MemType;
import com.sas.iom.SASMDX.PropType;
import com.sas.models.CacheException;
import com.sas.models.CacheInterface;
import com.sas.models.SparseCache;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.MetadataPerformanceTuning;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.SchemaInterface;
import com.sas.storage.olap.sasmdx.Cube;
import com.sas.storage.olap.sasmdx.Dimension;
import com.sas.storage.olap.sasmdx.Hierarchy;
import com.sas.storage.olap.sasmdx.Level;
import com.sas.storage.olap.sasmdx.Measure;
import com.sas.storage.olap.sasmdx.Member;
import com.sas.storage.olap.sasmdx.MembersCache;
import com.sas.storage.olap.sasmdx.Property;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.omg.CORBA.ShortHolder;

@SASScope
public class RemoteMetadata {
    private static final int CUBE_TYPE = 0;
    private static final int DIMENSION_TYPE = 1;
    private static final int HIERARCHY_TYPE = 2;
    private static final int LEVEL_TYPE = 3;
    private static final int MEASURE_TYPE = 4;
    private static final int PROPERTY_TYPE = 5;
    protected static boolean[] schemaFieldInclusion = new boolean[]{true, true, true, false, false, false};
    protected static boolean[] cubeFieldInclusion = new boolean[]{true, true, true, true, false, false, true, false, false, false, false, false, true, false, true, true};
    protected static boolean[] dimensionFieldInclusion = new boolean[]{true, true, true, true, true, false, true, false, true, true, true, true, false};
    protected static boolean[] hierarchyFieldInclusion = new boolean[]{true, true, true, true, true, true, false, true, false, true, true, true, true, true, false};
    protected static boolean[] levelFieldInclusion = new boolean[]{true, true, true, true, true, true, true, false, true, true, true, true, true, false};
    protected static boolean[] measureFieldInclusion = new boolean[]{true, true, true, true, true, true, false, true, true, true, true, true, true};
    protected static boolean[] propertyFieldInclusion = new boolean[]{false, false, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false};
    public static boolean[] memberFieldInclusion = new boolean[]{true, true, true, true, true, true, true, false, true, true, true, false, true, true, false, true, false, false, true, true, false, false};
    private static boolean[] dimensionInitFieldInclusion = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false};
    private static boolean[] hierarchyInitFieldInclusion = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false};
    private static boolean[] levelInitFieldInclusion = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false};
    private static boolean[] measureInitFieldInclusion = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false};
    protected static boolean[] propertyInitFieldInclusion = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    protected static StringSeqHolder excludedStringProp = new StringSeqHolder();
    protected static LongSeqHolder excludedLongProp = new LongSeqHolder();
    protected static DateTimeSeqHolder excludedDateTimeProp = new DateTimeSeqHolder();
    protected static UUIDSeqHolder excludedUUIDProp = new UUIDSeqHolder();
    protected static ShortHolder excludedShortProp = new ShortHolder();
    protected static ShortSeqHolder excludedShortSeqProp = new ShortSeqHolder();
    protected static DoubleSeqHolder excludedDoubleProp = new DoubleSeqHolder();
    private static final boolean DEBUG = false;
    private static int cacheSize = 100;
    private static CacheInterface cache = new SparseCache(null, null, cacheSize, -1);
    private static MembersCache membersCache;
    private static MetadataPerformanceTuning performanceTuning;
    private static Vector sessionList;

    private RemoteMetadata() {
    }

    public static synchronized void setCacheSize(int maxSize) throws OLAPException {
        try {
            cache.configureCache(maxSize, -1, -1, -1, -1);
        }
        catch (CacheException ce) {
            throw new OLAPException(ce);
        }
    }

    public static int SchemaMetadata(ISession _session, String catalogNameFilter, String nameFilter, StringSeqHolder schemaNames) throws OLAPException {
        int nSchemas = 0;
        try {
            ISchemaSet _schemaSet = _session.SchemaMetadata(catalogNameFilter, nameFilter, "", schemaFieldInclusion);
            nSchemas = _schemaSet.ReadRows(0, -1, excludedStringProp, schemaNames, excludedStringProp, excludedStringProp, excludedStringProp, excludedStringProp);
            _schemaSet.Close();
        }
        catch (Exception e) {
            throw new OLAPException(e, OLAPUtil.getExceptionMessage(e));
        }
        return nSchemas;
    }

    public static CubeInterface getCube(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getCubeMetadata(metadata, _session, filter)[0];
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 0);
        if (cachedCube == null) {
            CubeInterface[] cubes = RemoteMetadata.getCubeMetadata(metadata, _session, filter);
            if (cubes != null && cubes.length > 0) {
                return cubes[0];
            }
            return null;
        }
        return cachedCube.cubes[0];
    }

    public static CubeInterface[] CubeMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getCubeMetadata(metadata, _session, filter);
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 0);
        if (cachedCube == null) {
            return RemoteMetadata.getCubeMetadata(metadata, _session, filter);
        }
        return cachedCube.cubes;
    }

    private static boolean isCompatible(CubeInterface cube, Filter filter) throws OLAPException {
        String name = filter.getNormalizedCubeName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0 && cube != null) {
            isCompatible = cube.getNormalizedName().equals(name);
        }
        return isCompatible;
    }

    public static DimensionInterface getDimension(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getDimensionMetadata(metadata, _session, filter)[0];
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 1);
        if (cachedCube == null) {
            return RemoteMetadata.getDimensionMetadata(metadata, _session, filter)[0];
        }
        DimensionInterface[] cachedDimensions = cachedCube.dimensions;
        for (int i = 0; i < cachedDimensions.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedDimensions[i], filter)) continue;
            return cachedDimensions[i];
        }
        return null;
    }

    public static DimensionInterface[] DimMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getDimensionMetadata(metadata, _session, filter);
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 1);
        if (cachedCube == null) {
            return RemoteMetadata.getDimensionMetadata(metadata, _session, filter);
        }
        DimensionInterface[] cachedDimensions = cachedCube.dimensions;
        ArrayList<DimensionInterface> returnList = new ArrayList<DimensionInterface>(10);
        for (int i = 0; i < cachedDimensions.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedDimensions[i], filter)) continue;
            returnList.add(cachedDimensions[i]);
        }
        return returnList.toArray(new DimensionInterface[returnList.size()]);
    }

    private static boolean isCompatible(DimensionInterface dimension, Filter filter) throws OLAPException {
        String name = filter.getDimensionName();
        String uniqueName = filter.getUniqueDimensionName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = dimension.getName().equals(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = dimension.getUniqueName().equals(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        return RemoteMetadata.isCompatible(dimension.getCube(), filter);
    }

    public static MeasureInterface[] MeasureMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getMeasureMetadata(metadata, _session, filter);
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 4);
        if (cachedCube == null) {
            return RemoteMetadata.getMeasureMetadata(metadata, _session, filter);
        }
        MeasureInterface[] cachedMeasures = cachedCube.measures;
        ArrayList<MeasureInterface> returnList = new ArrayList<MeasureInterface>(10);
        for (int i = 0; i < cachedMeasures.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedMeasures[i], filter)) continue;
            returnList.add(cachedMeasures[i]);
        }
        return returnList.toArray(new MeasureInterface[returnList.size()]);
    }

    public static MeasureInterface getMeasure(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getMeasureMetadata(metadata, _session, filter)[0];
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 4);
        if (cachedCube == null) {
            return RemoteMetadata.getMeasureMetadata(metadata, _session, filter)[0];
        }
        MeasureInterface[] cachedMeasures = cachedCube.measures;
        for (int i = 0; i < cachedMeasures.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedMeasures[i], filter)) continue;
            return cachedMeasures[i];
        }
        return null;
    }

    private static boolean isCompatible(MeasureInterface measure, Filter filter) throws OLAPException {
        String name = filter.getMeasureName();
        String uniqueName = filter.getUniqueMeasureName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = measure.getName().equalsIgnoreCase(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = measure.getUniqueName().equalsIgnoreCase(uniqueName);
        }
        return isCompatible;
    }

    public static HierarchyInterface getHierarchy(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getHierarchyMetadata(metadata, _session, filter)[0];
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 2);
        if (cachedCube == null) {
            return RemoteMetadata.getHierarchyMetadata(metadata, _session, filter)[0];
        }
        HierarchyInterface[] cachedHierarchies = cachedCube.hierarchies;
        for (int i = 0; i < cachedHierarchies.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedHierarchies[i], filter)) continue;
            return cachedHierarchies[i];
        }
        return null;
    }

    public static HierarchyInterface[] HierMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getHierarchyMetadata(metadata, _session, filter);
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 2);
        if (cachedCube == null) {
            return RemoteMetadata.getHierarchyMetadata(metadata, _session, filter);
        }
        HierarchyInterface[] cachedHierarchies = cachedCube.hierarchies;
        ArrayList<HierarchyInterface> returnList = new ArrayList<HierarchyInterface>();
        for (int i = 0; i < cachedHierarchies.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedHierarchies[i], filter)) continue;
            returnList.add(cachedHierarchies[i]);
        }
        return returnList.toArray(new HierarchyInterface[returnList.size()]);
    }

    private static boolean isCompatible(HierarchyInterface hierarchy, Filter filter) throws OLAPException {
        String name = filter.getHierarchyName();
        String uniqueName = filter.getUniqueHierarchyName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = hierarchy.getName().equals(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = hierarchy.getUniqueName().equals(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        return RemoteMetadata.isCompatible(hierarchy.getDimension(), filter);
    }

    public static LevelInterface getLevel(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getLevelMetadata(metadata, _session, filter)[0];
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 3);
        if (cachedCube == null) {
            return RemoteMetadata.getLevelMetadata(metadata, _session, filter)[0];
        }
        LevelInterface[] cachedLevels = cachedCube.levels;
        for (int i = 0; i < cachedLevels.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedLevels[i], filter)) continue;
            return cachedLevels[i];
        }
        return null;
    }

    public static LevelInterface[] LvlMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getLevelMetadata(metadata, _session, filter);
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 3);
        if (cachedCube == null) {
            return RemoteMetadata.getLevelMetadata(metadata, _session, filter);
        }
        LevelInterface[] cachedLevels = cachedCube.levels;
        ArrayList<LevelInterface> returnList = new ArrayList<LevelInterface>();
        for (int i = 0; i < cachedLevels.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedLevels[i], filter)) continue;
            returnList.add(cachedLevels[i]);
        }
        return returnList.toArray(new LevelInterface[returnList.size()]);
    }

    private static boolean isCompatible(LevelInterface level, Filter filter) throws OLAPException {
        String name = filter.getLevelName();
        String uniqueName = filter.getUniqueLevelName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = level.getName().equals(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = level.getUniqueName().equals(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        return RemoteMetadata.isCompatible(level.getHierarchy(), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MemberInterface[] MemMetadata(MetadataInterface metadata, ISession _session, Filter filter, int start, int count) throws OLAPException {
        List<Member> members;
        block20: {
            members = new ArrayList();
            if (performanceTuning.useCache() && _session != null) {
                try {
                    membersCache = RemoteMetadata.getMembersCache();
                    members = membersCache.getMembers(metadata, _session, filter, start, count);
                }
                catch (CacheException ce) {
                    throw new OLAPException(ce, OLAPUtil.getExceptionMessage(ce));
                }
            }
            int nMembers = 0;
            ISession _nsession = null;
            IMemSet _memSet = null;
            StringSeqHolder catalogNames = new StringSeqHolder();
            StringSeqHolder schemaNames = new StringSeqHolder();
            StringSeqHolder cubeNames = new StringSeqHolder();
            StringSeqHolder uniqueDimensionNames = new StringSeqHolder();
            StringSeqHolder uniqueHierarchyNames = new StringSeqHolder();
            StringSeqHolder uniqueLevelNames = new StringSeqHolder();
            LongSeqHolder lvlDepths = new LongSeqHolder();
            StringSeqHolder names = new StringSeqHolder();
            StringSeqHolder uniqueNames = new StringSeqHolder();
            StringSeqHolder labels = new StringSeqHolder();
            LongSeqHolder types = new LongSeqHolder();
            LongSeqHolder nChildren = new LongSeqHolder();
            StringSeqHolder parentMembers = new StringSeqHolder();
            LongSeqHolder propertyDataTypes = new LongSeqHolder();
            VariableArray2dOfStringHolder propertyNames = new VariableArray2dOfStringHolder();
            _nsession = RemoteMetadata.createSession(metadata);
            boolean defaultSharedDim = memberFieldInclusion[memberFieldInclusion.length - 1];
            RemoteMetadata.memberFieldInclusion[RemoteMetadata.memberFieldInclusion.length - 1] = filter.hasIncludeSharedDimensions();
            _memSet = _nsession.MemMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getUniqueHierarchyName(), filter.getUniqueLevelName(), filter.getLevelNumber(), filter.getMemberName(), filter.getUniqueMemberName(), filter.getMemberLabel(), MemType.from_int((int)filter.getMemberType()), filter.getTreeOperator(), memberFieldInclusion);
            nMembers = _memSet.ReadRows(start, count, catalogNames, schemaNames, cubeNames, uniqueDimensionNames, uniqueHierarchyNames, uniqueLevelNames, lvlDepths, excludedLongProp, names, uniqueNames, types, excludedUUIDProp, labels, nChildren, excludedLongProp, parentMembers, excludedLongProp, excludedStringProp, propertyDataTypes, propertyNames);
            RemoteMetadata.memberFieldInclusion[RemoteMetadata.memberFieldInclusion.length - 1] = defaultSharedDim;
            for (int i = 0; i < nMembers; ++i) {
                Member member = new Member(metadata, _session, catalogNames.value[i], schemaNames.value[i], cubeNames.value[i], uniqueDimensionNames.value[i], uniqueHierarchyNames.value[i], uniqueLevelNames.value[i], lvlDepths.value[i], names.value[i], uniqueNames.value[i], labels.value[i], types.value[i], nChildren.value[i], parentMembers.value[i], 0, null);
                members.add(member);
            }
            try {
                if (_memSet != null) {
                    _memSet.Close();
                }
            }
            catch (GenericError ge) {
                System.out.println("Unable to close the member Rowset");
            }
            if (_nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
            break block20;
            catch (Exception ge) {
                try {
                    if (_memSet != null) {
                        _memSet.Close();
                    }
                }
                catch (GenericError ge2) {
                    System.out.println("Unable to close the member Rowset");
                }
                if (_nsession != null) {
                    RemoteMetadata.closeSession(_nsession);
                }
                catch (Throwable throwable) {
                    try {
                        if (_memSet != null) {
                            _memSet.Close();
                        }
                    }
                    catch (GenericError ge3) {
                        System.out.println("Unable to close the member Rowset");
                    }
                    if (_nsession != null) {
                        RemoteMetadata.closeSession(_nsession);
                    }
                    throw throwable;
                }
            }
        }
        return members.toArray(new MemberInterface[0]);
    }

    private static MembersCache getMembersCache() {
        if (membersCache == null) {
            membersCache = new MembersCache(performanceTuning.bufferSize(), performanceTuning.lookAhead(), performanceTuning.maxFilters());
        }
        return membersCache;
    }

    public static PropertyInterface getProperty(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getPropertyMetadata(metadata, _session, filter)[0];
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 5);
        if (cachedCube == null) {
            return RemoteMetadata.getPropertyMetadata(metadata, _session, filter)[0];
        }
        PropertyInterface[] cachedProps = cachedCube.properties;
        for (int i = 0; i < cachedProps.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedProps[i], filter)) continue;
            return cachedProps[i];
        }
        return null;
    }

    public static PropertyInterface[] PropMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        if (!performanceTuning.useCache()) {
            return RemoteMetadata.getPropertyMetadata(metadata, _session, filter);
        }
        CubeSlice cachedCube = RemoteMetadata.getCachedCube(metadata, _session, filter, 5);
        if (cachedCube == null) {
            return RemoteMetadata.getPropertyMetadata(metadata, _session, filter);
        }
        PropertyInterface[] cachedProps = cachedCube.properties;
        ArrayList<PropertyInterface> returnList = new ArrayList<PropertyInterface>(3);
        for (int i = 0; i < cachedProps.length; ++i) {
            if (!RemoteMetadata.isCompatible(cachedProps[i], filter)) continue;
            returnList.add(cachedProps[i]);
        }
        return returnList.toArray(new PropertyInterface[returnList.size()]);
    }

    private static boolean isCompatible(PropertyInterface property, Filter filter) throws OLAPException {
        Filter returnFilter = property.getFilter();
        String name = filter.getPropertyName();
        String uniqueMemberName = filter.getUniqueMemberName();
        String uniqueLevelName = filter.getUniqueLevelName();
        String uniqueDimensionName = filter.getUniqueDimensionName();
        String uniqueHierarchyName = filter.getUniqueHierarchyName();
        String cubeName = filter.getNormalizedCubeName();
        int propType = filter.getPropertyType();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = returnFilter.getPropertyName().equalsIgnoreCase(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueMemberName != null && uniqueMemberName.length() > 0) {
            isCompatible = returnFilter.getUniqueMemberName().equalsIgnoreCase(uniqueMemberName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueLevelName != null && uniqueLevelName.length() > 0) {
            isCompatible = returnFilter.getUniqueLevelName().equalsIgnoreCase(uniqueLevelName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueDimensionName != null && uniqueDimensionName.length() > 0) {
            isCompatible = returnFilter.getUniqueDimensionName().equalsIgnoreCase(uniqueDimensionName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueHierarchyName != null && uniqueHierarchyName.length() > 0) {
            isCompatible = returnFilter.getUniqueHierarchyName().equalsIgnoreCase(uniqueHierarchyName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (cubeName != null && cubeName.length() > 0) {
            isCompatible = returnFilter.getNormalizedCubeName().equals(cubeName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (propType > 0) {
            isCompatible = returnFilter.getPropertyType() == propType;
        }
        return isCompatible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyInterface[] getPropertyMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        ISession _nsession = _session;
        if (_nsession == null) {
            _nsession = RemoteMetadata.createSession(metadata);
        }
        IPropSet _propSet = null;
        try {
            StringSeqHolder schemaNames = new StringSeqHolder();
            StringSeqHolder cubeNames = new StringSeqHolder();
            StringSeqHolder uniqueLevelNames = new StringSeqHolder();
            StringSeqHolder uniqueMemberNames = new StringSeqHolder();
            StringSeqHolder uniqueDimensionNames = new StringSeqHolder();
            StringSeqHolder uniqueHierarchyNames = new StringSeqHolder();
            StringSeqHolder names = new StringSeqHolder();
            StringSeqHolder labels = new StringSeqHolder();
            LongSeqHolder types = new LongSeqHolder();
            LongSeqHolder dataTypes = new LongSeqHolder();
            StringSeqHolder desc = new StringSeqHolder();
            boolean defaultSharedDim = propertyFieldInclusion[propertyFieldInclusion.length - 1];
            RemoteMetadata.propertyFieldInclusion[RemoteMetadata.propertyFieldInclusion.length - 1] = filter.hasIncludeSharedDimensions();
            _propSet = _nsession.PropMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getUniqueHierarchyName(), filter.getUniqueLevelName(), filter.getUniqueMemberName(), filter.getPropertyName(), filter.getPropertyType() == 0 ? PropType.PropTypeMember : PropType.PropTypeCell, propertyFieldInclusion);
            int nProperties = _propSet.ReadRows(0, -1, excludedStringProp, schemaNames, cubeNames, uniqueDimensionNames, uniqueHierarchyNames, uniqueLevelNames, uniqueMemberNames, types, names, labels, dataTypes, excludedLongProp, excludedLongProp, excludedShortSeqProp, excludedShortSeqProp, desc);
            RemoteMetadata.propertyFieldInclusion[RemoteMetadata.propertyFieldInclusion.length - 1] = defaultSharedDim;
            PropertyInterface[] properties = new PropertyInterface[nProperties];
            for (int i = 0; i < nProperties; ++i) {
                properties[i] = new Property(metadata, _session, cubeNames.value[i], uniqueDimensionNames.value[i], uniqueHierarchyNames.value[i], uniqueLevelNames.value[i], uniqueMemberNames.value[i], names.value[i], labels.value[i], types.value[i], dataTypes.value[i], desc.value[i]);
            }
            PropertyInterface[] propertyInterfaceArray = properties;
            return propertyInterfaceArray;
        }
        catch (Exception ex) {
            PropertyInterface[] propertyInterfaceArray = new PropertyInterface[]{};
            return propertyInterfaceArray;
        }
        finally {
            try {
                if (_propSet != null) {
                    _propSet.Close();
                }
            }
            catch (GenericError ge) {
                System.out.println("Unable to close Level Rowset");
            }
            if (_session == null && _nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CubeSlice storeCubeSliceInCache(MetadataInterface metadata, ISession _session, Filter filter, long key) throws OLAPException {
        try {
            CubeSlice slice = new CubeSlice();
            slice.sharedDimensions = filter.hasIncludeSharedDimensions();
            slice.connObject = metadata.getConnection();
            if (!slice.sharedDimensions) {
                slice.cubes = RemoteMetadata.getCubeMetadata(metadata, _session, filter);
            }
            slice.dimensions = RemoteMetadata.getDimensionMetadata(metadata, _session, filter);
            slice.hierarchies = RemoteMetadata.getHierarchyMetadata(metadata, _session, filter);
            slice.levels = RemoteMetadata.getLevelMetadata(metadata, _session, filter);
            slice.measures = RemoteMetadata.getMeasureMetadata(metadata, _session, filter);
            slice.properties = RemoteMetadata.getPropertyMetadata(metadata, _session, filter);
            CacheInterface cacheInterface = cache;
            synchronized (cacheInterface) {
                if (!cache.cacheContainsKey(key)) {
                    cache.storeInCache(key, (Object)slice);
                }
                return slice;
            }
        }
        catch (CacheException ce) {
            throw new OLAPException(ce, OLAPUtil.getExceptionMessage(ce));
        }
    }

    private static CubeInterface[] getCubeMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        ISession _nsession = RemoteMetadata.createSession(metadata);
        ICubeSet _cubeSet = null;
        try {
            StringSeqHolder catalogNames = new StringSeqHolder();
            StringSeqHolder schemaNames = new StringSeqHolder();
            StringSeqHolder cubeNames = new StringSeqHolder();
            DateTimeSeqHolder creationDateTimes = new DateTimeSeqHolder();
            DateTimeSeqHolder updateDateTimes = new DateTimeSeqHolder();
            StringSeqHolder cubeTypes = new StringSeqHolder();
            StringSeqHolder cubeDescriptions = new StringSeqHolder();
            ShortSeqHolder drillthroughEnabled = new ShortSeqHolder();
            _cubeSet = _nsession.CubeMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), cubeFieldInclusion);
            int nCubes = _cubeSet.ReadRows(0, -1, catalogNames, schemaNames, cubeNames, cubeTypes, excludedUUIDProp, excludedShortProp, creationDateTimes, excludedStringProp, excludedShortProp, excludedDateTimeProp, excludedStringProp, excludedShortProp, updateDateTimes, excludedStringProp, cubeDescriptions, drillthroughEnabled);
            CubeInterface[] tempCache = new CubeInterface[nCubes];
            for (int i = 0; i < nCubes; ++i) {
                Date creationDateTime = new Date(creationDateTimes.value[i]);
                Date updateDateTime = new Date(updateDateTimes.value[i]);
                boolean isDrillthroughEnabled = drillthroughEnabled.value[i] != 0;
                Cube cube = new Cube(metadata, _session, catalogNames.value[i], schemaNames.value[i], cubeNames.value[i], cubeTypes.value[i], creationDateTime, updateDateTime, cubeDescriptions.value[i], isDrillthroughEnabled);
                tempCache[i] = cube;
            }
            CubeInterface[] cubeInterfaceArray = tempCache;
            return cubeInterfaceArray;
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        finally {
            try {
                if (_cubeSet != null) {
                    _cubeSet.Close();
                }
            }
            catch (GenericError ge) {
                System.out.println("Unable to close the Cube RowSet");
            }
            if (_nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
        }
    }

    private static DimensionInterface[] getDimensionMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        ISession _nsession = _session;
        if (_nsession == null) {
            _nsession = RemoteMetadata.createSession(metadata);
        }
        IDimSet _dimSet = null;
        try {
            StringSeqHolder catalogNames = new StringSeqHolder();
            StringSeqHolder schemaNames = new StringSeqHolder();
            StringSeqHolder cubeNames = new StringSeqHolder();
            StringSeqHolder names = new StringSeqHolder();
            StringSeqHolder uniqueNames = new StringSeqHolder();
            StringSeqHolder labels = new StringSeqHolder();
            LongSeqHolder types = new LongSeqHolder();
            LongSeqHolder nMems = new LongSeqHolder();
            StringSeqHolder defaultHiers = new StringSeqHolder();
            StringSeqHolder desc = new StringSeqHolder();
            boolean defaultSharedDim = dimensionFieldInclusion[dimensionFieldInclusion.length - 1];
            RemoteMetadata.dimensionFieldInclusion[RemoteMetadata.dimensionFieldInclusion.length - 1] = filter.hasIncludeSharedDimensions();
            _dimSet = _nsession.DimMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getDimensionName(), filter.getUniqueDimensionName(), dimensionFieldInclusion);
            int nDimensions = _dimSet.ReadRows(0, -1, catalogNames, schemaNames, cubeNames, names, uniqueNames, excludedUUIDProp, labels, excludedLongProp, types, nMems, defaultHiers, desc);
            RemoteMetadata.dimensionFieldInclusion[RemoteMetadata.dimensionFieldInclusion.length - 1] = defaultSharedDim;
            DimensionInterface[] tempCache = new DimensionInterface[nDimensions];
            for (int i = 0; i < nDimensions; ++i) {
                tempCache[i] = new Dimension(metadata, _session, catalogNames.value[i], schemaNames.value[i], cubeNames.value[i], names.value[i], uniqueNames.value[i], labels.value[i], types.value[i], nMems.value[i], defaultHiers.value[i], desc.value[i]);
            }
            DimensionInterface[] dimensionInterfaceArray = tempCache;
            return dimensionInterfaceArray;
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        finally {
            try {
                if (_dimSet != null) {
                    _dimSet.Close();
                }
            }
            catch (GenericError ge) {
                System.out.println("Unable to close the Dimension Rowset");
            }
            if (_session == null && _nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
        }
    }

    private static MeasureInterface[] getMeasureMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        ISession _nsession = _session;
        if (_nsession == null) {
            _nsession = RemoteMetadata.createSession(metadata);
        }
        IMeasureSet _measureSet = null;
        try {
            StringSeqHolder catalogNames = new StringSeqHolder();
            StringSeqHolder schemaNames = new StringSeqHolder();
            StringSeqHolder cubeNames = new StringSeqHolder();
            StringSeqHolder names = new StringSeqHolder();
            StringSeqHolder uniqueNames = new StringSeqHolder();
            StringSeqHolder labels = new StringSeqHolder();
            LongSeqHolder dataTypes = new LongSeqHolder();
            LongSeqHolder aggregators = new LongSeqHolder();
            ShortSeqHolder precision = new ShortSeqHolder();
            ShortSeqHolder scale = new ShortSeqHolder();
            StringSeqHolder units = new StringSeqHolder();
            StringSeqHolder desc = new StringSeqHolder();
            _measureSet = _nsession.MeasureMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getMeasureName(), filter.getUniqueMeasureName(), measureFieldInclusion);
            int nMeasures = _measureSet.ReadRows(0, -1, catalogNames, schemaNames, cubeNames, names, uniqueNames, labels, excludedUUIDProp, aggregators, dataTypes, precision, scale, units, desc);
            MeasureInterface[] tempCache = new MeasureInterface[nMeasures];
            for (int i = 0; i < nMeasures; ++i) {
                tempCache[i] = new Measure(metadata, _session, catalogNames.value[i], schemaNames.value[i], cubeNames.value[i], names.value[i], uniqueNames.value[i], labels.value[i], dataTypes.value[i], aggregators.value[i], precision.value[i], scale.value[i], units.value[i], desc.value[i]);
            }
            MeasureInterface[] measureInterfaceArray = tempCache;
            return measureInterfaceArray;
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        finally {
            try {
                if (_measureSet != null) {
                    _measureSet.Close();
                }
            }
            catch (GenericError ge) {
                System.out.println("Unable to close the Measure Rowset");
            }
            if (_session == null && _nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
        }
    }

    private static HierarchyInterface[] getHierarchyMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        ISession _nsession = _session;
        if (_nsession == null) {
            _nsession = RemoteMetadata.createSession(metadata);
        }
        IHierSet _hierSet = null;
        try {
            StringSeqHolder catalogNames = new StringSeqHolder();
            StringSeqHolder schemaNames = new StringSeqHolder();
            StringSeqHolder uniqueDimensionNames = new StringSeqHolder();
            StringSeqHolder cubeNames = new StringSeqHolder();
            StringSeqHolder names = new StringSeqHolder();
            StringSeqHolder uniqueNames = new StringSeqHolder();
            StringSeqHolder labels = new StringSeqHolder();
            LongSeqHolder nMems = new LongSeqHolder();
            StringSeqHolder defaultMembers = new StringSeqHolder();
            StringSeqHolder allMembers = new StringSeqHolder();
            StringSeqHolder desc = new StringSeqHolder();
            LongSeqHolder structure = new LongSeqHolder();
            boolean defaultSharedDim = hierarchyFieldInclusion[hierarchyFieldInclusion.length - 1];
            RemoteMetadata.hierarchyFieldInclusion[RemoteMetadata.hierarchyFieldInclusion.length - 1] = filter.hasIncludeSharedDimensions();
            _hierSet = _nsession.HierMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getHierarchyName(), filter.getUniqueHierarchyName(), hierarchyFieldInclusion);
            int nHierarchies = _hierSet.ReadRows(0, -1, catalogNames, schemaNames, cubeNames, uniqueDimensionNames, names, uniqueNames, excludedUUIDProp, labels, excludedLongProp, nMems, defaultMembers, allMembers, desc, structure);
            RemoteMetadata.hierarchyFieldInclusion[RemoteMetadata.hierarchyFieldInclusion.length - 1] = defaultSharedDim;
            HierarchyInterface[] tempCache = new HierarchyInterface[nHierarchies];
            for (int i = 0; i < nHierarchies; ++i) {
                tempCache[i] = new Hierarchy(metadata, _session, catalogNames.value[i], schemaNames.value[i], cubeNames.value[i], uniqueDimensionNames.value[i], names.value[i], uniqueNames.value[i], labels.value[i], nMems.value[i], defaultMembers.value[i], allMembers.value[i], desc.value[i], structure.value[i]);
            }
            HierarchyInterface[] hierarchyInterfaceArray = tempCache;
            return hierarchyInterfaceArray;
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        finally {
            try {
                if (_hierSet != null) {
                    _hierSet.Close();
                }
            }
            catch (GenericError ge) {
                System.out.println("Unable to close Hierarchy Rowset");
            }
            if (_session == null && _nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
        }
    }

    private static LevelInterface[] getLevelMetadata(MetadataInterface metadata, ISession _session, Filter filter) throws OLAPException {
        ISession _nsession = _session;
        if (_nsession == null) {
            _nsession = RemoteMetadata.createSession(metadata);
        }
        ILvlSet _lvlSet = null;
        try {
            StringSeqHolder catalogNames = new StringSeqHolder();
            StringSeqHolder schemaNames = new StringSeqHolder();
            StringSeqHolder cubeNames = new StringSeqHolder();
            StringSeqHolder uniqueDimensionNames = new StringSeqHolder();
            StringSeqHolder uniqueHierarchyNames = new StringSeqHolder();
            StringSeqHolder names = new StringSeqHolder();
            StringSeqHolder uniqueNames = new StringSeqHolder();
            StringSeqHolder labels = new StringSeqHolder();
            LongSeqHolder types = new LongSeqHolder();
            LongSeqHolder nMems = new LongSeqHolder();
            LongSeqHolder depths = new LongSeqHolder();
            StringSeqHolder desc = new StringSeqHolder();
            boolean defaultSharedDim = levelFieldInclusion[levelFieldInclusion.length - 1];
            RemoteMetadata.levelFieldInclusion[RemoteMetadata.levelFieldInclusion.length - 1] = filter.hasIncludeSharedDimensions();
            _lvlSet = _nsession.LvlMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getUniqueHierarchyName(), filter.getLevelName(), filter.getUniqueLevelName(), levelFieldInclusion);
            int nLevels = _lvlSet.ReadRows(0, -1, catalogNames, schemaNames, cubeNames, uniqueDimensionNames, uniqueHierarchyNames, names, uniqueNames, excludedUUIDProp, labels, depths, nMems, types, desc);
            RemoteMetadata.levelFieldInclusion[RemoteMetadata.levelFieldInclusion.length - 1] = defaultSharedDim;
            LevelInterface[] tempCache = new LevelInterface[nLevels];
            for (int i = 0; i < nLevels; ++i) {
                tempCache[i] = new Level(metadata, _session, catalogNames.value[i], schemaNames.value[i], cubeNames.value[i], uniqueDimensionNames.value[i], uniqueHierarchyNames.value[i], names.value[i], uniqueNames.value[i], labels.value[i], types.value[i], nMems.value[i], depths.value[i], desc.value[i]);
            }
            LevelInterface[] levelInterfaceArray = tempCache;
            return levelInterfaceArray;
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        finally {
            try {
                if (_lvlSet != null) {
                    _lvlSet.Close();
                }
            }
            catch (GenericError ge) {
                System.out.println("Unable to close Level Rowset");
            }
            if (_session == null && _nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static CubeSlice getCachedCube(MetadataInterface metadata, ISession _session, Filter filter, int itemType) throws OLAPException {
        ISession _nsession = _session;
        try {
            CacheInterface _dimSet;
            CubeSlice cachedCube = null;
            String schemaName = "";
            String cubeName = filter.getNormalizedCubeName();
            boolean sharedDimensions = filter.hasIncludeSharedDimensions();
            if (!(sharedDimensions || cubeName != null && cubeName.length() != 0)) {
                StringSeqHolder cubeNames = new StringSeqHolder();
                StringSeqHolder schemaNames = new StringSeqHolder();
                switch (itemType) {
                    case 0: {
                        CubeInterface[] items = RemoteMetadata.getCubeMetadata(metadata, _nsession, filter);
                        if (items.length != 1) {
                            CubeSlice cube = cachedCube;
                            return cube;
                        }
                        CubeInterface cube = items[0];
                        SchemaInterface schema = cube.getSchema();
                        if (schema != null) {
                            schemaName = schema.getName();
                        }
                        cubeName = cube.getNormalizedName();
                        break;
                    }
                    case 1: {
                        if (_nsession == null) {
                            _nsession = RemoteMetadata.createSession(metadata);
                        }
                        boolean defaultSharedDim = dimensionInitFieldInclusion[dimensionInitFieldInclusion.length - 1];
                        RemoteMetadata.dimensionInitFieldInclusion[RemoteMetadata.dimensionInitFieldInclusion.length - 1] = sharedDimensions;
                        _dimSet = _nsession.DimMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getDimensionName(), filter.getUniqueDimensionName(), dimensionInitFieldInclusion);
                        int nDimensions = _dimSet.ReadRows(0, -1, excludedStringProp, schemaNames, cubeNames, excludedStringProp, excludedStringProp, excludedUUIDProp, excludedStringProp, excludedLongProp, excludedLongProp, excludedLongProp, excludedStringProp, excludedStringProp);
                        _dimSet.Close();
                        RemoteMetadata.dimensionInitFieldInclusion[RemoteMetadata.dimensionInitFieldInclusion.length - 1] = defaultSharedDim;
                        break;
                    }
                    case 2: {
                        if (_nsession == null) {
                            _nsession = RemoteMetadata.createSession(metadata);
                        }
                        boolean defaultSharedDim = hierarchyInitFieldInclusion[hierarchyFieldInclusion.length - 1];
                        RemoteMetadata.hierarchyInitFieldInclusion[RemoteMetadata.hierarchyFieldInclusion.length - 1] = sharedDimensions;
                        IHierSet _hierSet = _nsession.HierMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getHierarchyName(), filter.getUniqueHierarchyName(), hierarchyInitFieldInclusion);
                        int nHierarchies = _hierSet.ReadRows(0, -1, excludedStringProp, schemaNames, cubeNames, excludedStringProp, excludedStringProp, excludedStringProp, excludedUUIDProp, excludedStringProp, excludedLongProp, excludedLongProp, excludedStringProp, excludedStringProp, excludedStringProp, excludedLongProp);
                        _hierSet.Close();
                        RemoteMetadata.hierarchyInitFieldInclusion[RemoteMetadata.hierarchyFieldInclusion.length - 1] = defaultSharedDim;
                        break;
                    }
                    case 3: {
                        if (_nsession == null) {
                            _nsession = RemoteMetadata.createSession(metadata);
                        }
                        boolean defaultSharedDim = levelInitFieldInclusion[levelFieldInclusion.length - 1];
                        RemoteMetadata.levelInitFieldInclusion[RemoteMetadata.levelFieldInclusion.length - 1] = sharedDimensions;
                        ILvlSet _lvlSet = _nsession.LvlMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getUniqueHierarchyName(), filter.getLevelName(), filter.getUniqueLevelName(), levelInitFieldInclusion);
                        int nLevels = _lvlSet.ReadRows(0, -1, excludedStringProp, schemaNames, cubeNames, excludedStringProp, excludedStringProp, excludedStringProp, excludedStringProp, excludedUUIDProp, excludedStringProp, excludedLongProp, excludedLongProp, excludedLongProp, excludedStringProp);
                        _lvlSet.Close();
                        RemoteMetadata.levelInitFieldInclusion[RemoteMetadata.levelFieldInclusion.length - 1] = defaultSharedDim;
                        break;
                    }
                    case 4: {
                        if (_nsession == null) {
                            _nsession = RemoteMetadata.createSession(metadata);
                        }
                        IMeasureSet _measureSet = _nsession.MeasureMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getMeasureName(), filter.getUniqueMeasureName(), measureInitFieldInclusion);
                        int nMeasures = _measureSet.ReadRows(0, -1, excludedStringProp, schemaNames, cubeNames, excludedStringProp, excludedStringProp, excludedStringProp, excludedUUIDProp, excludedLongProp, excludedLongProp, excludedShortSeqProp, excludedShortSeqProp, excludedStringProp, excludedStringProp);
                        _measureSet.Close();
                        break;
                    }
                    case 5: {
                        try {
                            if (_nsession == null) {
                                _nsession = RemoteMetadata.createSession(metadata);
                            }
                            boolean defaultSharedDim = propertyInitFieldInclusion[propertyInitFieldInclusion.length - 1];
                            RemoteMetadata.propertyInitFieldInclusion[RemoteMetadata.propertyFieldInclusion.length - 1] = sharedDimensions;
                            IPropSet _propSet = _nsession.PropMetadata(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getDimensionName(), filter.getHierarchyName(), filter.getUniqueLevelName(), filter.getUniqueMemberName(), filter.getPropertyName(), PropType.PropTypeMember, propertyInitFieldInclusion);
                            int nProperties = _propSet.ReadRows(0, -1, excludedStringProp, excludedStringProp, cubeNames, excludedStringProp, excludedStringProp, excludedStringProp, excludedStringProp, excludedLongProp, excludedStringProp, excludedStringProp, excludedLongProp, excludedLongProp, excludedLongProp, excludedShortSeqProp, excludedShortSeqProp, excludedStringProp);
                            _propSet.Close();
                            RemoteMetadata.propertyInitFieldInclusion[RemoteMetadata.propertyInitFieldInclusion.length - 1] = defaultSharedDim;
                        }
                        catch (EmptySet emptySet) {}
                        break;
                    }
                    default: {
                        CubeSlice cubeSlice = null;
                        return cubeSlice;
                    }
                }
                if (cubeName == null) {
                    if (RemoteMetadata.isUniqueName(schemaNames.value) && RemoteMetadata.isUniqueName(cubeNames.value)) {
                        schemaName = schemaNames.value[0];
                        cubeName = cubeNames.value[0].toLowerCase();
                    } else {
                        CubeSlice cubeSlice = cachedCube;
                        return cubeSlice;
                    }
                }
            } else if (sharedDimensions && cubeName == null) {
                cubeName = "";
            }
            Object connObject = metadata.getConnection();
            long key = RemoteMetadata.createKey(connObject, cubeName);
            boolean foundInCache = false;
            _dimSet = cache;
            // MONITORENTER : _dimSet
            foundInCache = cache.cacheContainsKey(key);
            if (foundInCache) {
                cachedCube = (CubeSlice)cache.getFromCache(key);
                if (!cachedCube.sharedDimensions && !cachedCube.cubes[0].getNormalizedName().equals(cubeName) || !cachedCube.connObject.equals(connObject)) {
                    cache.invalidateCache(key);
                    foundInCache = false;
                }
            }
            // MONITOREXIT : _dimSet
            if (!foundInCache) {
                Filter newFilter = new Filter();
                newFilter.setCubeName(cubeName);
                newFilter.setIncludeSharedDimensions(filter.hasIncludeSharedDimensions());
                cachedCube = RemoteMetadata.storeCubeSliceInCache(metadata, _nsession, newFilter, key);
            }
            CubeSlice cubeSlice = cachedCube;
            return cubeSlice;
        }
        catch (Exception ce) {
            throw new OLAPException(ce, OLAPUtil.getExceptionMessage(ce));
        }
        finally {
            if (_nsession != null) {
                RemoteMetadata.closeSession(_nsession);
            }
        }
    }

    private static boolean isUniqueName(String[] names) {
        if (names != null && names.length > 0) {
            String name = names[0];
            for (int i = 1; i < names.length; ++i) {
                if (!Util.unequal((Object)name, (Object)names[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static long createKey(Object connObject, String cubeName) {
        return cubeName.hashCode() + System.identityHashCode(connObject);
    }

    public static synchronized ISession createSession(MetadataInterface metadata) throws OLAPException {
        try {
            Object o = metadata.getConnection();
            if (o instanceof ISession) {
                return (ISession)o;
            }
            Locale locale = metadata.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ISession session = ((IMDXServer)o).CreateSession(locale.toString());
            sessionList.add(session);
            return session;
        }
        catch (Exception oe) {
            throw new OLAPException(oe, OLAPUtil.getExceptionMessage(oe));
        }
    }

    public static void closeSession(ISession session) throws OLAPException {
        try {
            if (sessionList.remove(session)) {
                session.Close();
            }
        }
        catch (Exception oe) {
            throw new OLAPException(oe, OLAPUtil.getExceptionMessage(oe));
        }
    }

    public static void setPerformanceTuning(MetadataPerformanceTuning pf) throws CacheException {
        performanceTuning = pf;
        if (pf.useCache()) {
            membersCache = RemoteMetadata.getMembersCache();
            membersCache.configureCache(pf.bufferSize(), pf.lookAhead(), pf.maxFilters());
        }
    }

    public static MetadataPerformanceTuning getPerformanceTuning() {
        return performanceTuning;
    }

    public static void clearCache(Filter filter, Object connObject, int cacheType) throws CacheException {
        switch (cacheType) {
            case 2: {
                RemoteMetadata.clearMemberCache(filter, connObject);
                RemoteMetadata.clearNonMemberCache(filter, connObject);
                break;
            }
            case 0: {
                RemoteMetadata.clearMemberCache(filter, connObject);
                break;
            }
            case 1: {
                RemoteMetadata.clearNonMemberCache(filter, connObject);
                break;
            }
        }
    }

    private static void clearMemberCache(Filter filter, Object connObject) {
        if (membersCache != null) {
            membersCache.remove(filter, connObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void clearNonMemberCache(Filter filter, Object connObject) throws CacheException {
        if (connObject == null) {
            cache.invalidateCache();
        } else if (filter == null) {
            Object[] slices = ((SparseCache)cache).getCacheValues();
            long[] keys = ((SparseCache)cache).getCacheKeys();
            for (int i = 0; i < slices.length; ++i) {
                if (!((CubeSlice)slices[i]).connObject.equals(connObject)) continue;
                CacheInterface cacheInterface = cache;
                synchronized (cacheInterface) {
                    if (cache.cacheContainsKey(keys[i])) {
                        cache.invalidateCache(keys[i]);
                    }
                    continue;
                }
            }
        } else if (filter.getDimensionName().equals("") && filter.getUniqueDimensionName().equals("") && filter.getHierarchyName().equals("") && filter.getUniqueHierarchyName().equals("") && filter.getLevelName().equals("") && filter.getUniqueLevelName().equals("") && filter.getLevelNumber() == -1 && filter.getMeasureName().equals("") && filter.getUniqueMeasureName().equals("") && filter.getMemberName().equals("") && filter.getUniqueMemberName().equals("") && filter.getMemberLabel().equals("") && filter.getMemberType() == 0 && filter.getTreeOperator() == 0 && filter.getPropertyName().equals("") && filter.getPropertyType() == 0) {
            long key = RemoteMetadata.createKey(connObject, filter.getCubeName());
            cache.invalidateCache(key);
        }
    }

    static {
        performanceTuning = new MetadataPerformanceTuning();
        sessionList = new Vector();
    }

    @SASScope
    private static class CubeSlice {
        Object connObject;
        CubeInterface[] cubes;
        DimensionInterface[] dimensions;
        HierarchyInterface[] hierarchies;
        LevelInterface[] levels;
        MeasureInterface[] measures;
        PropertyInterface[] properties;
        boolean sharedDimensions;

        private CubeSlice() {
        }

        public String toString() {
            return "Cubes: " + this.cubes + "\nDimensions: " + this.dimensions + "\nHierarchies: " + this.hierarchies + "\nLevels: " + this.levels + "\nMeasures: " + this.measures + "\nProperties: " + this.properties + "\nSharedDimensions: " + this.sharedDimensions;
        }
    }
}

