/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.RB;
import com.sas.storage.olap.sasmdx.RemoteMetadata;
import java.util.Date;

@SASScope(value="ALL")
public class Member
implements MemberInterface {
    @SASScope
    public static final String RB_KEY = "Member.";
    @SASScope
    protected ISession _session;
    @SASScope
    protected String catalogName;
    @SASScope
    protected String schemaName;
    @SASScope
    protected String cubeName;
    @SASScope
    protected String uniqueDimensionName;
    @SASScope
    protected String uniqueHierarchyName;
    @SASScope
    protected String uniqueLevelName;
    @SASScope
    protected int levelDepth;
    @SASScope
    protected String label;
    @SASScope
    protected String name;
    @SASScope
    protected String uniqueName;
    @SASScope
    protected int type;
    @SASScope
    protected int childCount;
    @SASScope
    protected String[] propertyNames;
    @SASScope
    protected int propertyDataTypes;
    @SASScope
    protected String parentMemberName;
    @SASScope
    protected PropertyInterface[] properties;
    @SASScope
    protected MetadataInterface metadata;
    @SASScope
    protected IMDXServer _connection;
    @SASScope
    protected Filter filter;
    private boolean isShared;

    public Member(MetadataInterface metadata, ISession _session, String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String uniqueHierarchyName, String uniqueLevelName, int levelDepth, String name, String uniqueName, String label, int type, int childCount, String parentMemberName, int propertyDataTypes, String[] propertyNames) throws OLAPException {
        this.metadata = metadata;
        this._session = _session;
        if (metadata != null) {
            Object con = metadata.getConnection();
            if (con instanceof IMDXServer) {
                this._connection = (IMDXServer)con;
            }
        } else if (this._connection != null) {
            this.metadata = new Metadata(this._connection);
        } else if (_session != null) {
            this.metadata = new Metadata(_session);
        }
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.uniqueDimensionName = uniqueDimensionName;
        this.uniqueHierarchyName = uniqueHierarchyName;
        this.uniqueLevelName = uniqueLevelName;
        this.levelDepth = levelDepth;
        this.name = name;
        this.uniqueName = uniqueName;
        this.label = label;
        this.type = type;
        this.childCount = childCount;
        this.parentMemberName = parentMemberName;
        this.propertyDataTypes = propertyDataTypes;
        this.propertyNames = propertyNames;
        this.properties = null;
        this.filter = null;
        if (cubeName == null || cubeName.length() == 0) {
            this.isShared = true;
        }
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public String getUniqueName() throws OLAPException {
        return this.uniqueName;
    }

    @Override
    public String getDescription() throws OLAPException {
        return this.getLabel();
    }

    @Override
    public LevelInterface getLevel() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noLevel.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCatalogName(this.catalogName);
        inFilter.setSchemaName(this.schemaName);
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueLevelName(this.uniqueLevelName);
        return this.metadata.getLevel(inFilter);
    }

    @Override
    public DimensionInterface getDimension() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noLevel.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCatalogName(this.catalogName);
        inFilter.setSchemaName(this.schemaName);
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueDimensionName(this.uniqueDimensionName);
        return this.metadata.getDimension(inFilter);
    }

    @Override
    public int getChildCount() throws OLAPException {
        return this.childCount;
    }

    @Override
    public int getType() throws OLAPException {
        return this.type;
    }

    @Override
    public PropertyInterface[] getProperties() throws OLAPException {
        return RemoteMetadata.PropMetadata(this.metadata, this._session, this.getFilter());
    }

    @Override
    public MemberInterface getParentMember() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noParentMember.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        if (this.parentMemberName != null && this.parentMemberName.length() > 0) {
            inFilter.setUniqueMemberName(this.parentMemberName);
            MemberInterface[] members = this.metadata.getMembers(inFilter, 0, -1);
            if (members.length != 1) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "multipleMember.ex.txt"));
            }
            return members[0];
        }
        return null;
    }

    @Override
    public synchronized Filter getFilter() throws OLAPException {
        if (this.filter == null) {
            this.filter = new Filter();
            this.filter.setCatalogName(this.catalogName);
            this.filter.setSchemaName(this.schemaName);
            this.filter.setCubeName(this.cubeName);
            this.filter.setIncludeSharedDimensions(this.isShared);
            this.filter.setUniqueDimensionName(this.uniqueDimensionName);
            this.filter.setUniqueHierarchyName(this.uniqueHierarchyName);
            this.filter.setUniqueLevelName(this.uniqueLevelName);
            this.filter.setLevelNumber(this.levelDepth);
            this.filter.setMemberName(this.name);
            this.filter.setMemberLabel(this.label);
            this.filter.setUniqueMemberName(this.uniqueName);
            this.filter.setMemberType(this.type);
        }
        return this.filter;
    }

    @Override
    public MetadataInterface getMetadata() throws OLAPException {
        return this.metadata;
    }

    @Override
    public Date getCreationDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }

    @Override
    public Date getUpdateDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }

    @Override
    public CubeInterface getCube() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("noCube.ex.txt"));
        }
        if (this.cubeName != null && this.cubeName.length() > 0) {
            Filter inFilter = new Filter();
            inFilter.setCatalogName(this.catalogName);
            inFilter.setSchemaName(this.schemaName);
            inFilter.setCubeName(this.cubeName);
            CubeInterface[] cubes = this.metadata.getCubes(inFilter);
            return cubes[0];
        }
        return null;
    }

    @Override
    public MemberInterface[] getChildren() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("noCube.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCatalogName(this.catalogName);
        inFilter.setSchemaName(this.schemaName);
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueMemberName(this.uniqueName);
        inFilter.setTreeOperator(Filter.CHILDREN_TREE_OPERATOR);
        return this.metadata.getMembers(inFilter, 0, -1);
    }
}

