/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.embedded;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.RB;
import com.sas.storage.olap.embedded.ResultSetMetadata;
import com.sas.storage.olap.embedded.Tuple;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
public class Axis
implements AxisInterface {
    @SASScope
    public static final String RB_KEY = "Axis.";
    private String[] dimensions;
    private String[] hierarchies;
    private String[] uniqueLevelNames;
    private ArrayList tuples;
    private int tupleCount;
    private int axisNumber;
    private String[] labels;
    private ResultSetMetadataInterface resultSetMetadata;

    public Axis(int axisIndex) throws OLAPException {
        this(axisIndex, null, null);
    }

    public Axis(int axisIndex, String[] axisHeaders, TupleInterface[] tuples) throws OLAPException {
        this.axisNumber = axisIndex;
        this.setAxisHeaders(axisHeaders);
        this.tuples = new ArrayList(10);
        for (int i = 0; tuples != null && i < tuples.length; ++i) {
            this.tuples.add(tuples[i]);
            ++this.tupleCount;
            if (!(tuples[i] instanceof Tuple)) continue;
            ((Tuple)tuples[i]).setAxis(this);
        }
        this.calculateTupleIndex();
        this.calculateMinMaxCoordinates(this.asTupleArray(this.tuples));
    }

    public void setDimensionNames(String[] dimensionNames) throws OLAPException {
        this.dimensions = dimensionNames;
    }

    public void setResultSetMetadata(ResultSetMetadataInterface rsm) throws OLAPException {
        if (Util.unequal((Object)this.resultSetMetadata, (Object)rsm)) {
            AxisInterface[] axes;
            this.resultSetMetadata = rsm;
            if (rsm instanceof ResultSetMetadata && ((axes = rsm.getAxes(this.axisNumber, 1)) == null || axes.length == 0)) {
                ((ResultSetMetadata)this.resultSetMetadata).addAxis(this);
            }
        }
    }

    @Override
    public String[] getDimensionNames() throws OLAPException {
        return this.dimensions;
    }

    @Override
    public TupleInterface[] getTuples(int index, int count) throws OLAPException {
        int endIndex;
        if (count == 0 || this.tupleCount == 0) {
            return OLAPUtil.EMPTY_TUPLE_ARRAY;
        }
        int n = endIndex = count == -1 ? this.tupleCount : index + count;
        if (index < 0 || index > this.tupleCount || endIndex <= 0 || endIndex > this.tupleCount) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        this.calculateSpan(this.tuples.toArray(OLAPUtil.EMPTY_TUPLE_ARRAY));
        List values = this.tuples.subList(index, endIndex);
        return this.asTupleArray(values);
    }

    @Override
    public TupleInterface getTuple(int index) throws OLAPException {
        if (index < 0 || index > this.tupleCount) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        this.calculateSpan(this.asTupleArray(this.tuples));
        return (TupleInterface)this.tuples.get(index);
    }

    public void addTuple(TupleInterface tuple) throws OLAPException {
        this.addTuple(-1, tuple);
    }

    public void addTuple(int index, TupleInterface tuple) throws OLAPException {
        if (tuple != null) {
            if (index == -1) {
                index = this.tupleCount;
            }
            if (index > this.tupleCount || index < 0) {
                throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
            }
            if (tuple instanceof Tuple) {
                ((Tuple)tuple).setAxis(this);
            }
            this.tuples.add(index, tuple);
            ++this.tupleCount;
            this.calculateTupleIndex();
            this.calculateMinMaxCoordinates(this.asTupleArray(this.tuples));
        }
    }

    private void calculateTupleIndex() throws OLAPException {
        int i = 0;
        int size = this.tuples.size();
        while (i < size) {
            Object t = this.tuples.get(i);
            if (!(t instanceof Tuple)) continue;
            ((Tuple)t).setTupleIndex(i++);
        }
    }

    public void setTuple(int index, TupleInterface tuple) throws OLAPException {
        if (tuple == null) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidTuple.ex.txt"));
        }
        this.basicSetTuple(index, tuple);
        this.calculateMinMaxCoordinates(this.asTupleArray(this.tuples));
    }

    public void setTuples(int startIndex, int endIndex, TupleInterface[] tuples) throws OLAPException {
        if (tuples == null || startIndex < 0 || startIndex > this.tupleCount || endIndex < startIndex || endIndex > this.tupleCount) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.basicSetTuple(i, tuples[j]);
            ++i;
            ++j;
        }
        this.calculateMinMaxCoordinates(this.asTupleArray(this.tuples));
    }

    private void basicSetTuple(int index, TupleInterface tuple) throws OLAPException {
        this.tuples.set(index, tuple);
        if (tuple instanceof Tuple) {
            ((Tuple)tuple).setAxis(this);
            ((Tuple)tuple).setTupleIndex(index);
        }
    }

    public TupleInterface removeTuple(int index) throws OLAPException {
        TupleInterface tuple;
        if (index < 0 || index > this.tupleCount || this.tuples == null) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        TupleInterface tupleInterface = tuple = this.tuples != null && index < this.tupleCount ? (TupleInterface)this.tuples.remove(index) : null;
        if (tuple != null) {
            --this.tupleCount;
        }
        this.calculateTupleIndex();
        this.calculateSpan(this.asTupleArray(this.tuples));
        this.calculateMinMaxCoordinates(this.asTupleArray(this.tuples));
        return tuple;
    }

    @Override
    public int getTupleCount() {
        return this.tupleCount;
    }

    @Override
    public int getMaximumTupleDepth() throws OLAPException {
        int baseDepth = 0;
        if (this.tuples != null) {
            for (int i = 0; i < this.tupleCount; ++i) {
                baseDepth = Math.max(baseDepth, ((Tuple)this.tuples.get(i)).getElements(0, -1).length);
            }
        }
        return baseDepth;
    }

    @Override
    public String[] getAxisHeaders() throws OLAPException {
        return this.labels;
    }

    public void setAxisHeaders(String[] labels) throws OLAPException {
        this.labels = labels;
    }

    @Override
    public String[] getHierarchyNames() throws OLAPException {
        return this.hierarchies;
    }

    public void setHierarchyNames(String[] hierarchyNames) throws OLAPException {
        this.hierarchies = hierarchyNames;
    }

    @Override
    public String[] getUniqueLevelNames() throws OLAPException {
        return this.uniqueLevelNames;
    }

    public void setUniqueLevelNames(String[] levelNames) throws OLAPException {
        if (levelNames != null) {
            this.uniqueLevelNames = levelNames;
        }
    }

    @Override
    public ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        return this.resultSetMetadata;
    }

    @Override
    public int getAxisNumber() throws OLAPException {
        return this.axisNumber;
    }

    void setAxisNumber(int axisIndex) {
        this.axisNumber = axisIndex;
    }

    void calculateMinMaxCoordinates(TupleInterface[] tuples) throws OLAPException {
        if (tuples == null) {
            tuples = this.tuples.toArray(OLAPUtil.EMPTY_TUPLE_ARRAY);
        }
        OLAPUtil.calculateMinMaxCoordinates(tuples);
    }

    void calculateSpan(TupleInterface[] tuples) throws OLAPException {
        if (tuples == null) {
            tuples = this.tuples.toArray(OLAPUtil.EMPTY_TUPLE_ARRAY);
        }
        for (int i = 0; i < tuples.length; ++i) {
            int cnt = tuples[i].getTupleDepth();
            for (int j = 0; j < cnt; ++j) {
                tuples[i].getElement(j).setSpan(1);
            }
        }
        OLAPUtil.calculateSpan(tuples);
    }

    public TupleInterface[] asTupleArray(List list) {
        return this.tuples == null ? OLAPUtil.EMPTY_TUPLE_ARRAY : list.toArray(OLAPUtil.EMPTY_TUPLE_ARRAY);
    }
}

