/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap;

import com.sas.storage.olap.CacheProperties;
import com.sas.storage.olap.ChapterCacheProperties;
import com.sas.storage.olap.ColumnCacheProperties;
import com.sas.storage.olap.FormattedCellCacheProperties;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PageCacheProperties;
import com.sas.storage.olap.RowCacheProperties;
import com.sas.storage.olap.SectionCacheProperties;
import com.sas.storage.olap.SlicerCacheProperties;
import com.sas.storage.olap.UnformattedCellCacheProperties;

public class PerformanceTuning
implements Cloneable {
    public static final String RB_KEY = "PerformanceTuning.";
    public static int MAX_VALUE = -23;
    public static int CELL_TYPE = 2;
    public static int FORMATTED_CELL_TYPE = 4;
    public static int ALL_CELL_TYPES = CELL_TYPE | FORMATTED_CELL_TYPE;
    public static int COLUMNS_AXIS_TYPE = 8;
    public static int ROWS_AXIS_TYPE = 16;
    public static int PAGES_AXIS_TYPE = 32;
    public static int SECTIONS_AXIS_TYPE = 64;
    public static int CHAPTERS_AXIS_TYPE = 128;
    public static int SLICERS_AXIS_TYPE = 256;
    public static int ALL_AXIS_TYPES = COLUMNS_AXIS_TYPE | ROWS_AXIS_TYPE | PAGES_AXIS_TYPE | SECTIONS_AXIS_TYPE | CHAPTERS_AXIS_TYPE | SLICERS_AXIS_TYPE;
    public static int ALL_TYPES = CELL_TYPE | FORMATTED_CELL_TYPE | ALL_AXIS_TYPES;
    private OLAPDataSetInterface model;
    private CacheProperties[] axesCaches;
    private CacheProperties[] cellCaches;

    public PerformanceTuning() {
        this(6);
    }

    public PerformanceTuning(int numAxes) {
        this.axesCaches = new CacheProperties[numAxes];
        for (int i = 0; i < numAxes; ++i) {
            if (i == 0) {
                this.axesCaches[i] = new SlicerCacheProperties();
            }
            if (i == 1) {
                this.axesCaches[i] = new ColumnCacheProperties();
            }
            if (i == 2) {
                this.axesCaches[i] = new RowCacheProperties();
            }
            if (i == 3) {
                this.axesCaches[i] = new PageCacheProperties();
            }
            if (i == 4) {
                this.axesCaches[i] = new SectionCacheProperties();
            }
            if (i != 5) continue;
            this.axesCaches[i] = new ChapterCacheProperties();
        }
        this.cellCaches = new CacheProperties[2];
        this.cellCaches[0] = new UnformattedCellCacheProperties();
        this.cellCaches[1] = new FormattedCellCacheProperties();
    }

    public CacheProperties[] getCache(int cacheType) {
        CacheProperties[] cacheTypes = null;
        if ((cacheType & ALL_TYPES) == ALL_TYPES) {
            cacheTypes = new CacheProperties[this.axesCaches.length + this.cellCaches.length];
            System.arraycopy(this.axesCaches, 0, cacheTypes, 0, this.axesCaches.length);
            System.arraycopy(this.cellCaches, 0, cacheTypes, this.axesCaches.length, this.cellCaches.length);
            return cacheTypes;
        }
        if ((cacheType & ALL_AXIS_TYPES) == ALL_AXIS_TYPES) {
            cacheTypes = this.axesCaches;
        } else if ((cacheType & ALL_CELL_TYPES) == ALL_CELL_TYPES) {
            cacheTypes = this.cellCaches;
        } else if ((cacheType & CELL_TYPE) == CELL_TYPE) {
            cacheTypes = new CacheProperties[]{this.cellCaches[0]};
        } else if ((cacheType & FORMATTED_CELL_TYPE) == FORMATTED_CELL_TYPE) {
            cacheTypes = new CacheProperties[]{this.cellCaches[1]};
        } else if ((cacheType & SLICERS_AXIS_TYPE) == SLICERS_AXIS_TYPE && this.axesCaches.length > 0) {
            cacheTypes = new CacheProperties[]{this.axesCaches[0]};
        } else if ((cacheType & COLUMNS_AXIS_TYPE) == COLUMNS_AXIS_TYPE && this.axesCaches.length > 1) {
            cacheTypes = new CacheProperties[]{this.axesCaches[1]};
        } else if ((cacheType & ROWS_AXIS_TYPE) == ROWS_AXIS_TYPE && this.axesCaches.length > 2) {
            cacheTypes = new CacheProperties[]{this.axesCaches[2]};
        } else if ((cacheType & PAGES_AXIS_TYPE) == PAGES_AXIS_TYPE && this.axesCaches.length > 3) {
            cacheTypes = new CacheProperties[]{this.axesCaches[3]};
        } else if ((cacheType & SECTIONS_AXIS_TYPE) == SECTIONS_AXIS_TYPE && this.axesCaches.length > 4) {
            cacheTypes = new CacheProperties[]{this.axesCaches[4]};
        } else if ((cacheType & CHAPTERS_AXIS_TYPE) == CHAPTERS_AXIS_TYPE && this.axesCaches.length > 5) {
            cacheTypes = new CacheProperties[]{this.axesCaches[5]};
        }
        return cacheTypes;
    }

    public CacheProperties[] getAllCaches() {
        return this.getCache(ALL_TYPES);
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setModel(OLAPDataSetInterface model) {
        this.model = model;
    }

    public void setBufferSize(int cacheType, int size) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        for (int i = 0; i < cache.length; ++i) {
            cache[i].setBufferSize(size);
        }
    }

    public int getBufferSize(int cacheType) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        return cache.length != 1 ? -1 : cache[0].getBufferSize();
    }

    public void setLookAheadEnabled(int cacheType, boolean lookAheadEnabled) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        for (int i = 0; i < cache.length; ++i) {
            cache[i].setLookAheadEnabled(lookAheadEnabled);
        }
    }

    public boolean isLookAheadEnabled(int cacheType) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        return cache.length != 1 ? false : cache[0].isLookAheadEnabled();
    }

    public void setPageCount(int cacheType, int pageCount) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        for (int i = 0; i < cache.length; ++i) {
            cache[i].setPageCount(pageCount);
        }
    }

    public int getPageCount(int cacheType) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        return cache.length != 1 ? -1 : cache[0].getPageCount();
    }

    public void setPageSize(int cacheType, int size) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        for (int i = 0; i < cache.length; ++i) {
            cache[i].setPageSize(size);
        }
    }

    public int getPageSize(int cacheType) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        return cache.length != 1 ? -1 : cache[0].getPageCount();
    }

    public int getLookAhead(int cacheType) throws OLAPException {
        CacheProperties[] cache = this.getCache(cacheType);
        return cache.length != 1 ? -1 : cache[0].getLookAhead();
    }

    public Object clone() throws CloneNotSupportedException {
        PerformanceTuning clone = (PerformanceTuning)super.clone();
        if (this.axesCaches != null) {
            clone.axesCaches = (CacheProperties[])this.axesCaches.clone();
        }
        if (this.cellCaches != null) {
            clone.cellCaches = (CacheProperties[])this.cellCaches.clone();
        }
        return clone;
    }
}

