/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap;

import com.sas.codepolicy.SASScope;

@SASScope(value="ALL")
public class Filter
implements Cloneable {
    @SASScope
    protected String catalogName;
    @SASScope
    protected String schemaName;
    @SASScope
    protected String cubeName;
    @SASScope
    protected String dimensionName;
    @SASScope
    protected String uniqueDimensionName;
    @SASScope
    protected String hierarchyName;
    @SASScope
    protected String uniqueHierarchyName;
    @SASScope
    protected String levelName;
    @SASScope
    protected String uniqueLevelName;
    @SASScope
    protected int levelNumber;
    @SASScope
    protected String measureName;
    @SASScope
    protected String uniqueMeasureName;
    @SASScope
    protected String memberName;
    @SASScope
    protected String uniqueMemberName;
    @SASScope
    protected String memberLabel;
    @SASScope
    protected int memberType;
    @SASScope
    protected int treeOperator;
    @SASScope
    protected String propertyName;
    @SASScope
    protected int propertyType;
    private String normalizedCubeName;
    private boolean includeSharedDimensions;
    public static int ANCESTORS_TREE_OPERATOR = 32;
    public static int CHILDREN_TREE_OPERATOR = 1;
    public static int SIBLINGS_TREE_OPERATOR = 2;
    public static int PARENT_TREE_OPERATOR = 4;
    public static int SELF_TREE_OPERATOR = 8;
    public static int DESCENDENTS_TREE_OPERATOR = 16;

    public Filter() {
        this.init();
    }

    private void init() {
        this.catalogName = "";
        this.schemaName = "";
        this.cubeName = "";
        this.dimensionName = "";
        this.uniqueDimensionName = "";
        this.hierarchyName = "";
        this.uniqueHierarchyName = "";
        this.levelName = "";
        this.uniqueLevelName = "";
        this.levelNumber = -1;
        this.measureName = "";
        this.uniqueMeasureName = "";
        this.memberName = "";
        this.uniqueMemberName = "";
        this.memberLabel = "";
        this.memberType = 0;
        this.treeOperator = 0;
        this.propertyName = "";
        this.propertyType = 0;
        this.includeSharedDimensions = false;
    }

    public void reset() {
        this.init();
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
        if (cubeName != null && cubeName.length() > 0) {
            this.normalizedCubeName = cubeName.toLowerCase();
        }
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getNormalizedCubeName() {
        return this.normalizedCubeName;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setUniqueDimensionName(String uniqueDimensionName) {
        this.uniqueDimensionName = uniqueDimensionName;
    }

    public String getUniqueDimensionName() {
        return this.uniqueDimensionName;
    }

    public void setHierarchyName(String hierarchyName) {
        this.hierarchyName = hierarchyName;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    public void setUniqueHierarchyName(String uniqueHierarchyName) {
        this.uniqueHierarchyName = uniqueHierarchyName;
    }

    public String getUniqueHierarchyName() {
        return this.uniqueHierarchyName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setUniqueLevelName(String uniqueLevelName) {
        this.uniqueLevelName = uniqueLevelName;
    }

    public String getUniqueLevelName() {
        return this.uniqueLevelName;
    }

    public void setLevelNumber(int levelNumber) {
        this.levelNumber = levelNumber;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public void setMeasureName(String measureName) {
        this.measureName = measureName;
    }

    public String getMeasureName() {
        return this.measureName;
    }

    public void setUniqueMeasureName(String uniqueMeasureName) {
        this.uniqueMeasureName = uniqueMeasureName;
    }

    public String getUniqueMeasureName() {
        return this.uniqueMeasureName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setUniqueMemberName(String uniqueMemberName) {
        this.uniqueMemberName = uniqueMemberName;
    }

    public String getUniqueMemberName() {
        return this.uniqueMemberName;
    }

    public void setMemberLabel(String memberLabel) {
        this.memberLabel = memberLabel;
    }

    public String getMemberLabel() {
        return this.memberLabel;
    }

    public void setMemberType(int memberType) {
        this.memberType = memberType;
    }

    public int getMemberType() {
        return this.memberType;
    }

    public void setTreeOperator(int treeOperator) {
        this.treeOperator = treeOperator;
    }

    public int getTreeOperator() {
        return this.treeOperator;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyType(int propertyType) {
        this.propertyType = propertyType;
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public void setIncludeSharedDimensions(boolean sharedDimFlag) {
        this.includeSharedDimensions = sharedDimFlag;
    }

    public boolean hasIncludeSharedDimensions() {
        return this.includeSharedDimensions;
    }

    @SASScope
    public boolean isMatch(Filter filter) {
        return this.catalogName.equals(filter.getCatalogName()) && this.schemaName.equals(filter.getSchemaName()) && this.cubeName.equals(filter.getCubeName()) && this.dimensionName.equals(filter.getDimensionName()) && this.uniqueDimensionName.equals(filter.getUniqueDimensionName()) && this.hierarchyName.equals(filter.getHierarchyName()) && this.uniqueHierarchyName.equals(filter.getUniqueHierarchyName()) && this.levelName.equals(filter.getLevelName()) && this.uniqueLevelName.equals(filter.getUniqueLevelName()) && this.levelNumber == filter.getLevelNumber() && this.measureName.equals(filter.getMeasureName()) && this.uniqueMeasureName.equals(filter.getUniqueMeasureName()) && this.memberName.equals(filter.getMemberName()) && this.uniqueMemberName.equals(filter.getUniqueMemberName()) && this.memberLabel.equals(filter.getMemberLabel()) && this.memberType == filter.getMemberType() && this.treeOperator == filter.getTreeOperator() && this.propertyName.equals(filter.getPropertyName()) && this.propertyType == filter.getPropertyType() && this.includeSharedDimensions == filter.hasIncludeSharedDimensions();
    }

    @SASScope
    public String toString() {
        return "Catalog= " + this.catalogName + "  Schema= " + this.schemaName + "  Cube= " + this.cubeName + "\nDimension= " + this.dimensionName + "  DimensionUN= " + this.uniqueDimensionName + "  HierarchyUN= " + this.uniqueHierarchyName + "\nLevel= " + this.levelName + "  LevelUN= " + this.uniqueLevelName + "  LevelDepth= " + this.levelNumber + "\nMeasure= " + this.measureName + "  MeasureUN= " + this.uniqueMeasureName + "\nMember= " + this.memberName + "  MemberUN= " + this.uniqueMemberName + "  MemberL= " + this.memberLabel + "  MemberType= " + this.memberType + "  TreeOp= " + this.treeOperator + "  includeSharedDimensions= " + this.includeSharedDimensions + "\n";
    }
}

