/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc.export;

import com.sas.codepolicy.SASScope;
import com.sas.storage.jdbc.export.SAStoExcelUtil;
import com.sas.storage.jdbc.export.ToNotParseDateFormats1;
import com.sas.storage.jdbc.export.ToNotParseDateFormats2;
import java.util.Locale;

@SASScope
public class ToNotParseFormats {
    public static String[] DateTimeFormats = new String[]{"DTDATE5", "DTMONYY", "DTMONYY5", "DTMONYY6", "DTMONYY7", "DTWKDAT4", "DTWKDAT5", "DTWKDAT6", "DTWKDAT7", "DTWKDAT8", "DTWKDAT9", "DTWKDAT10", "DTWKDAT11", "DTWKDAT12", "DTWKDAT13", "DTWKDAT14", "DTWKDATX3", "DTWKDATX4", "DTWKDATX5", "DTWKDATX6", "DTWKDATX7", "DTWKDATX8", "DTWKDATX9", "DTWKDATX10", "DTWKDATX11", "DTWKDATX12", "DTWKDATX13", "DTWKDATX14", "DTYEAR", "DTYEAR2", "DTYEAR3", "DTYEAR4", "DTYYQC", "DTYYQC4", "DTYYQC5", "DTYYQC6", "JDATEYTW29", "JNENGOT22", "JNENGOTW33", "MDYAMPM", "MDYAMPM8", "MDYAMPM9", "MDYAMPM10", "MDYAMPM11", "MDYAMPM12", "MDYAMPM13", "MDYAMPM14", "MDYAMPM15", "MDYAMPM16", "NLDATMTM", "NLDATMTM16", "RUSDFDT8", "RUSDFDT9", "TOD", "TOD2", "TOD3", "TOD4", "TOD5", "TOD6", "TOD7", "TOD8", "TOD9", "TOD10", "TOD11", "TOD12", "TOD13", "TOD14", "TOD15", "TOD16", "TOD17", "TOD18", "TOD19", "TOD20"};
    public static String[] TimeFormats = new String[]{"HHMM", "HHMM2", "HHMM3", "HHMM4", "HHMM5", "HHMM6", "HHMM7", "HHMM8", "HHMM9", "HHMM10", "HHMM11", "HHMM12", "HHMM13", "HHMM14", "HHMM15", "HHMM16", "HHMM17", "HHMM18", "HHMM19", "HHMM20", "HOUR", "HOUR2", "HOUR3", "HOUR4", "HOUR5", "HOUR6", "HOUR7", "HOUR8", "HOUR9", "HOUR10", "HOUR11", "HOUR12", "HOUR13", "HOUR14", "HOUR15", "HOUR16", "HOUR17", "HOUR18", "HOUR19", "HOUR20", "JTIMEH", "JTIMEH4", "JTIMEHM", "JTIMEHM8", "JTIMEHW", "JTIMEHW6", "JTIMEMW", "JTIMEMW12", "MMSS", "MMSS2", "MMSS3", "MMSS4", "MMSS5", "MMSS6", "MMSS7", "MMSS8", "MMSS9", "MMSS10", "MMSS11", "MMSS12", "MMSS13", "MMSS14", "MMSS15", "MMSS16", "MMSS17", "MMSS18", "MMSS19", "MMSS20", "NLTIMAP4", "TIME2", "TIME3", "TIME4", "TIME5", "TIME6", "TIME7", "TIMEAMPM2", "TIMEAMPM3", "TIMEAMPM4", "TIMEAMPM5", "TIMEAMPM6", "TIMEAMPM7", "TIMEAMPM8", "TIMEAMPM9", "TIMEAMPM10"};

    public static boolean isFormatToParse(String formatName, Locale locale) {
        boolean parse = false;
        if (locale == null) {
            locale = Locale.US;
        }
        if (formatName != null) {
            String[] pieces = SAStoExcelUtil.getFormatPieces(formatName.toUpperCase(), locale);
            formatName = pieces[0] + pieces[1];
            parse = true;
            for (String s : ToNotParseDateFormats1.DateFormats) {
                if (!formatName.equals(s)) continue;
                return false;
            }
            for (String s : ToNotParseDateFormats2.DateFormats) {
                if (!formatName.equals(s)) continue;
                return false;
            }
            for (String s : DateTimeFormats) {
                if (!formatName.equals(s)) continue;
                return false;
            }
            for (String s : TimeFormats) {
                if (!formatName.equals(s)) continue;
                return false;
            }
        }
        return parse;
    }
}

