/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc.export;

import com.sas.storage.jdbc.export.ExportExcelXMLInterface;
import com.sas.util.transforms.ObjectToStringTransform;

public class RelationalExcelXMLExporter
implements ExportExcelXMLInterface {
    private int rowCount;
    private int columnCount;

    @Override
    public String getFileHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getWorkbookHeader());
        buffer.append(this.getStyleDefinitions());
        buffer.append(this.getWorksheetHeader());
        return buffer.toString();
    }

    @Override
    public String getColumnHeaderLine(Object[] columnHeaders) {
        return this.getLine(null, columnHeaders);
    }

    @Override
    public String getLine(Object rowHeader, Object[] data) {
        StringBuffer line = data != null ? new StringBuffer(data.length * 4) : new StringBuffer();
        line.append("<Row>\n");
        if (rowHeader != null) {
            line.append("<Cell><Data ss:Type=\"String\">");
            this.writeString(rowHeader.toString(), line);
            line.append("</Data></Cell>");
        }
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == null) continue;
                line.append("<Cell><Data ss:Type=\"String\">");
                this.writeString(data[i].toString(), line);
                line.append("</Data></Cell>");
            }
        }
        line.append("</Row>\n");
        return line.toString();
    }

    @Override
    public String getFileTrailer() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getWorksheetTrailer());
        buffer.append(this.getWorkbookTrailer());
        return buffer.toString();
    }

    @Override
    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    protected void writeString(String str, StringBuffer line) {
        line.append(str);
    }

    protected String getWorkbookHeader() {
        return new StringBuffer().append("<?xml version=\"1.0\"?>\n").append("<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\n").append(" xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n").append(" xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n").append(" xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n").append(" xmlns:html=\"http://www.w3.org/TR/REC-html40\">\n").toString();
    }

    protected String getStyleDefinitions() {
        return new StringBuffer().append(" <Styles>\n").append("  <Style ss:ID=\"Default\" ss:Name=\"Normal\">\n").append("   <Alignment ss:Vertical=\"Bottom\"/>\n").append("   <Borders/>\n").append("   <Font/>\n").append("   <Interior/>\n").append("   <NumberFormat/>\n").append("   <Protection/>\n").append("  </Style>\n").append(" </Styles>\n").toString();
    }

    protected String getWorksheetHeader() {
        return new StringBuffer().append(" <Worksheet ss:Name=\"Sheet1\">\n").append("  <Table ss:ExpandedColumnCount=\"").append(this.columnCount).append("\" ss:ExpandedRowCount=\"").append(this.rowCount + 1).append("\" x:FullColumns=\"1\"\n").append("   x:FullRows=\"1\">\n").toString();
    }

    protected String getWorksheetTrailer() {
        return new StringBuffer().append("   </Table>\n").append("  </Worksheet>\n").toString();
    }

    protected String getWorkbookTrailer() {
        return "</Workbook>\n";
    }

    protected String objectToString(Object value) {
        return (String)ObjectToStringTransform.defaultInstance.transform(value);
    }
}

