/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util;

import com.sas.prompts.util.RB;
import com.sas.prompts.util.UnsynchronizedStack;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.RelatedObjectList;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PromptContentHandler
extends DefaultHandler {
    private PromptsReadingContext readingContext;
    private CommonLoggerInterface logger;
    private boolean firstElement = true;
    private boolean _processingObjectOrObjectUseElement = false;
    private AttributesProvider _attributesProvider;
    private PersistenceInterface masterObject = null;
    private UnsynchronizedStack _elementLocationStack = new UnsynchronizedStack();
    private UnsynchronizedStack _relatedItemHoldersStack = new UnsynchronizedStack();
    private UnsynchronizedStack _relatedItemListsStack = new UnsynchronizedStack();
    private LoggerFactoryInterface factory;
    private StringBuffer charsBuf = new StringBuffer();
    private static final String RB_KEY = "PromptContentHandler.";
    public static final UsageVersion oldestVersion = new UsageVersion(1, 0);
    public static final UsageVersion currentVersion = new UsageVersion(2, 2);
    private UnsynchronizedStack _unusedRelatedItemListsCache = new UnsynchronizedStack();
    private UnsynchronizedStack _unusedRelatedItemsHoldersCache = new UnsynchronizedStack();

    PromptContentHandler(LoggerFactoryInterface logFactory, PromptsReadingContext readingContext) {
        this.readingContext = readingContext;
        this.factory = logFactory;
        this.logger = LoggerRepository2.getLogger(this.getClass().getName(), logFactory);
        this._attributesProvider = PersistenceFactory.newAttributesProvider(readingContext, 1, null, logFactory);
    }

    public static PromptContentHandler newHandlerForElement2(String elementName, LoggerFactoryInterface factory, PromptsReadingContext readingContext) {
        ValidateArg.notNull((Object)elementName, (String)"elementName");
        PromptContentHandler handler = null;
        if (PromptObjectFactory.getInstance().isElementRecognized(elementName)) {
            handler = PromptContentHandler.newHandler2(factory, readingContext);
        }
        return handler;
    }

    public static PromptContentHandler newHandler2(LoggerFactoryInterface factory, PromptsReadingContext readingContext) {
        ValidateArg.notNull((Object)readingContext, (String)"readingContext");
        if (factory == null) {
            factory = new Log4JFactory2();
        }
        return new PromptContentHandler(factory, readingContext);
    }

    public PersistenceInterface getObject() {
        return this.masterObject;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String elementName, Attributes atts) throws SAXException {
        this.logger.debug("<<startElement>>", elementName);
        this.charsBuf.setLength(0);
        this._elementLocationStack.push(elementName);
        if (this._processingObjectOrObjectUseElement) {
            this.handleNewRelationshipElement(elementName);
        } else {
            String versionString = atts.getValue("version");
            if (versionString != null) {
                try {
                    UsageVersion version = UsageVersion.parseVersion((String)versionString);
                    if (version.getMajorVersion() == 9 && version.getMinorVersion() == 2) {
                        version = oldestVersion;
                    }
                    if (!version.isReadCompatible(oldestVersion, currentVersion)) {
                        String msg = MessageFormat.format(RB.getStringResource(RB_KEY, "IncompatibleVersion.fmt"), version, currentVersion, elementName);
                        throw new SAXException(msg);
                    }
                }
                catch (ParseException e) {
                    this.logger.error("startElement(), error parsing version: " + versionString);
                    throw new SAXException(e);
                }
            }
            this._attributesProvider.reinitializeForConsumptionOfAttributes(atts);
            PersistenceInterface obj = null;
            try {
                obj = elementName.endsWith("Use") ? this.handleNewObjectUseElement(elementName) : this.handleNewObjectElement(elementName);
            }
            catch (SAXException ex) {
                if (!this.firstElement) {
                    this.logger.warn("startElement() unknown element: " + elementName);
                    this.readingContext.addUnknownElement(elementName);
                }
                throw ex;
            }
            if (this.firstElement) {
                this.firstElement = false;
            } else if (obj != null) {
                RelatedObjectList referencedItems = (RelatedObjectList)this._relatedItemListsStack.peek();
                referencedItems.add(obj);
            }
        }
        this._processingObjectOrObjectUseElement = !this._processingObjectOrObjectUseElement;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        if (this._processingObjectOrObjectUseElement) {
            if (!elementName.endsWith("Use")) {
                this.handleEndObjectElement(elementName);
            }
        } else {
            this.handleEndRelationshipElement(elementName);
        }
        this._processingObjectOrObjectUseElement = !this._processingObjectOrObjectUseElement;
        this._elementLocationStack.removeTOS();
        this.logger.debug("<<endElement>>", elementName);
    }

    @Override
    public void characters(char[] buf, int offset, int length) throws SAXException {
        if (length > 0) {
            this.charsBuf.append(buf, offset, length);
        }
    }

    private String getCharacters() {
        String retval = this.charsBuf.toString();
        this.charsBuf.setLength(0);
        return retval;
    }

    private void handleNewRelationshipElement(String elementName) {
        this.logger.debug("handleNewRelationshipElement():  elementName=", elementName);
        RelatedObjectList acquired = this.acquireRelatedItemList(elementName);
        this._relatedItemListsStack.push(acquired);
    }

    private RelatedObjectList acquireRelatedItemList(String relationshipName) {
        RelatedObjectList acquired = null;
        if (this._unusedRelatedItemListsCache.size() > 0) {
            acquired = (RelatedObjectList)this._unusedRelatedItemListsCache.pop();
            acquired.reinitializeForAdditionOfRelatedObjects(relationshipName);
        } else {
            acquired = PersistenceFactory.newRelatedObjectList(relationshipName, this.factory);
        }
        return acquired;
    }

    private PersistenceInterface handleNewObjectElement(String elementName) throws SAXException {
        this.logger.debug("handleNewObjectElement():", elementName);
        PersistenceInterface obj = null;
        if (this._elementLocationStack.size() == 1 && null != this.readingContext.getModel() && this.readingContext.getModel().getDefinitionElementName().equals(elementName)) {
            obj = this.readingContext.getModel();
            this._attributesProvider.consumeAttr("obj");
            this.logger.debug("Using model from reading context");
        } else {
            String persistenceID = this._attributesProvider.consumeAttr("obj");
            try {
                obj = this.readingContext.getObjectForNewObjectElement(persistenceID, elementName);
            }
            catch (SAXException e) {
                if (this._elementLocationStack.size() != 1) {
                    this.logger.warn("startElement() unknown element: " + elementName);
                    this.readingContext.addUnknownElement(elementName);
                    return null;
                }
                throw e;
            }
        }
        this.processObjectElement(obj);
        return obj;
    }

    private void processObjectElement(PersistenceInterface obj) throws SAXException {
        RelatedObjectList[] rolsFromAttrs = null;
        if (this._attributesProvider.hasAttrsRemainingToBeConsumed()) {
            rolsFromAttrs = this.consumeAttrsCheckingForFullConsumption(obj);
        }
        this.acquireAndPushRelatedItemsHolder(obj, rolsFromAttrs);
    }

    private void handleEndRelationshipElement(String elementName) throws SAXException {
        RelatedObjectList ril;
        this.logger.debug("handleEndRelationshipElement():  elementName=", elementName);
        if (this._relatedItemHoldersStack.size() > 0 && (ril = (RelatedObjectList)this._relatedItemListsStack.peek()) != null && Strings.equal((String)ril.getRelationshipName(), (String)elementName, (boolean)true, (boolean)true)) {
            ril = (RelatedObjectList)this._relatedItemListsStack.pop();
            RelatedObjectListsHolder rilsHolder = (RelatedObjectListsHolder)this._relatedItemHoldersStack.peek();
            rilsHolder.add(ril);
        }
    }

    private void handleEndObjectElement(String elementName) throws SAXException {
        RelatedObjectListsHolder riHolder;
        this.logger.debug("handleEndObjectElement()", elementName);
        if (this._relatedItemHoldersStack.size() > 0 && (riHolder = (RelatedObjectListsHolder)this._relatedItemHoldersStack.peek()) != null && riHolder.getObject() != null && Strings.equal((String)riHolder.getObject().getDefinitionElementName(), (String)elementName, (boolean)true, (boolean)true)) {
            riHolder = (RelatedObjectListsHolder)this._relatedItemHoldersStack.pop();
            PersistenceInterface objectWhoseDefinitionHasEnded = riHolder.getObject();
            String input = this.getCharacters();
            if (null != input && input.length() > 0) {
                objectWhoseDefinitionHasEnded.consumeElementText(input);
            }
            if (riHolder.hasRelatedObjectsToBeConsumed()) {
                objectWhoseDefinitionHasEnded.consumeRelatedObjects(riHolder);
            }
            if (this._relatedItemHoldersStack.size() < 1) {
                this.masterObject = objectWhoseDefinitionHasEnded;
                this.logger.debug("Parsing is complete for", objectWhoseDefinitionHasEnded.toString());
            }
            this.recache(riHolder);
        }
    }

    private void recache(RelatedObjectListsHolder riHolder) {
        int count = riHolder.getRelationshipsCount();
        if (count > 0) {
            RelatedObjectList[] rils = riHolder.trustedGetROLsStorage();
            for (int i = 0; i < count; ++i) {
                this._unusedRelatedItemListsCache.push(rils[i]);
            }
        }
        this._unusedRelatedItemsHoldersCache.push(riHolder);
    }

    private void acquireAndPushRelatedItemsHolder(PersistenceInterface objWhoseDefinitionIsBeingRead, RelatedObjectList[] rolsToStartWith) throws SAXException {
        RelatedObjectListsHolder acquired = null;
        if (this._unusedRelatedItemsHoldersCache.size() > 0) {
            acquired = (RelatedObjectListsHolder)this._unusedRelatedItemsHoldersCache.pop();
            acquired.reinitializeForAdditionOfRelatedItemLists(objWhoseDefinitionIsBeingRead, rolsToStartWith);
        } else {
            acquired = PersistenceFactory.newRelatedObjectListsHolder(objWhoseDefinitionIsBeingRead, this.readingContext, rolsToStartWith, this.factory);
        }
        this._relatedItemHoldersStack.push(acquired);
    }

    private RelatedObjectList[] consumeAttrsCheckingForFullConsumption(PersistenceInterface obj) throws SAXException {
        RelatedObjectList[] rolsFromAttrs = null;
        obj.consumeAttributes(this._attributesProvider);
        List unconsumedAttrNames = this._attributesProvider.getUnconsumedAttrNames();
        if (unconsumedAttrNames != null) {
            for (Object attribute : unconsumedAttrNames) {
                this.readingContext.addUnknownAttribute(obj, attribute);
            }
        }
        return rolsFromAttrs;
    }

    public String getElementLocation() {
        int elementCount = this._elementLocationStack.size();
        StringBuffer buf = new StringBuffer(elementCount * 22);
        for (int i = 0; i < elementCount; ++i) {
            buf.append('<');
            buf.append(this._elementLocationStack.get(i).toString());
            buf.append('>');
        }
        return buf.toString();
    }

    private PersistenceInterface handleNewObjectUseElement(String useElementName) throws SAXException {
        String persistenceID = this._attributesProvider.consumeAttr("ref");
        if (persistenceID == null) {
            String msg = MessageFormat.format(RB.getStringResource(RB_KEY, "MissingAttributeOnElement.fmt.log"), "ref", useElementName);
            throw new SAXException(msg);
        }
        if (this._attributesProvider.hasAttrsRemainingToBeConsumed()) {
            String msg = MessageFormat.format(RB.getStringResource(RB_KEY, "AttributeNamesOtherThanAreNotDefinedForElement.fmt.log"), "ref", useElementName);
            throw new SAXException(msg);
        }
        this.logger.debug("handleNewObjectUseElement()", persistenceID);
        int lsize = useElementName.length();
        String useOfType = useElementName.substring(0, lsize - 3);
        PersistenceInterface out = this.readingContext.getObjectForUsedObjectElement(useOfType, persistenceID);
        return out;
    }
}

