/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.models.SASLibraryLocation;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class SASLibraryLocationValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "SASLibraryLocation";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String location = PersistHelper.parseSBIPUrl(provider.consumeAttr("location"));
        String name = provider.consumeAttr("libref");
        SASLibraryLocation newSASLibraryLocation = new SASLibraryLocation(location, name);
        this.setValue(newSASLibraryLocation);
        this.getLogger2().debug("consumeAttributes(), value was set to:", newSASLibraryLocation.toString());
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            SASLibraryLocationInterface sasLibraryLocation = (SASLibraryLocationInterface)this.getValue();
            String sbipUrl = PersistHelper.parseSBIPUrl(sasLibraryLocation.getSASLibraryLocation());
            if (null != sbipUrl) {
                this.getLogger2().debug("writing definition as:", sbipUrl);
                XmlUtil.setAttr(element, "location", "URL::" + sbipUrl);
                MetadataDescriptor descriptor = PersistenceFactory.newMetadataDescriptor(null);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("SBIP_URL", sbipUrl);
                descriptor.setAdditionalInfo(info);
                descriptor.setType("SAS_LIBRARY");
                writingContext.addMetadataDescriptor(descriptor);
            }
            XmlUtil.setAttr(element, "libref", sasLibraryLocation.getLibref());
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

