/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.models.BaseFontInfo;
import com.sas.models.FontInfoInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class FontValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "FontValue";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String font = provider.consumeAttr("font");
        int fontSize = provider.consumeIntAttr("fontSize", 6);
        boolean isBold = provider.consumeBooleanAttr("isBold", false);
        boolean isItalic = provider.consumeBooleanAttr("isItalic", false);
        boolean isUnderline = provider.consumeBooleanAttr("isUnderline", false);
        BaseFontInfo newFontInfo = new BaseFontInfo(font, fontSize, isBold, isItalic, isUnderline, Locale.getDefault());
        this.setValue(newFontInfo);
        this.getLogger2().debug("consumeAttributes(), value was set to:", newFontInfo.toString());
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            FontInfoInterface fontInfo = (FontInfoInterface)this.getValue();
            XmlUtil.setAttr(element, "font", fontInfo.getFontFamily(Locale.getDefault()));
            XmlUtil.setIntAttr(element, "fontSize", fontInfo.getFontSize());
            XmlUtil.setBooleanAttr(element, "isBold", fontInfo.isBold(), false);
            XmlUtil.setBooleanAttr(element, "isItalic", fontInfo.isItalic(), false);
            XmlUtil.setBooleanAttr(element, "isUnderline", fontInfo.isUnderline(), false);
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

