/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.models.FileLocation;
import com.sas.models.FileLocationInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class FileLocationValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "FileLocation";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String serverName = provider.consumeAttr("serverName");
        String fileLocation = provider.consumeAttr("fileLocation");
        boolean isDirectory = provider.consumeBooleanAttr("isDirectory", false);
        FileLocation newFileLocation = new FileLocation(serverName, fileLocation, isDirectory);
        this.setValue(newFileLocation);
        this.getLogger2().debug("consumeAttributes(), value was set to:", newFileLocation.toString());
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            FileLocationInterface fileLocation = (FileLocationInterface)this.getValue();
            XmlUtil.setAttr(element, "serverName", fileLocation.getServerName());
            XmlUtil.setAttr(element, "fileLocation", fileLocation.getFileLocation());
            XmlUtil.setBooleanAttr(element, "isDirectory", fileLocation.isDirectory(), false);
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

