/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.iqt;

import com.sas.tools.installs.iqt.ProgressMonitor;
import com.sas.tools.installs.iqt.ValidationListType;
import com.sas.tools.installs.iqt.ValidationType;
import com.sas.tools.installs.iqt.ValidationTypeComparator;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;

public class Main {
    private static Vector<ValidationType> checksumPass = new Vector();
    private static Vector<ValidationType> checksumNotDetermined = new Vector();
    private static Vector<ValidationType> checksumWrong = new Vector();
    private static Vector<ValidationType> fileNotFound = new Vector();
    private static Vector<ValidationType> unknown = new Vector();
    private static Vector<ValidationType> skipChecksum = new Vector();
    private static Vector<ValidationType> missingValidationData = new Vector();
    private static Vector<ValidationType> excludedFiles = new Vector();
    private static ProgressMonitor pm;
    private static boolean silent;

    public static void main(String[] args) throws Exception {
        String defaultLogPath = "InstallMisc/InstallLogs";
        String masterFileName = "ValidationFileList.xml";
        String reportFileName = "ValidationReport_";
        String metaDataFileName = "ValidationReport.xml";
        String sasHome = "";
        String redirectPath = "";
        String DATE_FORMAT_NOW = "yyyy-MM-dd-HH.mm.ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        boolean redirectOutput = false;
        if (Main.validateArgs(args)) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-sashome")) {
                    sasHome = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-silent")) {
                    silent = true;
                    System.setProperty("java.awt.headless", "true");
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                }
                if (!args[i].equalsIgnoreCase("-out")) continue;
                redirectOutput = true;
                redirectPath = args[i + 1];
            }
            File logDir = new File(sasHome, defaultLogPath);
            File outputDir = redirectOutput ? new File(redirectPath) : logDir;
            File masterFilePath = new File(logDir, masterFileName);
            File reportFilePath = new File(outputDir, reportFileName + sdf.format(cal.getTime()) + ".html");
            if (!masterFilePath.exists()) {
                System.out.println("Cannot find metadata file required for validation: " + masterFilePath);
                System.exit(-1);
            }
            System.out.println("Validating files...");
            if (!silent) {
                pm = new ProgressMonitor();
            }
            Main.compare(sasHome, Main.unmarshal(masterFilePath));
            Main.exclusionList(sasHome);
            Main.writeReport(Main.report(sasHome), reportFilePath.toString());
            System.out.println("Validation complete. See " + reportFilePath + " for results.");
            if (!silent) {
                pm.getStatusText().setText("");
                if (System.getProperty("os.name").startsWith("Windows")) {
                    pm.getTextPane().setText("<h4>Validation complete.  See <a href=\"file:\\\\" + reportFilePath + "\">" + reportFilePath + "</a> for details</h4>");
                } else {
                    pm.getTextPane().setText("<h4>Validation complete.  See <a href=\"file://" + reportFilePath + "\">" + reportFilePath + "</a> for details</h4>");
                }
                pm.getStatusPanel().add(pm.getTextPane());
                pm.validate();
                pm.pack();
            }
        }
    }

    public static ValidationListType unmarshal(File valFile) throws JAXBException {
        ValidationListType fileData = null;
        try {
            JAXBContext jc = JAXBContext.newInstance(ValidationListType.class);
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement<ValidationListType> installJax = u.unmarshal(new StreamSource(valFile), ValidationListType.class);
            fileData = installJax.getValue();
        }
        catch (JAXBException e) {
            System.out.println("Unable to unmarshal the master validation file, " + valFile);
            e.printStackTrace();
        }
        if (!silent) {
            pm.getBar().setMaximum(fileData.sasfile.size());
        }
        return fileData;
    }

    public static void compare(String sashome, ValidationListType vlt) {
        List<ValidationType> fList = vlt.getSasfile();
        String pre = null;
        String post = null;
        int fileCount = 0;
        int errorCount = 0;
        for (ValidationType v : fList) {
            if (v.getName().contains("9.4_PREVIOUS")) continue;
            File fullPath = new File(v.getName());
            File file = fullPath.exists() ? fullPath : new File(sashome, v.getName());
            String checkFile = file.toString();
            if (silent) {
                System.out.println(checkFile);
            }
            ++fileCount;
            if (!silent) {
                pm.getStatusText().setText("Validating file " + fileCount + " of " + fList.size());
                pm.progress(fileCount);
            }
            if (file.exists()) {
                pre = v.getChecksum();
                post = Main.getMd5(checkFile);
                v.setPostChecksum(post);
                if (Main.exclude(v.getName())) {
                    skipChecksum.add(v);
                } else if (pre == null) {
                    missingValidationData.add(v);
                } else if (post == null) {
                    checksumNotDetermined.add(v);
                    ++errorCount;
                } else if (pre.equalsIgnoreCase(post)) {
                    checksumPass.add(v);
                } else if (!pre.equalsIgnoreCase(post)) {
                    checksumWrong.add(v);
                    ++errorCount;
                } else {
                    unknown.add(v);
                    ++errorCount;
                }
            } else {
                fileNotFound.add(v);
                ++errorCount;
            }
            if (!silent) {
                pm.getBottomLabel().setText(errorCount + " files with validation errors.");
            }
            ValidationTypeComparator vc = new ValidationTypeComparator();
            Collections.sort(checksumPass, vc);
            Collections.sort(skipChecksum, vc);
            Collections.sort(checksumNotDetermined, vc);
            Collections.sort(checksumWrong, vc);
            Collections.sort(unknown, vc);
            Collections.sort(fileNotFound, vc);
        }
    }

    public static boolean exclude(String fileTypes) {
        boolean exclude = false;
        if (fileTypes.endsWith(".ini")) {
            exclude = true;
        }
        if (fileTypes.endsWith(".sas7bitm")) {
            exclude = true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exclusionList(String sasHome) {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File("ExclusionList.properties"));
            properties.load(fis);
            for (String prodCode : properties.stringPropertyNames()) {
                String[] names;
                for (String name : names = properties.getProperty(prodCode).split(";")) {
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        name = name.replace('/', '\\');
                    }
                    if (!Main.exclusionFileExists(name, prodCode)) continue;
                    ValidationType exclusion = new ValidationType();
                    exclusion.setProdcode(prodCode);
                    exclusion.setName(name);
                    excludedFiles.add(exclusion);
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("Error opening file: ExclusionList.txt\n" + ioe);
            pm.getStatusText().setText("Error opening ExclusionList.txt. See log for details.");
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                System.out.println("Error closing file: ExclusionList.txt\n" + ioe);
                pm.getStatusText().setText("Error closing ExclusionList.txt. See log for details.");
            }
        }
    }

    public static boolean exclusionFileExists(String name, String prodCode) {
        for (ValidationType vt : checksumWrong) {
            if (!vt.getName().equals(name) || !vt.getProdcode().equals(prodCode)) continue;
            checksumWrong.remove(vt);
            return true;
        }
        for (ValidationType vt : fileNotFound) {
            if (!vt.getName().equals(name) || !vt.getProdcode().equals(prodCode)) continue;
            fileNotFound.remove(vt);
            return true;
        }
        return false;
    }

    public static String report(String sashome) {
        Vector<Vector<ValidationType>> buckets = new Vector<Vector<ValidationType>>(9);
        buckets.add(excludedFiles);
        buckets.add(missingValidationData);
        buckets.add(checksumWrong);
        buckets.add(checksumNotDetermined);
        buckets.add(fileNotFound);
        buckets.add(unknown);
        buckets.add(skipChecksum);
        buckets.add(checksumPass);
        StringBuffer htmlBuffer = new StringBuffer();
        String startHTML = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n<head>\n<title>SAS Install Qualification Summary</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" >\n<style type=\"text/css\">\nbody { font-family: Arial, Helvetica, sans-serif; font-size: 9pt;}\ndiv.alt { background-color:#eeeeee;}\n div{padding: 1em;width:100%;}\n</style>\n</head>\n<body>\n";
        String docHeading = "SAS Install Qualification Results";
        String sasHomePath = "SASHOME Path:  " + sashome;
        String firstParagraph = "When the SAS Installation Qualification Tool is run, the resulting validation is based on the state of the system at the time the initial installation completed. The tool&#39;s validation detects most manual modifications that the user makes to the SAS software components after the initial installation. So, for example, when the user installs software after an initial installation &mdash;such as adding additional products to the install or applying maintenance&mdash; the tool should not flag the additional files as having changed.";
        String secondParagraph = "However, modifications that the user makes to the configuration files (such as sasv9.cfg or INI files) will be flagged by the tool as having different checksum values as compared to the files that were originally installed on the system. In addition, renewing your SAS license will cause the tool to flag files that have changed, such as the core.sas7bcat file. Since these kinds of changes are expected, if any are found during the validation, they will be listed in the &#147;Excluded Files&#147; section.";
        String altOn = "<div class=\"alt\"><pre>\n";
        String altOff = "<div><pre>\n";
        String containerColor = "";
        String sectionDesc = "";
        int count = 0;
        htmlBuffer.append(startHTML).append("<h1>").append(docHeading).append("</h1>\n<h3>").append(sasHomePath).append("</h3>\n");
        htmlBuffer.append("<h4>").append(firstParagraph).append("</h4>\n");
        htmlBuffer.append("<h4>").append(secondParagraph).append("</h4><br>\n");
        for (Vector vector : buckets) {
            String sectionHeader;
            if (vector == checksumWrong) {
                sectionHeader = "Checksum Data Does Not Match:";
                containerColor = "red";
                sectionDesc = "";
            } else if (vector == missingValidationData) {
                sectionHeader = "Incomplete Validation Metadata:";
                containerColor = "red";
                sectionDesc = "";
            } else if (vector == skipChecksum) {
                sectionHeader = "Checksum Validation Voluntarily Skipped For Files:";
                containerColor = "purple";
                sectionDesc = "";
            } else if (vector == checksumNotDetermined) {
                sectionHeader = "Could Not Determine Checksum:";
                containerColor = "red";
                sectionDesc = "";
            } else if (vector == checksumPass) {
                sectionHeader = "Checksum Validation Passed:";
                containerColor = "green";
                sectionDesc = "";
            } else if (vector == fileNotFound) {
                sectionHeader = "Files Not Found";
                containerColor = "yellow";
                sectionDesc = "This list contains files that were originally in the SAS Software Depot but are no longer present at the time of this validation. No action is required unless a user expects to see a file that is no longer present. Because the file is not present, no validation can take place.";
            } else if (vector == excludedFiles) {
                sectionHeader = "Excluded Files";
                containerColor = "yellow";
                sectionDesc = "Excluded files are those for which the tool expected to find a difference. No action is required on the part of the user for these files.";
            } else {
                sectionHeader = "Unknown Errors:";
                containerColor = "red";
                sectionDesc = "";
            }
            if (!vector.isEmpty()) {
                htmlBuffer.append("<fieldset style=\"border:1px solid ").append(containerColor).append(";font-size:150%;\">\n<legend><b>").append(sectionHeader).append("</b></legend>\n");
                if (!sectionDesc.isEmpty()) {
                    htmlBuffer.append("<div>").append(sectionDesc).append("</div>\n");
                }
                for (ValidationType vt : vector) {
                    String div = ++count % 2 == 0 ? altOn : altOff;
                    htmlBuffer.append(div).append("\n[" + count + "]\n").append("SOFTWARE CODE:            ").append(vt.getProdcode());
                    htmlBuffer.append("\nFILE:                     <b>").append(vt.getName());
                    if (vector != excludedFiles) {
                        htmlBuffer.append("</b>\nPRE-INSTALL CHECKSUM:     ").append(vt.getChecksum());
                        htmlBuffer.append("\nPOST-INSTALL CHECKSUM:    ").append(vt.getPostChecksum()).append("\n</pre></div>\n");
                        continue;
                    }
                    htmlBuffer.append("</b>\n</pre></div>\n");
                }
                htmlBuffer.append("</fieldset><br>\n");
            }
            count = 0;
        }
        htmlBuffer.append("</body>\n</html>\n");
        return htmlBuffer.toString();
    }

    public static void marshalXMLReport() {
    }

    public static String getMd5(String filename) {
        MessageDigest digester = null;
        FileInputStream fis = null;
        DigestInputStream dis = null;
        try {
            fis = new FileInputStream(filename);
            digester = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, digester);
            byte[] bytes = new byte[8192];
            int count = dis.read(bytes);
            while (count != -1 && count <= 8192) {
                count = dis.read(bytes);
            }
            fis.close();
            dis.close();
        }
        catch (Exception e) {
            System.out.println("Error processing md5sum for file: " + filename);
            System.out.println(e);
            return null;
        }
        return Main.md5sumToString(digester);
    }

    public static String md5sumToString(MessageDigest digester) {
        byte[] chk = digester.digest();
        String hexvalue = "";
        for (int i = 0; i < chk.length; ++i) {
            int bytevalue = chk[i] >= 0 ? chk[i] : 256 + chk[i];
            String hexvaluestring = Integer.toHexString(bytevalue);
            if (hexvaluestring.length() == 1) {
                hexvaluestring = "0" + hexvaluestring;
            }
            hexvalue = hexvalue + hexvaluestring;
        }
        return hexvalue;
    }

    public static boolean writeReport(String content, String toFile) {
        try {
            FileWriter fout = new FileWriter(toFile);
            fout.write(content);
            fout.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Error writing file:  " + toFile + "\n" + e);
            pm.getStatusText().setText("Error writing report file.  See log for details.");
            return false;
        }
    }

    public static boolean validateArgs(String[] opts) {
        boolean validOptions = true;
        boolean sashomePassed = false;
        for (int i = 0; i < opts.length; ++i) {
            File path;
            if (opts[i].startsWith("-") && !opts[i].equalsIgnoreCase("-sashome") && !opts[i].equalsIgnoreCase("-silent") && !opts[i].equalsIgnoreCase("-out")) {
                validOptions = false;
                System.out.println("Invalid option: " + opts[i] + ". Acceptable options: \"-sashome\", \"-silent\", \"-out\".");
                continue;
            }
            if (opts[i].equalsIgnoreCase("-sashome")) {
                sashomePassed = true;
                if (i == opts.length - 1) {
                    validOptions = false;
                    System.out.println("No path passed with -sashome. Option must be followed by a path.");
                    continue;
                }
                path = new File(opts[i + 1]);
                if (!path.isDirectory()) {
                    validOptions = false;
                    System.out.println("SASHOME path \"" + opts[i + 1] + "\" is not valid.");
                    continue;
                }
                if (path.canWrite()) continue;
                continue;
            }
            if (!opts[i].equalsIgnoreCase("-out")) continue;
            if (i == opts.length - 1) {
                validOptions = false;
                System.out.println("-out must be followed by a path. Please run again using -out with a valid path.");
                continue;
            }
            path = new File(opts[i + 1]);
            if (!path.isDirectory()) {
                validOptions = false;
                System.out.println("The path \"" + opts[i + 1] + "\" is not valid.  Please run again using -out with a valid path.");
                continue;
            }
            if (path.canWrite()) continue;
        }
        if (!sashomePassed) {
            validOptions = false;
            System.out.println("Missing -sashome option.  Please run again with required -sashome option and path.");
        }
        return validOptions;
    }

    static {
        silent = false;
    }
}

