/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.webdav;

import com.sas.contentserver.commons.SpecialNameChars;
import com.sas.contentserver.core.lock.SASLockManagerImpl;
import com.sas.contentserver.core.session.SASSessionImpl;
import com.sas.contentserver.security.SASDefaultAccessManager;
import com.sas.contentserver.security.SASPrivilege;
import com.sas.contentserver.security.SASUserManagerImpl;
import com.sas.contentserver.webdav.Dasl2JCRXPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.server.io.CopyMoveContext;
import org.apache.jackrabbit.server.io.CopyMoveContextImpl;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.PropertyImportContext;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.search.QueryGrammerSet;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.search.SearchResource;
import org.apache.jackrabbit.webdav.security.AclProperty;
import org.apache.jackrabbit.webdav.security.AclResource;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.security.SupportedPrivilege;
import org.apache.jackrabbit.webdav.security.SupportedPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.report.AclPrincipalReport;
import org.apache.jackrabbit.webdav.security.report.PrincipalMatchReport;
import org.apache.jackrabbit.webdav.security.report.PrincipalSearchReport;
import org.apache.jackrabbit.webdav.security.report.SearchablePropertyReport;
import org.apache.jackrabbit.webdav.simple.DavResourceImpl;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.apache.jackrabbit.webdav.simple.VersionControlledResourceImpl;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AclResourceImpl
extends VersionControlledResourceImpl
implements AclResource,
SearchResource {
    private static final SupportedPrivilege[] SUPPORTED_PRIVILEGES = new SupportedPrivilege[]{new SupportedPrivilege(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_READ, "Read", "en", false, null), new SupportedPrivilege(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_WRITE, "Write", "en", false, null), new SupportedPrivilege(SASPrivilege.PRIVILEGE_DELETE, "Delete", "en", false, null), new SupportedPrivilege(SASPrivilege.PRIVILEGE_ADMIN, "Administer", "en", false, null), new SupportedPrivilege(SASPrivilege.PRIVILEGE_INHERIT_READ, "Inherit Read", "en", false, null), new SupportedPrivilege(SASPrivilege.PRIVILEGE_INHERIT_WRITE, "Inherit Write", "en", false, null), new SupportedPrivilege(SASPrivilege.PRIVILEGE_INHERIT_DELETE, "Inherit Delete", "en", false, null), new SupportedPrivilege(SASPrivilege.PRIVILEGE_INHERIT_ADMIN, "Inherit Administer", "en", false, null)};
    private static final Logger log = LoggerFactory.getLogger(AclResourceImpl.class);
    private ResourceConfig config;

    public AclResourceImpl(DavResourceLocator locator, DavResourceFactory factory, DavSession session, ResourceConfig config, boolean isCollection) throws DavException {
        super(locator, factory, session, config, isCollection);
        this.initSupportedReports();
        this.config = config;
    }

    public AclResourceImpl(DavResourceLocator locator, DavResourceFactory factory, DavSession session, ResourceConfig config, Item item) throws DavException {
        super(locator, factory, session, config, item);
        this.initSupportedReports();
        this.config = config;
    }

    public String getComplianceClass() {
        return super.getComplianceClass() + "," + "access-control" + "," + "version-control" + "," + "version-history" + "," + "label";
    }

    public String getSupportedMethods() {
        StringBuffer sb = new StringBuffer(super.getSupportedMethods());
        sb.append(", ").append("ACL");
        sb.append(", ").append("REPORT");
        sb.append(", ").append("SEARCH");
        if (!this.isCollection() && this.isVersionControlled()) {
            sb.append(", ").append("UNCHECKOUT");
        }
        return sb.toString();
    }

    protected void initProperties() {
        if (!this.propsInitialized) {
            super.initProperties();
            Node n = this.getNode();
            if (URLDecoder.decode(this.getHref()).contains("/rep:security/rep:authorizables/rep:users/")) {
                this.properties.remove(DavPropertyName.RESOURCETYPE);
                this.properties.add((DavProperty)new ResourceType(SecurityConstants.PRINCIPAL_RESOURCETYPE));
            }
            try {
                Node frozen;
                Property prop;
                if (this.getNode() instanceof Version && ((prop = (frozen = this.getNode().getNode("jcr:frozenNode")).getProperty("jcr:frozenPrimaryType")).getString().equals("nt:file") || prop.getString().equals("nt:resource"))) {
                    this.properties.remove(DavPropertyName.RESOURCETYPE);
                    this.properties.add((DavProperty)new ResourceType(0));
                    this.properties.remove(DavPropertyName.ISCOLLECTION);
                    this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
                }
            }
            catch (RepositoryException e) {
                log.debug("Error while accessing jcr:frozenNode property");
            }
            try {
                String autoversion = this.getAutoVersion(n);
                if (autoversion != null) {
                    this.properties.remove(VersionControlledResource.AUTO_VERSION);
                    this.properties.add((DavProperty)new DefaultDavProperty(VersionControlledResource.AUTO_VERSION, (Object)autoversion, false));
                }
            }
            catch (RepositoryException e) {
                log.debug("Error while accessing jcr:auto-version property");
            }
            try {
                this.properties.add((DavProperty)new SupportedPrivilegeSetProperty(SUPPORTED_PRIVILEGES));
                Session session = n.getSession();
                ArrayList<org.apache.jackrabbit.webdav.security.Privilege> curprivs = new ArrayList<org.apache.jackrabbit.webdav.security.Privilege>();
                try {
                    session.checkPermission(this.getNode().getPath(), "read");
                    curprivs.add(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_READ);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    session.checkPermission(this.getNode().getPath(), "set_property");
                    curprivs.add(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_WRITE);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    session.checkPermission(this.getNode().getPath(), "remove");
                    curprivs.add(SASPrivilege.PRIVILEGE_DELETE);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                if (curprivs.size() > 0) {
                    this.properties.add((DavProperty)new CurrentUserPrivilegeSetProperty(curprivs.toArray(new org.apache.jackrabbit.webdav.security.Privilege[0])));
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
    }

    protected void initSupportedReports() {
        super.initSupportedReports();
        if (this.exists()) {
            this.supportedReports.addReportType(ReportType.register((String)"acl-principal-prop-set", (Namespace)DavConstants.NAMESPACE, AclPrincipalReport.class));
            this.supportedReports.addReportType(ReportType.register((String)"principal-match", (Namespace)DavConstants.NAMESPACE, PrincipalMatchReport.class));
            this.supportedReports.addReportType(ReportType.register((String)"principal-property-search", (Namespace)DavConstants.NAMESPACE, PrincipalSearchReport.class));
            this.supportedReports.addReportType(ReportType.register((String)"principal-search-property-set", (Namespace)DavConstants.NAMESPACE, SearchablePropertyReport.class));
        }
    }

    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        try {
            boolean avCheckout = this.checkoutPreConditions(this.getNode());
            MultiStatusResponse ret = super.alterProperties(changeList);
            if (avCheckout) {
                this.checkinPostConditions((DavResource)this, this.getNode());
            }
            return ret;
        }
        catch (RepositoryException e) {
            throw new DavException(500, e.toString());
        }
    }

    public void alterAcl(AclProperty aclProperty) throws DavException {
        List<AclProperty> list = Collections.singletonList(aclProperty);
        this.alterProperties(list);
    }

    public void addMember(DavResource member, InputContext inputContext) throws DavException {
        try {
            Node newNode;
            boolean avCheckout = false;
            SASSessionImpl session = (SASSessionImpl)this.getNode().getSession();
            SASDefaultAccessManager acMan = (SASDefaultAccessManager)session.getAccessControlManager();
            String userid = session.getUserID();
            if (userid == null) {
                userid = session.isAdmin() ? ((SASUserManagerImpl)session.getUserManager()).getAdminId() : "jcr:authenticated";
            }
            String resourcePath = SpecialNameChars.encode(member.getResourcePath());
            String memberName = SpecialNameChars.encode(member.getDisplayName());
            resourcePath = resourcePath.substring(resourcePath.indexOf(47) + 1);
            if (session.nodeExists(resourcePath = resourcePath.substring(resourcePath.indexOf(47)))) {
                if (!acMan.isGranted(session.getQPath(resourcePath).getNormalizedPath(), 2)) {
                    throw new DavException(403);
                }
                avCheckout = this.checkoutPreConditions(this.getNode().getNode(memberName));
            } else if (!acMan.isGranted(session.getQPath(resourcePath).getNormalizedPath(), 4)) {
                throw new DavException(403);
            }
            super.addMember(member, inputContext);
            boolean forcedCheckedOut = false;
            if (super.getNode().hasProperty("jcr:enforce-versionable")) {
                newNode = super.getNode().getNode(memberName);
                Property p = super.getNode().getProperty("jcr:enforce-versionable");
                if (p.getBoolean()) {
                    if (newNode.isNodeType("nt:folder")) {
                        newNode.addMixin("enforce-versionable");
                        newNode.setProperty("jcr:enforce-versionable", true);
                    } else if (!newNode.isNodeType("mix:versionable")) {
                        newNode.addMixin("mix:versionable");
                        forcedCheckedOut = true;
                        newNode.addMixin("auto-version");
                        newNode.setProperty("jcr:auto-version", "checkout-unlocked-checkin");
                    }
                    session.save();
                }
            }
            session.doAdmin();
            newNode = session.getNodeByIdentifier(super.getNode().getIdentifier()).getNode(memberName);
            if (newNode != null && (avCheckout || forcedCheckedOut)) {
                this.checkinPostConditions(member, newNode);
            }
            session.endAdmin();
        }
        catch (AccessDeniedException e) {
            log.info("failed to add member", (Throwable)e);
            throw new DavException(403);
        }
        catch (UnsupportedRepositoryOperationException e) {
            log.info("failed to add member", (Throwable)e);
            throw new DavException(500, e.getMessage());
        }
        catch (RepositoryException e) {
            log.info("failed to add member", (Throwable)e);
            throw new DavException(500, e.getMessage());
        }
        finally {
            try {
                ((SASSessionImpl)this.getNode().getSession()).endAdmin();
            }
            catch (RepositoryException e) {
                log.info("failed to add member", (Throwable)e);
                throw new DavException(500, e.getMessage());
            }
        }
    }

    public Report getReport(ReportInfo reportInfo) throws DavException {
        if (reportInfo == null) {
            throw new DavException(400, "A REPORT request must provide a valid XML request body.");
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (this.supportedReports.isSupportedReport(reportInfo)) {
            Report report = ReportType.getType((ReportInfo)reportInfo).createReport((DeltaVResource)this, reportInfo);
            return report;
        }
        throw new DavException(422, "Unkown report " + reportInfo.getReportName() + "requested.");
    }

    public QueryGrammerSet getQueryGrammerSet() {
        QueryGrammerSet qgs = new QueryGrammerSet();
        try {
            String[] langs;
            QueryManager qMgr = this.getRepositorySession().getWorkspace().getQueryManager();
            for (String lang : langs = qMgr.getSupportedQueryLanguages()) {
                qgs.addQueryLanguage(lang, Namespace.EMPTY_NAMESPACE);
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return qgs;
    }

    public MultiStatus search(SearchInfo sInfo) throws DavException {
        try {
            Query q = this.getQuery(sInfo);
            QueryResult qR = q.execute();
            boolean d1 = false;
            boolean dx = false;
            QueryResult qR2 = null;
            DavPropertyNameSet searchProps = new DavPropertyNameSet();
            int searchType = 1;
            if (sInfo.getLanguageName().equals("basicsearch")) {
                String query2 = sInfo.getQuery();
                try {
                    Document requestDocument = DomUtil.parseDocument((InputStream)new ByteArrayInputStream(query2.getBytes("UTF8")));
                    searchProps = new DavPropertyNameSet();
                    Element root = requestDocument.getDocumentElement();
                    Element select = DomUtil.getChildElement((org.w3c.dom.Node)root, (String)"select", (Namespace)DavConstants.NAMESPACE);
                    ElementIterator it = DomUtil.getChildren((Element)select);
                    while (it.hasNext()) {
                        Element child = it.nextElement();
                        String nodeName = child.getLocalName();
                        if ("prop".equals(nodeName)) {
                            searchType = 0;
                            searchProps = new DavPropertyNameSet(child);
                        } else {
                            if (!"allprop".equals(nodeName)) continue;
                            searchType = 1;
                        }
                        break;
                    }
                }
                catch (ParserConfigurationException e) {
                    throw new DavException(400, (Throwable)e);
                }
                catch (SAXException e) {
                    throw new DavException(400, (Throwable)e);
                }
                catch (IOException e) {
                    throw new DavException(400, (Throwable)e);
                }
                d1 = query2.indexOf("depth>1</") != -1;
                boolean bl = dx = query2.indexOf("depth>infinity</") != -1;
                if (d1 || dx) {
                    if (dx) {
                        query2 = query2.replace("depth>infinity</", "depth>0</");
                    } else if (d1) {
                        query2 = query2.replace("depth>1</", "depth>0</");
                    }
                    SearchInfo sInfo2 = new SearchInfo(sInfo.getLanguageName(), sInfo.getLanguageNameSpace(), query2, sInfo.getNamespaces());
                    Query q2 = this.getQuery(sInfo2);
                    qR2 = q2.execute();
                }
            }
            MultiStatus ms = this.queryResultToMultiStatus(qR, searchType, searchProps);
            if (d1 || dx) {
                NodeIterator nodeIter = qR2.getNodes();
                while (nodeIter.hasNext()) {
                    Node node = nodeIter.nextNode();
                    try {
                        DavResourceLocator loc = this.getLocator().getFactory().createResourceLocator(this.getLocator().getPrefix(), this.getLocator().getWorkspacePath(), node.getPath(), false);
                        DavResource resource = this.getFactory().createResource(loc, this.getSession());
                        ms.addResourceProperties(resource, searchProps, searchType, 0);
                    }
                    catch (DavException davException) {}
                }
            }
            return ms;
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    private Session getRepositorySession() {
        return ((JcrDavSession)this.getSession()).getRepositorySession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query getQuery(SearchInfo sInfo) throws InvalidQueryException, RepositoryException, DavException {
        Query q;
        Node qNode;
        String qNodeRelPath;
        Session session = this.getRepositorySession();
        NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
        Node rootNode = session.getRootNode();
        QueryManager qMgr = session.getWorkspace().getQueryManager();
        String itemPath = this.getLocator().getRepositoryPath();
        if (itemPath != null && !rootNode.getPath().equals(itemPath) && rootNode.hasNode(qNodeRelPath = itemPath.substring(1)) && (qNode = rootNode.getNode(qNodeRelPath)).isNodeType("nt:query")) {
            return qMgr.getQuery(qNode);
        }
        if (sInfo != null) {
            Map namespaces = sInfo.getNamespaces();
            try {
                for (String prefix : namespaces.keySet()) {
                    String uri = (String)namespaces.get(prefix);
                    session.setNamespacePrefix(prefix, uri);
                }
                if ("basicsearch".equals(sInfo.getLanguageName())) {
                    q = qMgr.createQuery(Dasl2JCRXPath.doConvert(sInfo.getQuery(), session, this.getLocator()), "xpath");
                }
                q = qMgr.createQuery(sInfo.getQuery(), sInfo.getLanguageName());
            }
            finally {
                for (String uri : namespaces.values()) {
                    try {
                        session.setNamespacePrefix(nsReg.getPrefix(uri), uri);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to reset mapping of namespace: " + uri);
                    }
                }
            }
        } else {
            throw new DavException(400, this.getLocator().getResourcePath() + " is not a nt:query node -> searchRequest body required.");
        }
        if (itemPath != null && !this.getRepositorySession().itemExists(itemPath)) {
            try {
                q.storeAsNode(itemPath);
            }
            catch (RepositoryException e) {
                new JcrDavException(e);
            }
        }
        return q;
    }

    private MultiStatus queryResultToMultiStatus(QueryResult qResult, int searchType, DavPropertyNameSet searchProps) throws RepositoryException {
        MultiStatus ms = new MultiStatus();
        NodeIterator nodeIter = qResult.getNodes();
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            if (node.isNodeType("rep:ACL")) continue;
            try {
                if ("jcr:content".equals(node.getName())) {
                    node = node.getParent();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            try {
                DavResourceLocator loc = this.getLocator().getFactory().createResourceLocator(this.getLocator().getPrefix(), this.getLocator().getWorkspacePath(), node.getPath(), false);
                DavResource resource = this.getFactory().createResource(loc, this.getSession());
                ms.addResourceProperties(resource, searchProps, searchType, 0);
            }
            catch (DavException davException) {}
        }
        return ms;
    }

    private boolean checkoutPreConditions(Node node) throws RepositoryException {
        if (!this.config.isCollectionResource((Item)node) && node.isNodeType("mix:versionable") && !node.isCheckedOut()) {
            String autoVersion = this.getAutoVersion(node);
            VersionManager vMan = node.getSession().getWorkspace().getVersionManager();
            if ("checkout".equals(autoVersion)) {
                vMan.checkout(node.getPath());
                return true;
            }
            if ("checkout-checkin".equals(autoVersion)) {
                vMan.checkout(node.getPath());
                return true;
            }
            if ("checkout-unlocked-checkin".equals(autoVersion)) {
                vMan.checkout(node.getPath());
                return true;
            }
            if ("locked-checkout".equals(autoVersion) && this.hasLock(Type.WRITE, Scope.EXCLUSIVE)) {
                vMan.checkout(node.getPath());
                return true;
            }
        }
        return false;
    }

    private void checkinPostConditions(DavResource member, Node node) throws RepositoryException {
        if (!this.config.isCollectionResource((Item)node) && node.isNodeType("mix:versionable") && node.isCheckedOut()) {
            boolean bypassAutoVersion = false;
            Node contentNode = this.getContentNode(node);
            if (contentNode != null && contentNode.hasProperty("SASDAV:bypass-auto-version")) {
                bypassAutoVersion = contentNode.getProperty("SASDAV:bypass-auto-version").getBoolean();
            }
            if (!bypassAutoVersion) {
                String autoVersion = this.getAutoVersion(node);
                VersionManager vMan = node.getSession().getWorkspace().getVersionManager();
                if ("checkout-checkin".equals(autoVersion)) {
                    vMan.checkin(node.getPath());
                } else if ("checkout-unlocked-checkin".equals(autoVersion) && !member.hasLock(Type.WRITE, Scope.EXCLUSIVE)) {
                    vMan.checkin(node.getPath());
                }
            }
        }
    }

    private String getAutoVersion(Node node) throws RepositoryException {
        String autoVersion = null;
        try {
            Property av = node.getProperty("jcr:auto-version");
            if (av != null) {
                autoVersion = av.getString();
            }
        }
        catch (PathNotFoundException e) {
            try {
                Property av;
                Node contentNode = this.getContentNode(node);
                if (contentNode != null && (av = contentNode.getProperty("jcr:autoVersion")) != null) {
                    autoVersion = av.getString();
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        return autoVersion;
    }

    protected Node getContentNode(Node node) throws RepositoryException {
        Node contentNode = null;
        if (node.hasNode("jcr:content")) {
            contentNode = node.getNode("jcr:content");
        }
        return contentNode;
    }

    public void setProperty(DavProperty<?> property) throws DavException {
        super.setProperty(property);
        try {
            this.checkinPostConditions((DavResource)this, super.getNode());
        }
        catch (RepositoryException e) {
            throw new DavException(500, e.getMessage());
        }
    }

    public void addVersionControl() throws DavException {
        super.addVersionControl();
        try {
            this.getNode().addMixin("auto-version");
            this.getNode().setProperty("jcr:auto-version", "checkout-unlocked-checkin");
            this.getNode().getSession().save();
            this.getNode().getSession().getWorkspace().getVersionManager().checkin(this.getNode().getPath());
        }
        catch (RepositoryException e) {
            log.info("failed to add version control", (Throwable)e);
            throw new DavException(500, e.getMessage());
        }
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        super.removeProperty(propertyName);
        try {
            this.checkinPostConditions((DavResource)this, super.getNode());
        }
        catch (RepositoryException e) {
            throw new DavException(500, e.getMessage());
        }
    }

    public void uncheckout() throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (!this.isVersionControlled()) {
            throw new DavException(412);
        }
        try {
            if (!this.getNode().isCheckedOut()) {
                throw new DavException(412);
            }
            VersionManager vMgr = this.getNode().getSession().getWorkspace().getVersionManager();
            vMgr.restore(vMgr.getBaseVersion(this.getNode().getPath()), true);
        }
        catch (UnsupportedRepositoryOperationException e) {
            log.info("failed to uncheckout", (Throwable)e);
            throw new DavException(500, e.getMessage());
        }
        catch (RepositoryException e) {
            log.info("failed to uncheckout", (Throwable)e);
            throw new DavException(500, e.getMessage());
        }
    }

    protected PropertyExportContext getPropertyExportContext() {
        return new SASPropertyExportCtx();
    }

    protected PropertyImportContext getPropertyImportContext(List<? extends PropEntry> changeList) {
        return new SASPropertyImportCtx(changeList);
    }

    public void checkout() throws DavException {
        try {
            AccessControlManager acMan = ((SessionImpl)this.getNode().getSession()).getAccessControlManager();
            if (!acMan.hasPrivileges(this.getNode().getPath(), new Privilege[]{acMan.privilegeFromName("{http://www.jcp.org/jcr/1.0}versionManagement")})) {
                throw new DavException(403);
            }
            if (!this.getNode().isNodeType("mix:versionable")) {
                throw new DavException(412);
            }
            if (this.getNode().isCheckedOut()) {
                throw new DavException(412);
            }
            ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
            if (lock != null) {
                throw new DavException(423);
            }
            super.checkout();
            if (this.getAutoVersion(this.getNode()) != null) {
                this.getContentNode(this.getNode()).setProperty("SASDAV:bypass-auto-version", true);
                this.getNode().getSession().save();
            }
        }
        catch (RepositoryException e) {
            log.info("failed to checkout", (Throwable)e);
            throw new DavException(500, e.getMessage());
        }
    }

    public String checkin() throws DavException {
        boolean resetBypass = false;
        try {
            if (this.getContentNode(this.getNode()).hasProperty("SASDAV:bypass-auto-version")) {
                this.getContentNode(this.getNode()).getProperty("SASDAV:bypass-auto-version").remove();
                this.getNode().getSession().save();
                resetBypass = true;
            }
        }
        catch (RepositoryException e) {
            throw new DavException(500, "failed to update auto-version status");
        }
        try {
            return super.checkin();
        }
        catch (DavException e) {
            if (resetBypass) {
                try {
                    if (this.getAutoVersion(this.getNode()) != null) {
                        this.getContentNode(this.getNode()).setProperty("SASDAV:bypass-auto-version", true);
                        this.getNode().getSession().save();
                    }
                }
                catch (RepositoryException re) {
                    throw new DavException(500, "failed to update auto-version status");
                }
            }
            throw e;
        }
    }

    public void unlock(String lockToken) throws DavException {
        ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        try {
            if (lock == null) {
                throw new DavException(412);
            }
            AccessControlManager acMan = ((SessionImpl)this.getNode().getSession()).getAccessControlManager();
            if (!acMan.hasPrivileges(this.getNode().getPath(), new Privilege[]{acMan.privilegeFromName("{http://www.jcp.org/jcr/1.0}lockManagement")})) {
                throw new DavException(403);
            }
            boolean isLockOwner = false;
            isLockOwner = this.getNode().isLocked() ? SASLockManagerImpl.isLockOwner(this.getNode().getIdentifier().toString(), (SessionImpl)this.getNode().getSession()) : true;
            if (!((SessionImpl)this.getNode().getSession()).isAdmin() && !isLockOwner) {
                throw new DavException(423);
            }
            super.unlock(lockToken);
            try {
                this.checkinPostConditions((DavResource)this, this.getNode());
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        }
        catch (RepositoryException e) {
            log.info("failed to unlock", (Throwable)e);
            throw new DavException(500, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (this.isLocked(destination)) {
            throw new DavException(423);
        }
        if (this.isFilteredResource(destination)) {
            throw new DavException(403);
        }
        this.checkSameWorkspace(destination.getLocator());
        SASSessionImpl session = null;
        try {
            session = (SASSessionImpl)this.getJcrSession();
            session.doAdmin();
            if (!this.config.getCopyMoveManager().copy((CopyMoveContext)new CopyMoveContextImpl((Session)session, shallow), (DavResource)this, destination)) {
                throw new DavException(415);
            }
        }
        finally {
            session.endAdmin();
        }
    }

    protected boolean isJcrLockable() {
        try {
            if (this.getNode().getSession().getUserID() == null) {
                return false;
            }
        }
        catch (RepositoryException e) {
            return false;
        }
        return super.isJcrLockable();
    }

    public class SASPropertyExportCtx
    extends DavResourceImpl.PropertyExportCtx {
        SASPropertyExportCtx() {
            super((DavResourceImpl)AclResourceImpl.this);
        }

        public DavResource getDavResource() {
            return AclResourceImpl.this;
        }

        public DavPropertySet getProperties() {
            return AclResourceImpl.this.properties;
        }
    }

    public class SASPropertyImportCtx
    extends DavResourceImpl.PropertyImportCtx {
        SASPropertyImportCtx(List<? extends PropEntry> changeList) {
            super((DavResourceImpl)AclResourceImpl.this, changeList);
        }

        public DavResource getDavResource() {
            return AclResourceImpl.this;
        }
    }
}

