/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.util;

import com.sas.contentserver.core.jndi.SASRegistryHelper;
import com.sas.contentserver.webdav.SASDomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CopyMoveDelete {
    private static List<Operation> ops = new ArrayList<Operation>();
    private static Logger log = LoggerFactory.getLogger(CopyMoveDelete.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        reposHome = null;
        user = null;
        pwd = null;
        aclRulesFile = null;
        aclOutputFile = null;
        overwrite = false;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-rh")) {
                reposHome = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-pwd")) {
                pwd = args[++i];
                continue;
            }
            if (args[i].equals("-move")) {
                src = args[++i];
                dest = args[++i];
                CopyMoveDelete.ops.add(new Operation(2, src, dest));
                continue;
            }
            if (args[i].equals("-copy")) {
                src = args[++i];
                dest = args[++i];
                CopyMoveDelete.ops.add(new Operation(1, src, dest));
                continue;
            }
            if (args[i].equals("-delete")) {
                src = args[++i];
                CopyMoveDelete.ops.add(new Operation(3, src));
                continue;
            }
            if (args[i].equals("-aclRules")) {
                aclRulesFile = args[++i];
                continue;
            }
            if (args[i].equals("-aclOutput")) {
                aclOutputFile = args[++i];
                continue;
            }
            if (!args[i].equals("-overwrite")) continue;
            overwrite = args[++i].equals("true");
        }
        if (reposHome == null || user == null || pwd == null) {
            CopyMoveDelete.log.error("Missing parameter values");
            System.exit(8);
        }
        SASRegistryHelper.registerJNDIDataSources();
        reposFile = new File(reposHome);
        if (!reposFile.exists()) {
            CopyMoveDelete.log.error("Repository home '" + reposHome + "' does not exist");
            System.exit(8);
        }
        configFile = new File(reposHome, "repository.xml").getAbsolutePath();
        env = new Hashtable<String, String>();
        env.put("java.naming.factory.url.pkgs", "org.apache.jackrabbit.core.jndi.provider:javax.naming.spi");
        env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
        env.put("java.naming.provider.url", "localhost");
        newNodes = new ArrayList<String>();
        try {
            block45: {
                ctx = new InitialContext(env);
                SASRegistryHelper.registerRepository(ctx, "repo", configFile, reposHome, true);
                repository = (Repository)ctx.lookup("repo");
                session = repository.login((Credentials)new SimpleCredentials(user, pwd.toCharArray()), null);
                for (Operation op : CopyMoveDelete.ops) {
                    switch (op.command) {
                        case 2: {
                            if (!session.nodeExists(op.src)) break;
                            try {
                                session.getWorkspace().move(op.src, op.dest);
                            }
                            catch (ItemExistsException e) {
                                if (!overwrite) ** GOTO lbl77
                                session.removeItem(op.dest);
                                session.save();
                                session.getWorkspace().move(op.src, op.dest);
                            }
lbl77:
                            // 3 sources

                            CopyMoveDelete.log.info(op.src + " moved to " + op.dest);
                            newNodes.add(op.dest);
                            break;
                        }
                        case 1: {
                            if (!session.nodeExists(op.src)) break;
                            try {
                                session.getWorkspace().copy(op.src, op.dest);
                            }
                            catch (ItemExistsException e) {
                                if (!overwrite) ** GOTO lbl91
                                session.removeItem(op.dest);
                                session.save();
                                session.getWorkspace().copy(op.src, op.dest);
                            }
lbl91:
                            // 3 sources

                            CopyMoveDelete.log.info(op.src + " copied to " + op.dest);
                            newNodes.add(op.dest);
                            break;
                        }
                        case 3: {
                            if (!session.nodeExists(op.src)) break;
                            session.removeItem(op.src);
                            session.save();
                            CopyMoveDelete.log.info(op.src + " deleted");
                            break;
                        }
                    }
                }
                if (aclOutputFile == null) break block45;
                session.refresh(false);
                doc = null;
                if (aclRulesFile != null) {
                    is = null;
                    try {
                        is = new FileInputStream(aclRulesFile);
                        doc = SASDomUtil.parseDocument((InputStream)is);
                        root = doc.getDocumentElement();
                        rules = root.getElementsByTagName("rule");
                        for (i = 0; i < rules.getLength(); ++i) {
                            rule = (Element)rules.item(i);
                            pattern = rule.getAttribute("pattern");
                            if (pattern.endsWith("*")) {
                                parent = pattern.substring(0, pattern.length() - 1);
                                parentNode = session.getNode(parent);
                                iter = parentNode.getNodes();
                                while (iter.hasNext()) {
                                    child = iter.nextNode();
                                    if (!newNodes.contains(child.getPath())) continue;
                                    newNodes.remove(child.getPath());
                                }
                                continue;
                            }
                            node = session.getNode(pattern);
                            if (!newNodes.contains(node.getPath())) continue;
                            newNodes.remove(node.getPath());
                        }
                    }
                    catch (Throwable var27_39) {
                        IOUtils.closeQuietly(is);
                        throw var27_39;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
                outDoc = SASDomUtil.createDocument();
                outRoot = outDoc.createElement("acls");
                outAcls = new ArrayList<Element>();
                if (aclRulesFile != null) {
                    is = null;
                    try {
                        is = new FileInputStream(aclRulesFile);
                        doc = SASDomUtil.parseDocument((InputStream)is);
                        root = doc.getDocumentElement();
                        rules = root.getElementsByTagName("rule");
                        for (i = 0; i < rules.getLength(); ++i) {
                            rule = (Element)rules.item(i);
                            pattern = rule.getAttribute("pattern");
                            if (pattern.endsWith("*")) {
                                parent = pattern.substring(0, pattern.length() - 1);
                                CopyMoveDelete.log.debug("Pattern ends with *. Building acl for all children of " + parent);
                                parentNode = session.getNode(parent);
                                iter = parentNode.getNodes();
                                while (iter.hasNext()) {
                                    child = iter.nextNode();
                                    acl = CopyMoveDelete.createAcl(child, outDoc, rule);
                                    if (acl == null) continue;
                                    outAcls.add(acl);
                                }
                                continue;
                            }
                            node = session.getNode(pattern);
                            acl = CopyMoveDelete.createAcl(node, outDoc, rule);
                            if (acl == null) continue;
                            outAcls.add(acl);
                        }
                    }
                    catch (Throwable var31_44) {
                        IOUtils.closeQuietly(is);
                        throw var31_44;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
                if (!newNodes.isEmpty()) {
                    CopyMoveDelete.log.debug("New nodes remain which rules are not defined for. Creating default ACLs...");
                    for (String path : newNodes) {
                        defaultAcls = CopyMoveDelete.createDefaultAcls(session, path, user, outDoc);
                        outAcls.addAll(defaultAcls);
                    }
                }
                Collections.sort(outAcls, new Comparator<Element>(){

                    @Override
                    public int compare(Element e1, Element e2) {
                        String path1 = e1.getAttribute("path");
                        String path2 = e2.getAttribute("path");
                        return path1.length() - path2.length();
                    }
                });
                for (Element acl : outAcls) {
                    outRoot.appendChild(acl);
                }
                outDoc.appendChild(outRoot);
                out = null;
                try {
                    out = new FileOutputStream(aclOutputFile);
                    transformerFactory = TransformerFactory.newInstance();
                    transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.transform(new DOMSource(outDoc), new StreamResult(out));
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            session.logout();
        }
        catch (NamingException e) {
            CopyMoveDelete.log.error("NamingException", (Throwable)e);
            e.printStackTrace();
            System.exit(8);
        }
        catch (RepositoryException e) {
            CopyMoveDelete.log.error("RepositoryException", (Throwable)e);
            e.printStackTrace();
            System.exit(8);
        }
        catch (IOException e) {
            CopyMoveDelete.log.error("IOException", (Throwable)e);
            e.printStackTrace();
            System.exit(8);
        }
        catch (Exception e) {
            CopyMoveDelete.log.error("Exception", (Throwable)e);
            e.printStackTrace();
            System.exit(8);
        }
        System.exit(0);
    }

    private static boolean includeNode(Node node, Boolean includeFolders, Boolean includeFiles) throws RepositoryException {
        if (includeFolders.booleanValue() && node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}folder")) {
            log.debug("includeFolders is true and " + node.getPath() + "is of type nt:folder");
            return true;
        }
        if (includeFiles.booleanValue() && node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file")) {
            log.debug("includeFiles is true and " + node.getPath() + "is of type nt:file");
            return true;
        }
        log.debug("not including node " + node.getPath());
        return false;
    }

    private static Element createAcl(Node node, Document doc, Element rule) throws RepositoryException {
        log.debug("Creating acl for " + node.getPath());
        Boolean includeFolders = Boolean.parseBoolean(rule.getAttribute("includeFolders"));
        Boolean includeFiles = Boolean.parseBoolean(rule.getAttribute("includeFiles"));
        String owner = ((Element)rule.getElementsByTagName("owner").item(0)).getAttribute("name");
        String inheriting = ((Element)rule.getElementsByTagName("inheriting").item(0)).getAttribute("value");
        String parentPath = ((Element)rule.getElementsByTagName("parentPath").item(0)).getAttribute("name");
        Element ret = null;
        if (CopyMoveDelete.includeNode(node, includeFolders, includeFiles)) {
            ret = doc.createElement("acl");
            ret.setAttribute("path", node.getPath());
            ret.setAttribute("owner", owner);
            ret.setAttribute("inheriting", inheriting);
            ret.setAttribute("parentPath", parentPath);
            NodeList aces = rule.getElementsByTagName("ace");
            for (int i = 0; i < aces.getLength(); ++i) {
                Element ace = (Element)aces.item(i);
                Element newAce = doc.createElement("ace");
                newAce.setAttribute("principal", ace.getAttribute("principal"));
                newAce.setAttribute("principalType", ace.getAttribute("principalType"));
                newAce.setAttribute("permission", ace.getAttribute("permission"));
                newAce.setAttribute("granting", ace.getAttribute("granting"));
                ret.appendChild(newAce);
            }
        }
        return ret;
    }

    private static List<Element> createDefaultAcls(Session session, String path, String user, Document doc) throws PathNotFoundException, RepositoryException {
        Node destNode = session.getRootNode().getNode(path.substring(1));
        NodeIterator children = destNode.getNodes();
        ArrayList<Element> ret = new ArrayList<Element>();
        while (children.hasNext()) {
            Node child = children.nextNode();
            log.debug("Adding default acl to output file: " + child.getPath());
            Element childAcl = doc.createElement("acl");
            childAcl.setAttribute("path", child.getPath());
            childAcl.setAttribute("owner", user);
            childAcl.setAttribute("inheriting", "true");
            childAcl.setAttribute("parentPath", child.getParent().getPath());
            ret.add(childAcl);
        }
        return ret;
    }

    static class Operation {
        static final int COPY = 1;
        static final int MOVE = 2;
        static final int DELETE = 3;
        int command;
        String src;
        String dest;

        public Operation(int command, String src, String dest) {
            this.command = command;
            this.src = src;
            this.dest = dest;
        }

        public Operation(int command, String src) {
            this.command = command;
            this.src = src;
            this.dest = null;
        }
    }
}

