/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.springextensions.jcr;

import com.sas.contentserver.springextensions.jcr.JcrSessionFactory;
import com.sas.contentserver.springextensions.jcr.JcrUtils;
import com.sas.contentserver.springextensions.jcr.SessionFactory;
import com.sas.contentserver.springextensions.jcr.SessionFactoryUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class TransactionAwareRepository
implements InitializingBean,
FactoryBean {
    private JcrSessionFactory sessionFactory;
    private Repository proxy;
    private boolean allowCreate = true;
    private boolean allowNonTxRepository = false;

    public Object getObject() throws Exception {
        return this.proxy;
    }

    public Class getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
        if (!this.allowNonTxRepository && !JcrUtils.supportsTransactions(this.sessionFactory.getRepository())) {
            throw new IllegalArgumentException(this.sessionFactory.toString() + " does NOT support transactions and allowNonTxRepository is false");
        }
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowNonTxRepository() {
        return this.allowNonTxRepository;
    }

    public void setAllowNonTxRepository(boolean allowNonTxRepository) {
        this.allowNonTxRepository = allowNonTxRepository;
    }

    public void setTargetFactory(JcrSessionFactory target) {
        this.sessionFactory = target;
        this.proxy = (Repository)Proxy.newProxyInstance(Repository.class.getClassLoader(), new Class[]{Repository.class}, (InvocationHandler)new TransactionAwareRepositoryInvocationHandler());
    }

    public Repository getTargetRepository() {
        return this.sessionFactory.getRepository();
    }

    private class TransactionAwareRepositoryInvocationHandler
    implements InvocationHandler {
        private TransactionAwareRepositoryInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("login")) {
                boolean matched = false;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length == 0) {
                    matched = TransactionAwareRepository.this.sessionFactory.getWorkspaceName() == null && TransactionAwareRepository.this.sessionFactory.getCredentials() == null;
                } else if (paramTypes.length == 1) {
                    if (paramTypes[0] == String.class) {
                        matched = ObjectUtils.nullSafeEquals((Object)args[0], (Object)TransactionAwareRepository.this.sessionFactory.getWorkspaceName());
                    }
                    if (Credentials.class.isAssignableFrom(paramTypes[0])) {
                        matched = ObjectUtils.nullSafeEquals((Object)args[0], (Object)TransactionAwareRepository.this.sessionFactory.getCredentials());
                    }
                } else if (paramTypes.length == 2) {
                    boolean bl = matched = ObjectUtils.nullSafeEquals((Object)args[0], (Object)TransactionAwareRepository.this.sessionFactory.getCredentials()) && ObjectUtils.nullSafeEquals((Object)args[1], (Object)TransactionAwareRepository.this.sessionFactory.getWorkspaceName());
                }
                if (matched) {
                    Session session = SessionFactoryUtils.getSession(TransactionAwareRepository.this.sessionFactory, TransactionAwareRepository.this.isAllowCreate());
                    Class[] ifcs = ClassUtils.getAllInterfaces((Object)session);
                    return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), ifcs, (InvocationHandler)new TransactionAwareInvocationHandler(session, TransactionAwareRepository.this.sessionFactory));
                }
            } else {
                if (method.getName().equals("equals")) {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                if (method.getName().equals("hashCode")) {
                    return this.hashCode();
                }
            }
            Repository target = TransactionAwareRepository.this.getTargetRepository();
            try {
                return method.invoke((Object)target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final Session target;
        private final SessionFactory sessionFactory;

        public TransactionAwareInvocationHandler(Session target, SessionFactory sessionFactory) {
            this.target = target;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("logout")) {
                if (this.sessionFactory != null) {
                    SessionFactoryUtils.releaseSession(this.target, this.sessionFactory);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

