/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.security.SASPrivilegeRegistry;
import com.sas.framework.commons.holders.TenantHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.core.cluster.PrivilegeEventChannel;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.PrivilegeDefinition;

public class TenantPrivilegeRegistry
extends SASPrivilegeRegistry {
    private NamespaceRegistry namespaceRegistry;
    private FileSystem fs;
    private PrivilegeEventChannel eventChannel = null;
    private Map<Integer, PrivilegeRegistry> tenantRegistries;

    public TenantPrivilegeRegistry(NamespaceRegistry namespaceRegistry, FileSystem fs) throws RepositoryException {
        super(namespaceRegistry, fs);
        this.namespaceRegistry = namespaceRegistry;
        this.fs = fs;
        this.tenantRegistries = new HashMap<Integer, PrivilegeRegistry>();
        this.tenantRegistries.put(TenantHolder.get().getId(), this);
    }

    private PrivilegeRegistry getTenantRegistry() {
        PrivilegeRegistry ret = this.tenantRegistries.get(TenantHolder.get().getId());
        if (ret == null) {
            try {
                ret = new SASPrivilegeRegistry(this.namespaceRegistry, this.fs);
                if (this.eventChannel != null) {
                    ret.setEventChannel(this.eventChannel);
                }
                this.tenantRegistries.put(TenantHolder.get().getId(), ret);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return ret;
    }

    public void externalRegisteredPrivileges(Collection<PrivilegeDefinition> definitions) throws RepositoryException {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            super.externalRegisteredPrivileges(definitions);
        } else {
            pr.externalRegisteredPrivileges(definitions);
        }
    }

    public void setEventChannel(PrivilegeEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            super.setEventChannel(eventChannel);
        } else {
            pr.setEventChannel(eventChannel);
        }
    }

    public Privilege[] getRegisteredPrivileges() {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getRegisteredPrivileges();
        }
        return pr.getRegisteredPrivileges();
    }

    public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getPrivilege(privilegeName);
        }
        return pr.getPrivilege(privilegeName);
    }

    public Privilege[] getPrivileges(int bits) {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getPrivileges(bits);
        }
        return pr.getPrivileges(bits);
    }

    public void registerDefinition(Name privilegeName, boolean isAbstract, Set<Name> declaredAggregateNames) throws RepositoryException {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            super.registerDefinition(privilegeName, isAbstract, declaredAggregateNames);
        } else {
            pr.registerDefinition(privilegeName, isAbstract, declaredAggregateNames);
        }
    }

    public PrivilegeDefinition[] getAll() {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getAll();
        }
        return pr.getAll();
    }

    public PrivilegeDefinition get(Name name) {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.get(name);
        }
        return pr.get(name);
    }

    @Override
    public Name[] getNames(PrivilegeBits privilegeBits) {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getNames(privilegeBits);
        }
        return pr.getNames(privilegeBits);
    }

    public PrivilegeBits getBits(PrivilegeDefinition ... definitions) {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getBits(definitions);
        }
        return pr.getBits(definitions);
    }

    public PrivilegeBits getBits(Name ... privilegeNames) {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getBits(privilegeNames);
        }
        return pr.getBits(privilegeNames);
    }

    public PrivilegeBits getBits(Name privilegeName) {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            return super.getBits(privilegeName);
        }
        return pr.getBits(privilegeName);
    }

    public void addListener(PrivilegeRegistry.Listener listener) {
        PrivilegeRegistry pr = this.getTenantRegistry();
        if (pr instanceof TenantPrivilegeRegistry) {
            super.addListener(listener);
        } else {
            pr.addListener(listener);
        }
    }
}

