/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.commons.SASJcrConstants;
import com.sas.contentserver.core.SASItemManager;
import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.core.session.SASSessionImpl;
import com.sas.contentserver.security.SASACLProvider;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.DefaultAccessManager;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASDefaultAccessManager
extends DefaultAccessManager {
    static final Logger log = LoggerFactory.getLogger(SASDefaultAccessManager.class);
    private AccessControlProvider acProvider;
    private AMContext amContext;
    private Privilege ADD_CHILD_NODES;

    public void init(AMContext amContext, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager) throws AccessDeniedException, Exception {
        this.acProvider = acProvider;
        this.amContext = amContext;
        if (!amContext.getSubject().isReadOnly()) {
            Set<Principal> principals = amContext.getSubject().getPrincipals();
            principals.add((Principal)EveryonePrincipal.getInstance());
            boolean isSystemOrAdmin = this.isSystemOrAdmin(amContext.getSubject());
            if (isSystemOrAdmin) {
                principals.add((Principal)new AdminPrincipal("admin"));
                log.debug("adding admin principal");
            }
            principals = ((SASACLProvider)acProvider).convertToJCRPrincipals(principals);
            amContext.getSubject().getPrincipals().clear();
            for (Principal principal : principals) {
                amContext.getSubject().getPrincipals().add(principal);
            }
        }
        super.init(amContext, acProvider, wspAccessManager);
        this.ADD_CHILD_NODES = this.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Principal, List<Privilege>> getAllPrincipalPrivileges(String path, Session session) throws AccessDeniedException, RepositoryException {
        HashMap<Principal, List<Privilege>> ret = new HashMap<Principal, List<Privilege>>();
        try {
            ((SASSessionImpl)session).doAdmin();
            SASDefaultAccessManager acMan = (SASDefaultAccessManager)session.getAccessControlManager();
            Iterator auths = ((SessionImpl)session).getUserManager().findAuthorizables(new Query(){

                public void build(QueryBuilder builder) {
                    builder.setCondition(builder.nameMatches("%"));
                }
            });
            while (auths.hasNext()) {
                Authorizable auth = (Authorizable)auths.next();
                HashSet<Principal> principals = new HashSet<Principal>();
                principals.add(auth.getPrincipal());
                Privilege[] privs = acMan.getPrivileges(path, principals);
                if (privs.length <= 0) continue;
                ret.put(auth.getPrincipal(), Arrays.asList(privs));
            }
            HashMap<Principal, List<Privilege>> hashMap = ret;
            return hashMap;
        }
        finally {
            ((SASSessionImpl)session).endAdmin();
        }
    }

    public static Ace getAccessControlEntry(Node node, String id) throws RepositoryException {
        SASDefaultAccessManager acMgr = (SASDefaultAccessManager)node.getSession().getAccessControlManager();
        HashSet<UserPrincipal> s = new HashSet<UserPrincipal>(Arrays.asList(new UserPrincipal(id)));
        Privilege[] privs = acMgr.getPrivileges(node.getPath(), s);
        return new Ace(id, privs);
    }

    private static Privilege[] resolvePrivileges(Privilege[] origPrivileges, List<Privilege> addList, List<Privilege> removeList) {
        ArrayList<Privilege> result = new ArrayList<Privilege>(Arrays.asList(origPrivileges));
        for (Privilege p : addList) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        for (Privilege p : removeList) {
            if (!result.contains(p)) continue;
            result.remove(p);
        }
        return result.toArray(new Privilege[0]);
    }

    private void setACL(Node node, String principal, Boolean[] permissions) throws RepositoryException {
        SASDefaultAccessManager acMgr = (SASDefaultAccessManager)node.getSession().getAccessControlManager();
        ArrayList<Privilege> privList = new ArrayList<Privilege>();
        for (int i = 0; i < permissions.length; ++i) {
            if (!permissions[i].booleanValue()) continue;
            privList.add(acMgr.privilegeFromName(Ace.Privileges.values()[i].Name()));
        }
        this.setSASPermissions((Principal)new UserPrincipal(principal), node, privList);
    }

    public void setAccessControlEntry(Node node, String principal, Boolean[] permissions, boolean deep) throws RepositoryException {
        this.setACL(node, principal, permissions);
        if (deep && node.isNodeType("nt:davcollection")) {
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                Node _node = nodes.nextNode();
                if (_node.isNodeType("nt:davcollection")) {
                    this.setAccessControlEntry(_node, principal, permissions, deep);
                    continue;
                }
                Boolean[] filePermissions = new Boolean[permissions.length];
                System.arraycopy(permissions, 0, filePermissions, 0, permissions.length);
                filePermissions[4] = Boolean.FALSE;
                filePermissions[5] = Boolean.FALSE;
                filePermissions[6] = Boolean.FALSE;
                filePermissions[7] = Boolean.FALSE;
                this.setAccessControlEntry(_node, principal, filePermissions, deep);
            }
        }
    }

    static String[] getStringValues(Value[] values) throws RepositoryException {
        String[] privs = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            privs[i] = values[i].getString();
        }
        return privs;
    }

    public void grantPrivileges(Principal principal, String path, List<Privilege> privs, Map<String, Value> restrictions) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        JackrabbitAccessControlList acl = this.getAclForPath(path);
        if (restrictions != null) {
            acl.addEntry(principal, privs.toArray(new Privilege[privs.size()]), true, restrictions);
        } else {
            acl.addEntry(principal, privs.toArray(new Privilege[privs.size()]), true);
        }
        this.setPolicy(path, (AccessControlPolicy)acl);
    }

    public AccessControlProvider getAccessControlProvider() {
        return this.acProvider;
    }

    public void removeAceForPrincipal(Node node, Principal principal) throws AccessControlException, RepositoryException {
        JackrabbitAccessControlList acl = this.getAclForPath(node.getPath());
        AccessControlEntry ace = this.getAceForPrincipal((AccessControlList)acl, principal);
        if (ace != null) {
            acl.removeAccessControlEntry(ace);
            this.setPolicy(node.getPath(), (AccessControlPolicy)acl);
        }
    }

    public JackrabbitAccessControlList getAclForPath(String path) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        JackrabbitAccessControlList acl;
        block2: {
            acl = null;
            try {
                acl = (JackrabbitAccessControlList)this.getApplicablePolicies(path).nextAccessControlPolicy();
            }
            catch (NoSuchElementException e) {
                AccessControlPolicy[] acls = this.getPolicies(path);
                if (acls == null || acls.length <= 0) break block2;
                acl = (JackrabbitAccessControlList)acls[0];
            }
        }
        return acl;
    }

    private AccessControlEntry getAceForPrincipal(AccessControlList acl, Principal principal) throws AccessControlException, RepositoryException {
        for (AccessControlEntry ace : acl.getAccessControlEntries()) {
            if (!ace.getPrincipal().equals(principal)) continue;
            return ace;
        }
        return null;
    }

    public void setSASPermissions(Principal principal, Node node, List<Privilege> privs) throws AccessControlException, RepositoryException {
        HashMap<Principal, List<Privilege>> m = new HashMap<Principal, List<Privilege>>();
        m.put(principal, privs);
        this.setSASPermissions(node, m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setSASPermissions(Node node, Map<Principal, List<Privilege>> privs, boolean overwrite) throws AccessControlException, RepositoryException {
        block15: {
            this.checkPermission(node.getPath(), 64);
            session = (SASSessionImpl)node.getSession();
            try {
                session.doAdmin();
                parentPrivs = new HashMap<Principal, List<Privilege>>();
                for (Principal principal : privs.keySet()) {
                    for (Privilege priv : privs.get(principal)) {
                        if (!priv.equals((Object)this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}delete"))) continue;
                        parentPrivs.put(principal, Arrays.asList(new Privilege[]{this.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes")}));
                    }
                }
                vf = session.getValueFactory();
                restrictions = new HashMap<String, Value>();
                restrictions.put(session.getJCRName(NameConstants.REP_NODE_PATH), vf.createValue(node.getPath(), 8));
                restrictions.put(session.getJCRName(NameConstants.REP_GLOB), vf.createValue("", 1));
                try {
                    acl = (JackrabbitAccessControlList)this.getApplicablePolicies(node.getPath()).nextAccessControlPolicy();
                    ** GOTO lbl29
                }
                catch (NoSuchElementException e) {
                    acls = this.getPolicies(node.getPath());
                    if (acls == null || acls.length == 0) {
                        session.endAdmin();
                        return;
                    }
                    acl = (JackrabbitAccessControlList)acls[0];
lbl29:
                    // 2 sources

                    if (overwrite) {
                        for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                            if (ace.getPrivileges().length == 1 || Arrays.asList(ace.getPrivileges()).contains(this.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"))) continue;
                            acl.removeAccessControlEntry(ace);
                        }
                    }
                    for (Principal principal : privs.keySet()) {
                        acl.addEntry(principal, privs.get(principal).toArray(new Privilege[privs.get(principal).size()]), true, restrictions);
                    }
                    this.setPolicy(node.getPath(), (AccessControlPolicy)acl);
                    if (node.getPath().equals(session.getRootNode().getPath()) || parentPrivs.isEmpty()) break block15;
                    parent = node.getParent();
                    try {
                        parentAcl = (JackrabbitAccessControlList)this.getApplicablePolicies(parent.getPath()).nextAccessControlPolicy();
                    }
                    catch (NoSuchElementException e) {
                        parentAcl = (JackrabbitAccessControlList)this.getPolicies(parent.getPath())[0];
                    }
                    for (Map.Entry<K, V> entry : parentPrivs.entrySet()) {
                        parentAcl.addEntry((Principal)entry.getKey(), ((List)entry.getValue()).toArray(new Privilege[((List)entry.getValue()).size()]), true);
                    }
                    this.setPolicy(parent.getPath(), (AccessControlPolicy)parentAcl);
                }
            }
            finally {
                session.endAdmin();
            }
        }
    }

    public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
        SASSessionImpl session = (SASSessionImpl)this.amContext.getSession();
        if (session.isAdmin()) {
            return true;
        }
        boolean userGranted = super.canRead(itemPath, itemId);
        if (userGranted) {
            return true;
        }
        try {
            return this.ownerGranted(itemPath, itemId, 1);
        }
        catch (RepositoryException e) {
            return userGranted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        SASSessionImpl session = (SASSessionImpl)this.amContext.getSession();
        if (session.isAdmin()) {
            return true;
        }
        try {
            boolean userGranted = super.isGranted(absPath, permissions);
            if (userGranted) {
                return true;
            }
            return this.ownerGranted(absPath, null, permissions);
        }
        catch (RepositoryException userGranted) {
            try {
                int level = 1;
                boolean nodeGranted = false;
                if (session.getJCRPath(absPath).contains("jcr:content")) {
                    level = session.getJCRPath(absPath.getLastElement()).equals("jcr:content") ? 2 : 3;
                }
                ItemId id = null;
                if (level == 1) {
                    SystemSession systemSession = null;
                    id = this.amContext.getHierarchyManager().resolvePath(absPath.getAncestor(level));
                    if (id == null) {
                        systemSession = ((TenantRepositoryImpl)session.getRepository()).getSystemSession(session.getWorkspace().getName());
                        id = ((WorkspaceImpl)systemSession.getWorkspace()).getHierarchyManager().resolvePath(absPath.getAncestor(level));
                    }
                    if (id != null) {
                        ItemManager itemManager = null;
                        itemManager = systemSession != null ? systemSession.getItemManager() : session.getItemManager();
                        ItemImpl item = itemManager.getItem(id);
                        if (item.isNew()) {
                            level = 2;
                        }
                    }
                }
                if ((permissions | 0xFFFFFFFB) == -1) {
                    String path = absPath.getAncestor(level).getString().replace("\t", "/").replace("{}", "");
                    if (path.length() == 0) {
                        path = "/";
                    }
                    nodeGranted = super.isGranted(absPath, permissions - 4);
                    boolean parentGranted = this.hasPrivileges(path, new Privilege[]{this.ADD_CHILD_NODES});
                    if (nodeGranted && parentGranted) {
                        boolean item = true;
                        return item;
                    }
                    session.doAdmin();
                    boolean parentOwnerGranted = this.ownerGranted(absPath.getAncestor(level), id, 4);
                    boolean bl = nodeGranted && (parentGranted |= parentOwnerGranted);
                    return bl;
                }
                boolean parentGranted = super.isGranted(absPath.getAncestor(level), permissions);
                if (parentGranted) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = this.ownerGranted(absPath.getAncestor(level), null, permissions);
                return bl;
            }
            finally {
                session.endAdmin();
            }
        }
    }

    public boolean hasPrivileges(String path, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        boolean ret = super.hasPrivileges(path, privileges);
        if (ret) {
            return true;
        }
        SASSessionImpl session = (SASSessionImpl)this.amContext.getSession();
        Item item = session.getItem(path);
        if (item == null) {
            item = ((TenantRepositoryImpl)session.getRepository()).getSystemSession(session.getWorkspace().getName()).getItem(path);
        }
        if (item != null) {
            return this.ownerGranted(((ItemImpl)item).getPrimaryPath(), ((ItemImpl)item).getId(), PrivilegeRegistry.calculatePermissions((PrivilegeBits)((PrivilegeManagerImpl)((WorkspaceImpl)session.getWorkspace()).getPrivilegeManager()).getBits(privileges), (PrivilegeBits)PrivilegeBits.EMPTY, (boolean)true, (boolean)false));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ownerGranted(Path itemPath, ItemId itemId, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        CompiledPermissions ownerPerms = null;
        SASSessionImpl session = (SASSessionImpl)this.amContext.getSession();
        ItemId id = itemId;
        boolean ownerGranted = false;
        try {
            String primaryPath;
            session.doAdmin();
            SystemSession systemSession = null;
            if (id == null && (id = this.amContext.getHierarchyManager().resolvePath(itemPath)) == null) {
                systemSession = ((TenantRepositoryImpl)session.getRepository()).getSystemSession(session.getWorkspace().getName());
                id = ((WorkspaceImpl)systemSession.getWorkspace()).getHierarchyManager().resolvePath(itemPath);
            }
            if (id == null) {
                throw new ItemNotFoundException();
            }
            ItemManager itemManager = null;
            itemManager = systemSession == null ? session.getItemManager() : systemSession.getItemManager();
            ItemImpl item = itemManager.getItem(id);
            if (item.isNew()) {
                throw new RepositoryException();
            }
            if (!item.isNode()) {
                NodeImpl parentNode = (NodeImpl)item.getParent();
                item = itemManager.getItem(parentNode.getId());
            }
            if ((primaryPath = session.getJCRPath(item.getPrimaryPath())).contains("jcr:versionStorage")) {
                VersionHistory history = null;
                String versionId = primaryPath;
                history = item instanceof Version ? ((Version)item).getContainingHistory() : (VersionHistory)item;
                versionId = history.getVersionableIdentifier();
                boolean bl = this.ownerGranted(null, (ItemId)new NodeId(versionId), permissions);
                return bl;
            }
            if (session.getJCRPath(item.getPrimaryPath()).contains("jcr:content")) {
                if (item.isNode()) {
                    item = itemManager.getItem((ItemId)((NodeImpl)item).getParentId());
                } else {
                    NodeImpl parentNode = (NodeImpl)item.getParent();
                    item = itemManager.getItem((ItemId)parentNode.getParentId());
                }
            }
            if (itemManager.itemExists((ItemId)new PropertyId((NodeId)item.getId(), session.getQName("jcr:owner")))) {
                PropertyImpl owner = (PropertyImpl)itemManager.getItem((ItemId)new PropertyId((NodeId)item.getId(), session.getQName("jcr:owner")));
                String ownerString = owner.getString();
                if (ownerString.startsWith("person/") || ownerString.startsWith("group/")) {
                    ownerString = ownerString.substring(ownerString.indexOf(47) + 1);
                }
                if (ownerString.equals(session.getUserID())) {
                    HashSet<Principal> ownerSet = new HashSet<Principal>();
                    ownerSet.add(session.getUserManager().getAuthorizable("jcr:owner").getPrincipal());
                    ownerPerms = this.acProvider.compilePermissions(ownerSet);
                    ownerGranted = permissions == 1 ? ownerPerms.canRead(itemPath, id) : (permissions == 4 ? ownerPerms.hasPrivileges(itemPath, new Privilege[]{this.ADD_CHILD_NODES}) : ownerPerms.grants(itemPath, permissions));
                }
            }
            boolean bl = ownerGranted;
            return bl;
        }
        finally {
            if (id != null && !ownerGranted) {
                SASItemManager itemManager = (SASItemManager)session.getItemManager();
                itemManager.evictItem(id);
            }
            session.endAdmin();
            if (ownerPerms != null) {
                ownerPerms.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateSASInheritedPrivileges(Session session, Node node) throws AccessDeniedException, PathNotFoundException, ItemNotFoundException, AccessControlException, NamespaceException, ValueFormatException, RepositoryException {
        block16: {
            try {
                JackrabbitAccessControlList acl;
                JackrabbitAccessControlList parentAcl;
                String nodePath = node.getPath();
                if (nodePath.contains("rep:policy") || nodePath.contains("rep:accesscontrol") || nodePath.contains("jcr:content")) break block16;
                ((SASSessionImpl)session).doAdmin();
                SASDefaultAccessManager adminAcMan = (SASDefaultAccessManager)session.getAccessControlManager();
                try {
                    parentAcl = (JackrabbitAccessControlList)adminAcMan.getApplicablePolicies(node.getParent().getPath()).nextAccessControlPolicy();
                }
                catch (NoSuchElementException e) {
                    parentAcl = (JackrabbitAccessControlList)adminAcMan.getPolicies(node.getParent().getPath())[0];
                }
                Privilege inheritReadPrivilege = adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read");
                Privilege inheritWritePrivilege = adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-write");
                Privilege inheritDeletePrivilege = adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-delete");
                Privilege inheritAdminPrivilege = adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin");
                Privilege removeChildNodesPrivilege = adminAcMan.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes");
                HashMap<Principal, HashSet> principalPrivs = new HashMap<Principal, HashSet>();
                ArrayList<Principal> principalsWithRemoveChildNodesPrivilege = new ArrayList<Principal>();
                for (AccessControlEntry ace : parentAcl.getAccessControlEntries()) {
                    HashSet inheritPrivs = principalPrivs.containsKey(ace.getPrincipal()) ? (HashSet)principalPrivs.get(ace.getPrincipal()) : new HashSet();
                    Privilege[] privs = ace.getPrivileges();
                    for (int i = 0; i < privs.length; ++i) {
                        if (privs[i].equals((Object)inheritReadPrivilege)) {
                            inheritPrivs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read"));
                            inheritPrivs.add(inheritReadPrivilege);
                            continue;
                        }
                        if (privs[i].equals((Object)inheritWritePrivilege)) {
                            inheritPrivs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}write"));
                            inheritPrivs.add(inheritWritePrivilege);
                            continue;
                        }
                        if (privs[i].equals((Object)inheritDeletePrivilege)) {
                            inheritPrivs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}delete"));
                            inheritPrivs.add(inheritDeletePrivilege);
                            continue;
                        }
                        if (privs[i].equals((Object)inheritAdminPrivilege)) {
                            inheritPrivs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin"));
                            inheritPrivs.add(inheritAdminPrivilege);
                            continue;
                        }
                        if (!privs[i].equals((Object)removeChildNodesPrivilege)) continue;
                        principalsWithRemoveChildNodesPrivilege.add(ace.getPrincipal());
                    }
                    principalPrivs.put(ace.getPrincipal(), inheritPrivs);
                }
                if (principalPrivs.isEmpty()) break block16;
                try {
                    acl = (JackrabbitAccessControlList)adminAcMan.getApplicablePolicies(node.getPath()).nextAccessControlPolicy();
                }
                catch (NoSuchElementException e) {
                    acl = (JackrabbitAccessControlList)adminAcMan.getPolicies(node.getPath())[0];
                }
                boolean entryAdded = false;
                boolean updateParentAcl = false;
                for (Principal principal : principalPrivs.keySet()) {
                    HashSet inheritPrivs = (HashSet)principalPrivs.get(principal);
                    if (inheritPrivs.size() <= 0) continue;
                    ValueFactory vf = session.getValueFactory();
                    HashMap<String, Value> restrictions = new HashMap<String, Value>();
                    restrictions.put(((SessionImpl)session).getJCRName(NameConstants.REP_NODE_PATH), vf.createValue(node.getPath(), 8));
                    restrictions.put(((SessionImpl)session).getJCRName(NameConstants.REP_GLOB), vf.createValue("", 1));
                    acl.addEntry(principal, inheritPrivs.toArray(new Privilege[inheritPrivs.size()]), true, restrictions);
                    entryAdded = true;
                    if (!inheritPrivs.contains(inheritDeletePrivilege) || principalsWithRemoveChildNodesPrivilege.contains(principal)) continue;
                    updateParentAcl = true;
                    parentAcl.addEntry(principal, new Privilege[]{removeChildNodesPrivilege}, true);
                }
                if (entryAdded) {
                    adminAcMan.setPolicy(node.getPath(), (AccessControlPolicy)acl);
                    if (updateParentAcl) {
                        adminAcMan.setPolicy(node.getParent().getPath(), (AccessControlPolicy)parentAcl);
                    }
                    session.save();
                }
            }
            finally {
                ((SASSessionImpl)session).endAdmin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateSASInheritedPrivileges(Session session, SessionItemStateManager sism, NodeState state) throws AccessDeniedException, PathNotFoundException, ItemNotFoundException, AccessControlException, NamespaceException, ValueFormatException, RepositoryException, ItemStateException {
        block31: {
            try {
                JackrabbitAccessControlList parentAcl;
                ((SASSessionImpl)session).doAdmin();
                NodeState parentState = (NodeState)sism.getTransientItemState((ItemId)state.getParentId());
                Node parent = session.getNodeByIdentifier(parentState.getId().toString());
                ChildNodeEntry cne = parentState.getChildNodeEntry(state.getNodeId());
                String nodeName = parent.getSession().getNamespacePrefix(cne.getName().getNamespaceURI()) + ":" + cne.getName().getLocalName();
                if (nodeName.startsWith(":")) {
                    nodeName = nodeName.substring(1);
                }
                if (nodeName.contains("rep:policy") || nodeName.contains("rep:accesscontrol") || nodeName.contains("jcr:content") || parent.getName().contains("rep:policy")) break block31;
                ItemId mixinTypesId = null;
                if (state.hasPropertyName(NameConstants.JCR_MIXINTYPES)) {
                    mixinTypesId = sism.getItemState((ItemId)new PropertyId(state.getNodeId(), NameConstants.JCR_MIXINTYPES)).getId();
                }
                if (parentState.hasPropertyName(((SessionImpl)parent.getSession()).getQName("jcr:owner"))) {
                    Set mixins = state.getMixinTypeNames();
                    mixins.add(SASJcrConstants.NT_OWNER_MIXIN);
                    state.setMixinTypeNames(mixins);
                    PropertyState mixinTypes = null;
                    InternalValue[] oldValues = null;
                    if (mixinTypesId == null) {
                        mixinTypes = sism.createTransientPropertyState(state.getNodeId(), NameConstants.JCR_MIXINTYPES, 4);
                    } else {
                        mixinTypes = (PropertyState)sism.getTransientItemState(mixinTypesId);
                        oldValues = mixinTypes.getValues();
                    }
                    InternalValue[] values = null;
                    if (oldValues != null) {
                        values = new InternalValue[oldValues.length + 1];
                        values[0] = InternalValue.create((Name)SASJcrConstants.NT_OWNER_MIXIN);
                        for (int i = 0; i < oldValues.length; ++i) {
                            values[i + 1] = oldValues[i];
                        }
                    } else {
                        values = new InternalValue[]{InternalValue.create((Name)SASJcrConstants.NT_OWNER_MIXIN)};
                    }
                    mixinTypes.setType(7);
                    mixinTypes.setMultiValued(true);
                    mixinTypes.setValues(values);
                    state.addPropertyName(NameConstants.JCR_MIXINTYPES);
                    mixinTypesId = mixinTypes.getId();
                    PropertyState ownerProperty = sism.createTransientPropertyState(state.getNodeId(), SASJcrConstants.JCR_OWNER_NAME, 4);
                    ownerProperty.setType(1);
                    ownerProperty.setValues(new InternalValue[]{InternalValue.create((String)parent.getSession().getUserID())});
                    state.addPropertyName(SASJcrConstants.JCR_OWNER_NAME);
                }
                try {
                    parentAcl = (JackrabbitAccessControlList)this.getApplicablePolicies(parent.getPath()).nextAccessControlPolicy();
                }
                catch (NoSuchElementException e) {
                    parentAcl = (JackrabbitAccessControlList)this.getPolicies(parent.getPath())[0];
                }
                Privilege readPrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read");
                Privilege writePrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}write");
                Privilege deletePrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}delete");
                Privilege adminPrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin");
                Privilege inheritReadPrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read");
                Privilege inheritWritePrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-write");
                Privilege inheritDeletePrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-delete");
                Privilege inheritAdminPrivilege = this.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin");
                Privilege removeChildNodesPrivilege = this.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes");
                HashMap<Principal, HashSet> principalPrivs = new HashMap<Principal, HashSet>();
                ArrayList<Principal> principalsWithRemoveChildNodesPrivilege = new ArrayList<Principal>();
                for (AccessControlEntry ace : parentAcl.getAccessControlEntries()) {
                    HashSet inheritPrivs = principalPrivs.containsKey(ace.getPrincipal()) ? (HashSet)principalPrivs.get(ace.getPrincipal()) : new HashSet();
                    Privilege[] privs = ace.getPrivileges();
                    for (int i = 0; i < privs.length; ++i) {
                        if (privs[i].equals((Object)inheritReadPrivilege)) {
                            inheritPrivs.add(readPrivilege);
                            inheritPrivs.add(inheritReadPrivilege);
                            continue;
                        }
                        if (privs[i].equals((Object)inheritWritePrivilege)) {
                            inheritPrivs.add(writePrivilege);
                            inheritPrivs.add(inheritWritePrivilege);
                            continue;
                        }
                        if (privs[i].equals((Object)inheritDeletePrivilege)) {
                            inheritPrivs.add(deletePrivilege);
                            inheritPrivs.add(inheritDeletePrivilege);
                            continue;
                        }
                        if (privs[i].equals((Object)inheritAdminPrivilege)) {
                            inheritPrivs.add(adminPrivilege);
                            inheritPrivs.add(inheritAdminPrivilege);
                            continue;
                        }
                        if (!privs[i].equals((Object)removeChildNodesPrivilege)) continue;
                        principalsWithRemoveChildNodesPrivilege.add(ace.getPrincipal());
                    }
                    principalPrivs.put(ace.getPrincipal(), inheritPrivs);
                }
                if (!principalPrivs.isEmpty()) {
                    boolean policyCreated = false;
                    boolean updateParentAcl = false;
                    NameFactory NF = NameFactoryImpl.getInstance();
                    NodeState policyNodeState = null;
                    int allowCount = -1;
                    for (Principal principal : principalPrivs.keySet()) {
                        HashSet inheritPrivs = (HashSet)principalPrivs.get(principal);
                        if (inheritPrivs.size() <= 0) continue;
                        if (!policyCreated) {
                            Set mixins = state.getMixinTypeNames();
                            mixins.add(AccessControlConstants.NT_REP_ACCESS_CONTROLLABLE);
                            state.setMixinTypeNames(mixins);
                            PropertyState mixinTypes = null;
                            InternalValue[] oldValues = null;
                            if (mixinTypesId == null) {
                                mixinTypes = sism.createTransientPropertyState(state.getNodeId(), NameConstants.JCR_MIXINTYPES, 4);
                            } else {
                                mixinTypes = (PropertyState)sism.getTransientItemState(mixinTypesId);
                                oldValues = mixinTypes.getValues();
                            }
                            InternalValue[] values = null;
                            if (oldValues != null) {
                                values = new InternalValue[oldValues.length + 1];
                                values[0] = InternalValue.create((Name)AccessControlConstants.NT_REP_ACCESS_CONTROLLABLE);
                                for (int i = 0; i < oldValues.length; ++i) {
                                    values[i + 1] = oldValues[i];
                                }
                            } else {
                                values = new InternalValue[]{InternalValue.create((Name)AccessControlConstants.NT_REP_ACCESS_CONTROLLABLE)};
                            }
                            mixinTypes.setType(7);
                            mixinTypes.setMultiValued(true);
                            mixinTypes.setValues(values);
                            state.addPropertyName(NameConstants.JCR_MIXINTYPES);
                            policyNodeState = sism.createTransientNodeState(null, AccessControlConstants.NT_REP_ACL, state.getNodeId(), 4);
                            PropertyState primaryType = sism.createTransientPropertyState(policyNodeState.getNodeId(), NameConstants.JCR_PRIMARYTYPE, 4);
                            primaryType.setType(7);
                            primaryType.setValues(new InternalValue[]{InternalValue.create((Name)AccessControlConstants.NT_REP_ACL)});
                            policyNodeState.addPropertyName(NameConstants.JCR_PRIMARYTYPE);
                            state.addChildNodeEntry(AccessControlConstants.N_POLICY, policyNodeState.getNodeId());
                            sism.nodeModified(state);
                            policyCreated = true;
                        }
                        NodeState allow = sism.createTransientNodeState(null, AccessControlConstants.NT_REP_GRANT_ACE, policyNodeState.getNodeId(), 4);
                        String allowName = "allow";
                        if (allowCount == -1) {
                            policyNodeState.addChildNodeEntry(NF.create("{}allow"), allow.getNodeId());
                        } else {
                            allowName = allowName + allowCount;
                            policyNodeState.addChildNodeEntry(NF.create("{}allow" + allowCount), allow.getNodeId());
                        }
                        PropertyState primaryType = sism.createTransientPropertyState(allow.getNodeId(), NameConstants.JCR_PRIMARYTYPE, 4);
                        primaryType.setType(7);
                        primaryType.setValues(new InternalValue[]{InternalValue.create((Name)AccessControlConstants.NT_REP_GRANT_ACE)});
                        allow.addPropertyName(NameConstants.JCR_PRIMARYTYPE);
                        PropertyState principalProperty = sism.createTransientPropertyState(allow.getNodeId(), AccessControlConstants.P_PRINCIPAL_NAME, 4);
                        principalProperty.setType(1);
                        principalProperty.setValues(new InternalValue[]{InternalValue.create((String)principal.getName())});
                        allow.addPropertyName(AccessControlConstants.P_PRINCIPAL_NAME);
                        PropertyState globProperty = sism.createTransientPropertyState(allow.getNodeId(), AccessControlConstants.P_GLOB, 4);
                        globProperty.setType(1);
                        globProperty.setValues(new InternalValue[]{InternalValue.create((String)"")});
                        allow.addPropertyName(AccessControlConstants.P_GLOB);
                        PropertyState privProperty = sism.createTransientPropertyState(allow.getNodeId(), AccessControlConstants.P_PRIVILEGES, 4);
                        privProperty.setType(7);
                        privProperty.setMultiValued(true);
                        InternalValue[] privs = new InternalValue[inheritPrivs.size()];
                        int privCount = 0;
                        for (Privilege priv : inheritPrivs) {
                            String namespaceUri = parent.getSession().getNamespaceURI(priv.getName().substring(0, priv.getName().indexOf(58)));
                            privs[privCount] = InternalValue.create((Name)NF.create(namespaceUri, priv.getName().substring(priv.getName().indexOf(58) + 1)));
                            ++privCount;
                        }
                        privProperty.setValues(privs);
                        allow.addPropertyName(AccessControlConstants.P_PRIVILEGES);
                        ++allowCount;
                        if (!inheritPrivs.contains(inheritDeletePrivilege) || principalsWithRemoveChildNodesPrivilege.contains(principal)) continue;
                        updateParentAcl = true;
                        parentAcl.addEntry(principal, new Privilege[]{removeChildNodesPrivilege}, true);
                    }
                    if (updateParentAcl) {
                        this.setPolicy(parent.getPath(), (AccessControlPolicy)parentAcl);
                    }
                }
            }
            finally {
                ((SASSessionImpl)session).endAdmin();
            }
        }
    }

    protected void checkPermission(String absPath, int permission) throws AccessDeniedException, RepositoryException {
        if (((SessionImpl)this.amContext.getSession()).isAdmin()) {
            return;
        }
        super.checkPermission(absPath, permission);
    }

    protected boolean isSystemOrAdmin(Subject subject) {
        if (subject == null) {
            return false;
        }
        return !subject.getPrincipals(SystemPrincipal.class).isEmpty() || !subject.getPrincipals(AdminPrincipal.class).isEmpty();
    }

    public static class Ace {
        private String principal;
        private BitSet aceBits = new BitSet(8);
        private final String[] privs = new String[]{"{http://sas.com/XmlNamespaces/DAV}read", "{http://sas.com/XmlNamespaces/DAV}write", "{http://sas.com/XmlNamespaces/DAV}delete", "{http://sas.com/XmlNamespaces/DAV}admin", "{http://sas.com/XmlNamespaces/DAV}inherit-read", "{http://sas.com/XmlNamespaces/DAV}inherit-write", "{http://sas.com/XmlNamespaces/DAV}inherit-delete", "{http://sas.com/XmlNamespaces/DAV}inherit-admin"};

        public Ace(String principal, String s) {
            this.principal = principal;
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s);
                while (st.hasMoreTokens()) {
                    String p = st.nextToken();
                    for (int i = 0; i < this.privs.length; ++i) {
                        if (!p.equalsIgnoreCase(this.privs[i])) continue;
                        this.aceBits.set(i);
                    }
                }
            }
        }

        public Ace(String principal, String[] s) {
            this.principal = principal;
            if (s != null) {
                for (int i = 0; i < s.length; ++i) {
                    for (int j = 0; j < this.privs.length; ++j) {
                        if (!s[i].equalsIgnoreCase(this.privs[j])) continue;
                        this.aceBits.set(j);
                    }
                }
            }
        }

        public Ace(String principal, Privilege[] s) {
            this.principal = principal;
            if (s != null) {
                for (int i = 0; i < s.length; ++i) {
                    for (int j = 0; j < this.privs.length; ++j) {
                        if (!this.privs[j].equalsIgnoreCase(s[i].getName())) continue;
                        this.aceBits.set(j);
                    }
                }
            }
        }

        public Ace(Node aceNode) {
            try {
                if (aceNode.hasProperty("jcr:principal")) {
                    this.principal = aceNode.getProperty("jcr:principal").getString();
                }
                if (aceNode.hasProperty("jcr:grant")) {
                    Value[] values = aceNode.getProperty("jcr:grant").getValues();
                    String[] currPrivs = SASDefaultAccessManager.getStringValues(values);
                    for (int i = 0; i < currPrivs.length; ++i) {
                        for (int j = 0; j < this.privs.length; ++j) {
                            if (!currPrivs[i].equalsIgnoreCase(this.privs[j])) continue;
                            this.aceBits.set(j);
                        }
                    }
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }

        public String[] getValue() {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.privs.length; ++i) {
                if (!this.aceBits.get(i)) continue;
                result.add(this.privs[i]);
            }
            return result.toArray(new String[0]);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.privs.length; ++i) {
                if (!this.aceBits.get(i)) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.privs[i]);
            }
            return sb.toString();
        }

        public BitSet getBitSet() {
            return this.aceBits;
        }

        public void setBitSet(BitSet bitset) {
            this.aceBits = bitset;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public void apply(Boolean[] permissions) {
            if (log.isDebugEnabled()) {
                StringBuffer permStr = new StringBuffer();
                for (int i = 0; i < permissions.length; ++i) {
                    if (permissions[i] == null) continue;
                    if (permissions[i].booleanValue()) {
                        if (permStr.length() > 0) {
                            permStr.append(",");
                        }
                        permStr.append(i);
                        continue;
                    }
                    if (permStr.length() > 0) {
                        permStr.append(",");
                    }
                    permStr.append("-" + i);
                }
                log.debug("Ace resolve permissions for " + this.principal + ", " + this.aceBits.toString() + " {" + permStr.toString() + "}");
            }
            for (int i = 0; i < permissions.length; ++i) {
                Boolean b = permissions[i];
                if (b == null) continue;
                if (b.booleanValue()) {
                    this.aceBits.set(i);
                    continue;
                }
                this.aceBits.clear(i);
            }
        }

        public static enum Privileges {
            READ("{http://sas.com/XmlNamespaces/DAV}read"),
            WRITE("{http://sas.com/XmlNamespaces/DAV}write"),
            DELETE("{http://sas.com/XmlNamespaces/DAV}delete"),
            ADMIN("{http://sas.com/XmlNamespaces/DAV}admin"),
            INHERIT_READ("{http://sas.com/XmlNamespaces/DAV}inherit-read"),
            INHERIT_WRITE("{http://sas.com/XmlNamespaces/DAV}inherit-write"),
            INHERIT_DELETE("{http://sas.com/XmlNamespaces/DAV}inherit-delete"),
            INHERIT_ADMIN("{http://sas.com/XmlNamespaces/DAV}inherit-admin");

            private final String name;

            private Privileges(String name) {
                this.name = name;
            }

            String Name() {
                return this.name;
            }
        }
    }
}

