/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.persistence.pool;

import com.sas.contentserver.persistence.pool.TenantBundleDbPersistenceManager;
import com.sas.contentserver.persistence.pool.TeradataPersistenceManager;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantTeradataPersistenceManager
extends TenantBundleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(TenantTeradataPersistenceManager.class);

    @Override
    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("com.teradata.jdbc.TeraDriver");
        }
        if (this.getSchema() == null) {
            this.setSchema("Teradata");
        }
        super.init(context);
    }

    @Override
    protected BundleDbPersistenceManager createPersistenceManager() {
        return new TeradataPersistenceManager();
    }

    @Override
    protected BundleDbPersistenceManager.CloseableBLOBStore createDBBlobStore(PMContext context) throws Exception {
        return new TenantTeradataDbBlobStore();
    }

    @Override
    public int getStorageModel() {
        return 2;
    }

    @Override
    public synchronized NodeReferences loadReferencesTo(NodeId targetId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences nodeReferences;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ResultSet rs = null;
        InputStream in = null;
        try {
            rs = this.conHelper.exec(this.nodeReferenceSelectSQL, this.getKey(targetId), false, 0);
            if (!rs.next()) {
                throw new NoSuchItemStateException(targetId.toString());
            }
            Blob blob = rs.getBlob(1);
            in = blob.getBinaryStream();
            NodeReferences refs = new NodeReferences(targetId);
            Serializer.deserialize((NodeReferences)refs, (InputStream)in);
            nodeReferences = refs;
        }
        catch (Exception e) {
            try {
                if (e instanceof NoSuchItemStateException) {
                    throw (NoSuchItemStateException)((Object)e);
                }
                String msg = "failed to read references: " + targetId;
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                DbUtility.close(rs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        DbUtility.close((ResultSet)rs);
        return nodeReferences;
    }

    class TenantTeradataDbBlobStore
    extends TenantBundleDbPersistenceManager.TenantDbBlobStore {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream get(String blobId) throws Exception {
            FilterInputStream filterInputStream;
            block7: {
                InputStream in;
                boolean close;
                ResultSet rs;
                block5: {
                    ByteArrayInputStream byteArrayInputStream;
                    block6: {
                        rs = null;
                        close = true;
                        try {
                            rs = TenantTeradataPersistenceManager.this.conHelper.exec(this.blobSelectSQL, new Object[]{blobId}, false, 0);
                            if (!rs.next()) {
                                throw new Exception("no such BLOB: " + blobId);
                            }
                            Blob blob = rs.getBlob(1);
                            in = blob.getBinaryStream();
                            if (in != null) break block5;
                            byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                            if (!close) break block6;
                        }
                        catch (Throwable throwable) {
                            if (close) {
                                DbUtility.close(rs);
                            }
                            throw throwable;
                        }
                        DbUtility.close((ResultSet)rs);
                    }
                    return byteArrayInputStream;
                }
                close = false;
                final ResultSet rs2 = rs;
                filterInputStream = new FilterInputStream(in){

                    @Override
                    public void close() throws IOException {
                        try {
                            this.in.close();
                        }
                        finally {
                            DbUtility.close((ResultSet)rs2);
                        }
                    }
                };
                if (!close) break block7;
                DbUtility.close((ResultSet)rs);
            }
            return filterInputStream;
        }
    }
}

