/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.jcrtree;

import com.sas.contentserver.core.jndi.SASRegistryHelper;
import com.sas.contentserver.jcrtree.JCRTreeNode;
import com.sas.contentserver.jcrtree.Splash;
import com.sas.contentserver.jcrtree.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.jndi.RegistryHelper;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;

public class JCRTree
extends JFrame
implements TreeSelectionListener,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private static final boolean traceEnabled = false;
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private static ResourceBundle RB = ResourceBundle.getBundle("com.sas.contentserver.jcrtree.Resources");
    private JTree jTree;
    private JTable jTable;
    private JSplitPane sp;
    private JLabel status;
    private Vector<String> resNameVector = new Vector();
    private Vector<String> resValueVector = new Vector();
    private TableModel tbModel = null;
    private String userid = null;
    private String password = null;
    private String reposHome;
    private String configFile;
    private JCRTreeNode top = null;
    private DefaultTreeModel dtModel = null;
    private JPopupMenu treeMenu;
    private JMenuItem miCopyClipboard;
    private JMenuItem miCopyUUIDClipboard;
    private int screenHeight;
    private int screenWidth;
    private static Properties properties = new Properties();
    private static int FRAME_WIDTH = 900;
    private static int FRAME_HEIGHT = 680;
    private static Color COLOR_TABLE_BACKGROUND = Color.WHITE;
    private static Color COLOR_TREE_BACKGROUND = Color.WHITE;
    private static Color COLOR_TREE_SELECTION = COLOR_TREE_BACKGROUND.darker();
    private static Color COLOR_TABLE_FOREGROUND = Color.BLUE;
    private static Color COLOR_TREE_FOREGROUND = Color.BLUE;
    private static Color COLOR_TABLE_BACKGROUND_COLUMN1 = new Color(248, 248, 248);
    private static Color COLOR_TABLE_FOREGROUND_COLUMN1 = Color.BLUE;
    private static final Font treeFont = new Font("SanSerif", 0, 11);
    private static final Font tableFont = new Font("SanSerif", 0, 11);
    private static final Font tableFontBold = new Font("SanSerif", 1, 11);
    private static final Font DIALOG_FONT = new Font("SanSerif", 0, 11);
    private static final String P_WINDOWHEIGHT = "window.height";
    private static final String P_WINDOWWIDTH = "window.width";
    private static final String P_TBBC = "table.background.color";
    private static final String P_TBFC = "table.foreground.color";
    private static final String P_TRBC = "tree.background.color";
    private static final String P_TRFC = "tree.foreground.color";
    private static final String P_TBBCC1 = "table.background.color.column1";
    private static final String P_TBFCC1 = "table.foreground.color.column1";
    private static final String version = "2.0.0";
    private static final String tmpdir = System.getProperty("java.io.tmpdir");
    private ImageIcon colImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/contentserver/jcrtree/collection.gif"));
    private ImageIcon lockedColImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/contentserver/jcrtree/lockedcollection.gif"));
    private ImageIcon resImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/contentserver/jcrtree/resource.gif"));
    private ImageIcon lockedResImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/contentserver/jcrtree/lockedresource.gif"));
    private ImageIcon checkedOutResImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/contentserver/jcrtree/checkedoutresource.gif"));
    private ImageIcon lockedCheckedOutResImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/contentserver/jcrtree/lcoresource.gif"));
    HistoryComboBox hCombo = new HistoryComboBox();
    public String historyFileName = "jctree.history.dat";
    JMenuBar mainMenuBar;
    JMenu menu1;
    JMenu menu2;
    JMenu menu3;
    JMenu vmenu;
    JMenu helpMenu;
    JMenuItem miOpen;
    JMenuItem miTest1;
    JMenuItem miExit;
    JMenuItem miDelete;
    JMenuItem miAdd;
    JMenuItem miModify;
    JMenuItem miClone;
    JMenuItem miRefresh1;
    JMenuItem miRefresh2;
    JMenuItem miSearch;
    JMenuItem miContents;
    JMenuItem miVersion;
    JMenuItem miCheckout;
    JMenuItem miCheckin;
    JMenuItem miVHReport;
    JMenuItem miAbout;
    JMenuItem miLock;
    JMenuItem miUnlock;
    JMenuItem miImport;
    JMenuItem miExport;
    JCheckBoxMenuItem miDetails;
    JOptionPane chk = new JOptionPane();
    DocumentBuilderFactory factory = null;
    DocumentBuilder builder = null;
    JComboBox workspacesList = new JComboBox();
    boolean inDragDrop = false;
    boolean allProp = false;
    File dndFile = null;
    String dndString = null;
    private Repository r;
    private Session session;
    private Workspace workspace;
    private String[] workspaces;
    private NamespaceRegistry nsr;
    private static int counter;

    private static Color ColorFromRGB(String RGBString) {
        int r = 0;
        int g = 0;
        int b = 0;
        try {
            String colval = null;
            int p1 = 0;
            int p2 = RGBString.indexOf(44, p1);
            colval = RGBString.substring(p1, p2);
            r = Integer.parseInt(colval);
            p1 = p2 + 1;
            p2 = RGBString.indexOf(44, p1);
            colval = RGBString.substring(p1, p2);
            g = Integer.parseInt(colval);
            p1 = p2 + 1;
            p2 = RGBString.indexOf(44, p1);
            colval = RGBString.substring(p1);
            b = Integer.parseInt(colval);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Color(r, g, b);
    }

    public JCRTree(String url) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setTitle(MessageFormat.format(RB.getString("JCRTree.application.fmt.txt"), version));
        Splash splashWin = new Splash(this, 15000);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        this.screenHeight = dim.height;
        this.screenWidth = dim.width;
        this.setBounds((this.screenWidth - FRAME_WIDTH) / 2, (this.screenHeight - FRAME_HEIGHT) / 2, FRAME_WIDTH, FRAME_HEIGHT);
        this.getContentPane().setLayout(new BorderLayout());
        if (url.length() > 0) {
            this.top.resName = this.top.fullName;
            this.dtModel = new JCRTreeModel(this.top);
        } else {
            this.dtModel = new JCRTreeModel(new DefaultMutableTreeNode());
            this.dtModel.setRoot(null);
        }
        this.jTree = new DNDTree(this.dtModel, true, true){
            private static final long serialVersionUID = 1L;

            public String getPathName(TreePath path) {
                Object o = path.getLastPathComponent();
                if (o instanceof JCRTreeNode) {
                    return ((JCRTreeNode)o).fullName;
                }
                return null;
            }
        };
        this.jTree.addTreeSelectionListener(this);
        this.jTree.addTreeExpansionListener(new TreeExpansionHandler());
        this.jTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent evt) {
                Object[] children = evt.getChildren();
                JCRTreeNode dtNode = (JCRTreeNode)children[0];
                dtNode.DAVprops = JCRTree.this.getProperties(dtNode);
                JCRTree.this.setupVectors(dtNode.DAVprops);
                ((AbstractTableModel)JCRTree.this.tbModel).fireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent evt) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent evt) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent evt) {
            }
        });
        this.jTree.setBackground(COLOR_TREE_BACKGROUND);
        this.tbModel = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;
            private final String[] colNames = new String[]{JCRTree.access$200().getString("JCRTree.namecolumnlabel.txt"), JCRTree.access$200().getString("JCRTree.valuecolumnlabel.txt")};

            @Override
            public String getColumnName(int col) {
                return this.colNames[col].toString();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return JCRTree.this.resNameVector.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return JCRTree.this.resNameVector.elementAt(row);
                }
                return JCRTree.this.resValueVector.elementAt(row);
            }
        };
        this.jTable = new JTable(this.tbModel);
        this.jTable.setGridColor(COLOR_TREE_SELECTION);
        this.jTable.setForeground(COLOR_TABLE_FOREGROUND);
        this.jTable.setBackground(COLOR_TABLE_BACKGROUND);
        this.jTable.setFont(tableFont);
        CustomTableCellRenderer renderer = new CustomTableCellRenderer();
        renderer.setBackground(COLOR_TABLE_BACKGROUND_COLUMN1);
        renderer.setForeground(COLOR_TABLE_FOREGROUND_COLUMN1);
        renderer.setFont(tableFontBold);
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        for (int i = 0; i < 2; ++i) {
            TableColumn col;
            if (i == 0) {
                col = this.jTable.getColumnModel().getColumn(0);
                col.setWidth(75);
                col.setPreferredWidth(75);
                col.sizeWidthToFit();
                continue;
            }
            col = this.jTable.getColumnModel().getColumn(1);
            col.setWidth(375);
            col.setPreferredWidth(375);
        }
        this.jTable.setAutoResizeMode(3);
        this.jTable.setShowGrid(false);
        this.jTable.setIntercellSpacing(new Dimension(0, 0));
        this.jTable.getColumnModel().setColumnMargin(2);
        JScrollPane treePane = new JScrollPane(this.jTree);
        JScrollPane tablePane = new JScrollPane(this.jTable);
        tablePane.setBackground(COLOR_TABLE_BACKGROUND);
        tablePane.getViewport().setBackground(COLOR_TABLE_BACKGROUND);
        treePane.setMinimumSize(new Dimension(190, treePane.getPreferredSize().height));
        this.sp = new JSplitPane();
        this.sp.setDividerLocation(0.33);
        JTabbedPane tabbedPane = new JTabbedPane();
        String tabLabel = RB.getString("JCRTree.tabletab.label.txt");
        String tabDesc = RB.getString("JCRTree.tabletab.desc.txt");
        tabbedPane.addTab(tabLabel, null, tablePane, tabDesc);
        tabLabel = RB.getString("JCRTree.xmltab.label.txt");
        tabDesc = RB.getString("JCRTree.xmltab.desc.txt");
        tabbedPane.setSelectedIndex(0);
        this.sp.setLeftComponent(treePane);
        this.sp.setRightComponent(tabbedPane);
        this.jTree.getSelectionModel().setSelectionMode(4);
        this.jTree.setShowsRootHandles(true);
        CustomBasicRenderer btcr = new CustomBasicRenderer();
        btcr.setBackgroundNonSelectionColor(COLOR_TREE_BACKGROUND);
        btcr.setBackgroundSelectionColor(COLOR_TREE_SELECTION);
        btcr.setTextSelectionColor(Color.WHITE);
        btcr.setFont(treeFont);
        this.jTree.setCellRenderer(btcr);
        this.jTree.setEditable(false);
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selectedRow = JCRTree.this.jTree.getRowForLocation(e.getX(), e.getY());
                if (selectedRow != -1 && SwingUtilities.isRightMouseButton(e)) {
                    JCRTree.this.jTree.setSelectionRow(selectedRow);
                    JCRTree.this.treeMenu.show(JCRTree.this.jTree, e.getX(), e.getY());
                }
            }
        });
        ProcessActions processAction = new ProcessActions();
        this.mainMenuBar = new JMenuBar();
        this.menu1 = new JMenu(RB.getString("JCRTree.menu.file.txt"));
        this.menu2 = new JMenu(RB.getString("JCRTree.menu.edit.txt"));
        this.menu3 = new JMenu(RB.getString("JCRTree.menu.view.txt"));
        this.vmenu = new JMenu(RB.getString("JCRTree.menu.versioning.txt"));
        this.helpMenu = new JMenu(RB.getString("JCRTree.menu.help.txt"));
        this.miOpen = new JMenuItem(RB.getString("JCRTree.menu.file.open.txt"));
        this.miOpen.addActionListener(processAction);
        this.menu1.add(this.miOpen);
        this.menu1.addSeparator();
        this.miExit = new JMenuItem(RB.getString("JCRTree.menu.file.exit.txt"));
        this.menu1.add(this.miExit);
        this.miExit.addActionListener(processAction);
        this.mainMenuBar.add(this.menu1);
        this.miDelete = new JMenuItem(RB.getString("JCRTree.menu.edit.delete.txt"));
        this.miDelete.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        this.menu2.add(this.miDelete);
        this.miDelete.addActionListener(processAction);
        this.miAdd = new JMenuItem(RB.getString("JCRTree.menu.edit.add.txt"));
        this.menu2.add(this.miAdd);
        this.miAdd.addActionListener(processAction);
        this.miModify = new JMenuItem(RB.getString("JCRTree.menu.edit.modify.txt"));
        this.menu2.add(this.miModify);
        this.miModify.addActionListener(processAction);
        this.miClone = new JMenuItem(RB.getString("JCRTree.menu.edit.clone.txt"));
        this.miClone.setEnabled(false);
        this.menu2.add(this.miClone);
        this.mainMenuBar.add(this.menu2);
        this.miRefresh1 = new JMenuItem(RB.getString("JCRTree.menu.view.refresh.txt"));
        this.miRefresh2 = new JMenuItem(RB.getString("JCRTree.menu.view.refresh.txt"));
        this.miSearch = new JMenuItem(RB.getString("JCRTree.menu.view.search.txt"));
        this.miContents = new JCheckBoxMenuItem(RB.getString("JCRTree.menu.view.contents.txt"), false);
        this.miSearch.setEnabled(false);
        this.miDetails = new JCheckBoxMenuItem(RB.getString("JCRTree.menu.view.details.txt"), false);
        this.miDetails.addActionListener(processAction);
        this.menu3.add(this.miDetails);
        this.menu3.add(this.miRefresh1);
        this.miRefresh1.addActionListener(processAction);
        this.menu3.add(this.miSearch);
        this.menu3.add(this.miContents);
        this.miContents.addActionListener(processAction);
        this.mainMenuBar.add(this.menu3);
        this.miVersion = new JMenuItem(RB.getString("JCRTree.menu.view.version.txt"));
        this.vmenu.add(this.miVersion);
        this.miVersion.addActionListener(processAction);
        this.miCheckin = new JMenuItem(RB.getString("JCRTree.menu.view.checkin.txt"));
        this.vmenu.add(this.miCheckin);
        this.miCheckin.addActionListener(processAction);
        this.miCheckout = new JMenuItem(RB.getString("JCRTree.menu.view.checkout.txt"));
        this.vmenu.add(this.miCheckout);
        this.miCheckout.addActionListener(processAction);
        this.mainMenuBar.add(this.vmenu);
        this.miLock = new JMenuItem(RB.getString("JCRTree.menu.view.lock.txt"));
        this.menu3.add(this.miLock);
        this.miLock.addActionListener(processAction);
        this.miUnlock = new JMenuItem(RB.getString("JCRTree.menu.view.unlock.txt"));
        this.menu3.add(this.miUnlock);
        this.miUnlock.addActionListener(processAction);
        this.miAbout = new JMenuItem(RB.getString("JCRTree.menu.help.about.txt"));
        this.helpMenu.add(this.miAbout);
        this.miAbout.addActionListener(processAction);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        this.treeMenu = new JPopupMenu();
        this.treeMenu.setInvoker(this.jTree);
        this.treeMenu.setVisible(false);
        this.miCopyClipboard = new JMenuItem("Copy URI to clipboard");
        this.treeMenu.add(this.miCopyClipboard);
        this.miCopyClipboard.addActionListener(processAction);
        this.miCopyUUIDClipboard = new JMenuItem("Copy UUID to clipboard");
        this.treeMenu.add(this.miCopyUUIDClipboard);
        this.miCopyUUIDClipboard.addActionListener(processAction);
        this.miImport = new JMenuItem("Import");
        this.treeMenu.add(this.miImport);
        this.miImport.addActionListener(processAction);
        this.miExport = new JMenuItem("Export");
        this.treeMenu.add(this.miExport);
        this.miExport.addActionListener(processAction);
        this.treeMenu.add(this.miRefresh2);
        this.miRefresh2.addActionListener(processAction);
        this.treeMenu.add(this.miLock);
        this.treeMenu.add(this.miUnlock);
        String userHome = System.getProperty("user.home");
        String fileSeparator = System.getProperty("file.separator");
        if (userHome != null) {
            this.historyFileName = userHome + fileSeparator + this.historyFileName;
        }
        this.hCombo.load(this.historyFileName);
        this.hCombo.setPreferredSize(new Dimension(280, this.hCombo.getPreferredSize().height));
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JCRTree.this.hCombo.save(JCRTree.this.historyFileName);
                JCRTree.exit();
            }
        };
        this.addWindowListener(wndCloser);
        this.getContentPane().add((Component)this.sp, "Center");
        this.status = new JLabel(">", 0);
        this.status.setHorizontalAlignment(2);
        this.status.setBorder(BorderFactory.createBevelBorder(1));
        this.getContentPane().add((Component)this.status, "South");
        this.getContentPane().add((Component)this.workspacesList, "North");
        this.validate();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        splashWin.dispose();
        this.setVisible(true);
    }

    protected TreeMap<String, String> getProperties(JCRTreeNode node) {
        TreeMap<String, String> ht = new TreeMap<String, String>();
        Node _node = node.JCRNode;
        try {
            PropertyIterator props = _node.getProperties();
            while (props.hasNext()) {
                String value;
                Property p = props.nextProperty();
                PropertyDefinition pd = p.getDefinition();
                if (pd.isMultiple()) {
                    Value[] v = p.getValues();
                    value = "";
                    for (int j = 0; j < v.length; ++j) {
                        if (j > 0) {
                            value = value + "; ";
                        }
                        value = value + v[j].getString();
                    }
                } else {
                    value = p.getString();
                }
                if (p.getType() == 2) {
                    long length = value.length();
                    ht.put(p.getName(), "[" + length + "] " + value.substring(0, (int)Math.min(60L, length)));
                    continue;
                }
                ht.put(p.getName(), value);
            }
            if (_node instanceof NodeImpl) {
                ht.put("rep:node-id", ((NodeImpl)_node).getId().toString());
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return ht;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.DAVprops == null) {
            node.DAVprops = this.getProperties(node);
        }
        this.setupVectors(node.DAVprops);
        ((AbstractTableModel)this.tbModel).fireTableDataChanged();
        this.status.setText(">");
    }

    private void setupVectors(TreeMap<String, String> DAVprops) {
        Iterator<String> keys = null;
        Iterator<String> values = null;
        this.resNameVector.clear();
        this.resValueVector.clear();
        if (DAVprops != null) {
            keys = DAVprops.keySet().iterator();
            values = DAVprops.values().iterator();
            while (keys.hasNext()) {
                this.resNameVector.add(keys.next());
            }
            while (values.hasNext()) {
                String nodeText = values.next();
                this.resValueVector.add(nodeText);
            }
        }
    }

    private static void exit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (args.length == 0) {
            new JCRTree("");
        } else {
            new JCRTree(args[0]);
        }
    }

    public void miContents_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Node jcrNode = node.JCRNode;
            if (jcrNode.hasProperty("jcr:data")) {
                HexDisplayDlg hexdlg = new HexDisplayDlg(this, node.fullName, jcrNode.getProperty("jcr:data").getStream());
                hexdlg.setVisible(true);
            }
        }
        catch (ValueFormatException ex) {
            ex.printStackTrace();
        }
        catch (PathNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RepositoryException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miVHReport_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Node jcrNode = node.JCRNode;
            VersionHistory vh = jcrNode.getVersionHistory();
            VersionIterator viter = vh.getAllVersions();
            ArrayList<Version> resultList = new ArrayList<Version>();
            while (viter.hasNext()) {
                Version v = viter.nextVersion();
                resultList.add(v);
            }
            VHDlg vhdlg = new VHDlg(this, resultList, true);
            vhdlg.setVisible(true);
        }
        catch (RepositoryException ex) {
            this.status.setText(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void miAbout_Action(ActionEvent e) {
        AboutDlg aboutdlg = new AboutDlg(this, true);
        aboutdlg.setVisible(true);
    }

    public void miVersion_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miCheckout_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Node jcrNode = node.JCRNode;
            jcrNode.checkout();
            ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
        }
        catch (RepositoryException re) {
            this.status.setText(re.getMessage());
            re.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miCheckin_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Node jcrNode = node.JCRNode;
            jcrNode.checkin();
            ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
        }
        catch (RepositoryException re) {
            this.status.setText(re.getMessage());
            re.printStackTrace();
        }
    }

    public void miCopyClipboard_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        String url = node.fullName;
        StringSelection stringSelection = new StringSelection(url);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miCopyUUIDClipboard_Action(ActionEvent e) {
        String uuid;
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Node jcrNode = node.JCRNode;
            uuid = jcrNode.getUUID();
        }
        catch (RepositoryException ex) {
            uuid = "?????";
        }
        StringSelection stringSelection = new StringSelection(uuid);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public void miDetails_Action(ActionEvent e) {
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
        this.allProp = item.isSelected();
    }

    public void miExit_Action(ActionEvent e) {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    public void miOpen_Action(ActionEvent e) {
        OpenDlg opendlg = new OpenDlg(this, RB.getString("JCRTree.openhdr.txt"), RB.getString("JCRTree.opendesc.txt"));
        opendlg.setVisible(true);
        this.userid = null;
        this.password = null;
        this.status.setText(" ");
        CredentialsDlg dlg = new CredentialsDlg(this, true);
        dlg.pack();
        dlg.setVisible(true);
        if (this.userid == null || this.password == null) {
            System.exit(4);
        }
        try {
            if (this.configFile.startsWith("http")) {
                try {
                    this.r = new URLRemoteRepository(this.configFile);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            } else {
                SASRegistryHelper.registerJNDIDataSources();
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.url.pkgs", "org.apache.jackrabbit.core.jndi.provider:javax.naming.spi");
                env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
                env.put("java.naming.provider.url", "localhost");
                try {
                    InitialContext ctx = new InitialContext(env);
                    SASRegistryHelper.registerRepository(ctx, "repo", this.configFile, this.reposHome, true);
                    this.r = (Repository)ctx.lookup("repo");
                    try {
                        this.session = this.r.login((Credentials)new SimpleCredentials(this.userid, this.password.toCharArray()), null);
                    }
                    catch (ClassCastException e2) {
                        System.out.println("Exception using SASRegistryHelper. Trying RegistryHelper");
                        SASRegistryHelper.unregisterRepository(ctx, "repo");
                        RegistryHelper.registerRepository((Context)ctx, (String)"repo", (String)this.configFile, (String)this.reposHome, (boolean)true);
                        this.r = (Repository)ctx.lookup("repo");
                        this.session = this.r.login((Credentials)new SimpleCredentials(this.userid, this.password.toCharArray()), null);
                    }
                }
                catch (NamingException e1) {
                    e1.printStackTrace();
                }
                catch (RepositoryException e1) {
                    e1.printStackTrace();
                }
                if (this.r == null) {
                    throw new RepositoryException("Valid repository not found");
                }
            }
            this.session = this.r.login((Credentials)new SimpleCredentials(this.userid, this.password.toCharArray()), null);
            this.workspace = this.session.getWorkspace();
            this.workspaces = this.workspace.getAccessibleWorkspaceNames();
            this.workspacesList.removeAllItems();
            for (int i = 0; i < this.workspaces.length; ++i) {
                this.workspacesList.addItem(this.workspaces[i]);
            }
            this.nsr = this.workspace.getNamespaceRegistry();
            System.out.println("Repository Descriptors");
            String[] dKeys = this.r.getDescriptorKeys();
            for (int i = 0; i < dKeys.length; ++i) {
                System.out.println(dKeys[i] + " = " + this.r.getDescriptor(dKeys[i]));
            }
            System.out.println();
            Node rn = this.session.getRootNode();
            this.top = new JCRTreeNode(rn);
            boolean addedNodes = this.top.populateCollections(this, true);
            if (addedNodes) {
                this.top.resName = this.top.fullName;
                this.dtModel.setRoot(this.top);
            }
            this.workspacesList.setSelectedItem("default");
            this.workspacesList.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        String wkspc = (String)((JComboBox)e.getSource()).getSelectedItem();
                        try {
                            JCRTree.this.session = JCRTree.this.r.login((Credentials)new SimpleCredentials(JCRTree.this.userid, JCRTree.this.password.toCharArray()), wkspc);
                            Node rn = JCRTree.this.session.getRootNode();
                            JCRTree.this.top = new JCRTreeNode(rn);
                            boolean addedNodes = JCRTree.this.top.populateCollections(JCRTree.this, true);
                            if (addedNodes) {
                                ((JCRTree)JCRTree.this).top.resName = ((JCRTree)JCRTree.this).top.fullName;
                                JCRTree.this.dtModel.setRoot(JCRTree.this.top);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void miRefresh2_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        TreePath selPath = this.jTree.getLeadSelectionPath();
        if (node == null) {
            try {
                node = new JCRTreeNode(this.session.getRootNode());
                boolean addedNodes = node.populateCollections(this, true);
                if (addedNodes) {
                    node.resName = node.fullName;
                    this.dtModel.setRoot(node);
                }
            }
            catch (RepositoryException e1) {
                e1.printStackTrace();
            }
        } else {
            node.populated = false;
            node.interim = false;
            node.removeAllChildren();
            ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
            this.valueChanged(null);
            try {
                node.populateCollections(this, false);
            }
            catch (RepositoryException e1) {
                e1.printStackTrace();
            }
            ((DefaultTreeModel)this.jTree.getModel()).nodeStructureChanged(node);
            ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
            this.jTree.collapsePath(selPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void miDelete_Action(ActionEvent e) {
        boolean doAll = false;
        boolean jumpOut = false;
        Object[] options = new Object[]{RB.getString("JCRTree.yes.txt"), RB.getString("JCRTree.yesall.txt"), RB.getString("JCRTree.no.txt"), RB.getString("JCRTree.cancel.txt")};
        TreePath[] selpaths = this.jTree.getSelectionPaths();
        try {
            int i = 0;
            while (i < selpaths.length) {
                block12: {
                    if (jumpOut) {
                        return;
                    }
                    JCRTreeNode node = (JCRTreeNode)selpaths[i].getLastPathComponent();
                    Node jcrNode = node.JCRNode;
                    String path = jcrNode.getPath();
                    int selval = !doAll ? JOptionPane.showOptionDialog(this, MessageFormat.format(RB.getString("JCRTree.delcheck.fmt.txt"), path), RB.getString("JCRTree.confirmation.txt"), -1, 1, null, options, options[0]) : 1;
                    switch (selval) {
                        case 1: {
                            doAll = true;
                        }
                        case 0: {
                            jcrNode.remove();
                            this.dtModel.removeNodeFromParent(node);
                            break;
                        }
                        case 2: {
                            break block12;
                        }
                        case 3: {
                            jumpOut = true;
                        }
                    }
                    this.session.save();
                }
                ++i;
            }
            return;
        }
        catch (RepositoryException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miLock_Action(ActionEvent e) {
        TreePath[] selpaths = this.jTree.getSelectionPaths();
        for (int i = 0; i < selpaths.length; ++i) {
            JCRTreeNode node = (JCRTreeNode)selpaths[i].getLastPathComponent();
            try {
                Node jcrNode = node.JCRNode;
                boolean isDeep = true;
                boolean isSessionScoped = true;
                jcrNode.lock(isDeep, isSessionScoped);
            }
            catch (RepositoryException ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miUnlock_Action(ActionEvent e) {
        TreePath[] selpaths = this.jTree.getSelectionPaths();
        for (int i = 0; i < selpaths.length; ++i) {
            JCRTreeNode node = (JCRTreeNode)selpaths[i].getLastPathComponent();
            try {
                Node jcrNode = node.JCRNode;
                jcrNode.unlock();
            }
            catch (RepositoryException ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miAdd_Action(ActionEvent e) {
        block10: {
            JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            try {
                Node jcrNode = node.JCRNode;
                int selval = JOptionPane.showConfirmDialog(this, MessageFormat.format(RB.getString("JCRTree.addcheck.fmt.txt"), jcrNode.getPath()), RB.getString("JCRTree.confirmation.txt"), 0, 1);
                if (selval != 0) break block10;
                AddDlg add_dlg = new AddDlg(this, true);
                add_dlg.setVisible(true);
                String nodeType = add_dlg.nodeType;
                String newName = add_dlg.name.getText();
                Node newNode = jcrNode.addNode(newName, nodeType);
                Map<String, String> setUpdates = add_dlg.getSetUpdates();
                if (!setUpdates.isEmpty()) {
                    try {
                        for (String key : setUpdates.keySet()) {
                            PropName pn = new PropName(key);
                            String prefix = this.getPrefix(pn);
                            String propVal = setUpdates.get(key);
                            newNode.setProperty(prefix + ":" + pn.getName(), propVal);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.session.save();
                node.populated = false;
                node.removeAllChildren();
                if (node.populateCollections(this, true)) {
                    ((DefaultTreeModel)this.jTree.getModel()).nodeStructureChanged(node);
                }
            }
            catch (RepositoryException ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miExport_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Node jcrNode = node.JCRNode;
            String name = jcrNode.getName();
            String tempDir = System.getProperty("java.io.tmpdir");
            try {
                this.session.exportSystemView(jcrNode.getPath(), (OutputStream)new FileOutputStream(new File(tempDir, name)), false, false);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (RepositoryException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miModify_Action(ActionEvent e) {
        JCRTreeNode node = (JCRTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        int selval = JOptionPane.showConfirmDialog(this, MessageFormat.format(RB.getString("JCRTree.modcheck.fmt.txt"), node.fullName), RB.getString("JCRTree.confirmation.txt"), 0, 1);
        if (selval == 0) {
            ModDlg moddlg = new ModDlg(this, node.DAVprops, true);
            moddlg.setVisible(true);
            Map<String, String> setUpdates = moddlg.getSetUpdates();
            Vector<String> delUpdates = moddlg.getDelUpdates();
            if (!setUpdates.isEmpty() || !delUpdates.isEmpty()) {
                try {
                    Node jcrNode = node.JCRNode;
                    for (String key : setUpdates.keySet()) {
                        PropName pn = new PropName(key);
                        String prefix = this.getPrefix(pn);
                        String propVal = setUpdates.get(key);
                        String fullName = prefix + ":" + pn.getName();
                        String[] stringVals = propVal.split(";");
                        ValueFactory vf = jcrNode.getSession().getValueFactory();
                        if (fullName.equals("jcr:mixinTypes")) {
                            for (String mixin : stringVals) {
                                jcrNode.addMixin(mixin);
                            }
                            continue;
                        }
                        if (stringVals.length == 1) {
                            Value val = vf.createValue(stringVals[0]);
                            jcrNode.setProperty(fullName, val);
                            continue;
                        }
                        Value[] vals = new Value[stringVals.length];
                        for (int i = 0; i < stringVals.length; ++i) {
                            vals[i] = vf.createValue(stringVals[i]);
                        }
                        jcrNode.setProperty(fullName, vals);
                    }
                    for (int i = 0; i < delUpdates.size(); ++i) {
                        PropName pn = new PropName(delUpdates.get(i));
                        String prefix = this.getPrefix(pn);
                        Property p = jcrNode.getProperty(prefix + ":" + pn.getName());
                        p.remove();
                    }
                    this.session.save();
                }
                catch (RepositoryException ex) {
                    ex.printStackTrace();
                }
                node.DAVprops = this.getProperties(node);
                this.setupVectors(node.DAVprops);
                ((AbstractTableModel)this.tbModel).fireTableDataChanged();
            }
        }
    }

    private void copySubTree(File dir, Node jcrNode) {
        try {
            File[] ff = dir.listFiles();
            for (int i = 0; i < ff.length; ++i) {
                jcrNode.addNode(ff[i].getName());
                if (ff[i].isDirectory()) {
                    jcrNode.addNode(ff[i].getName(), "nt:folder");
                    this.copySubTree(ff[i], jcrNode);
                    continue;
                }
                Node newFile = jcrNode.addNode(ff[i].getName(), "nt:file");
                Node content = newFile.addNode("jcr:content", "nt:resource");
                content.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                try {
                    content.setProperty("jcr:data", (InputStream)new FileInputStream(ff[i]));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private String getPrefix(PropName pn) {
        String prefix;
        block9: {
            prefix = pn.getPrefix();
            try {
                try {
                    String nsURI = pn.getNS();
                    if (nsURI == null) {
                        if (prefix == null) {
                            throw new NamespaceException();
                        }
                        nsURI = this.nsr.getURI(prefix);
                        prefix = pn.getPrefix();
                    } else {
                        prefix = this.nsr.getPrefix(nsURI);
                        if (pn.getPrefix() != null && !prefix.equals(pn.getPrefix())) {
                            this.nsr.registerNamespace(pn.getPrefix(), pn.getNS());
                            prefix = pn.getPrefix();
                        }
                    }
                }
                catch (NamespaceException e) {
                    if (pn.getPrefix() == null) {
                        String genPrefix = JCRTree.generatePrefix();
                        this.nsr.registerNamespace(genPrefix, pn.getNS());
                        prefix = genPrefix;
                        break block9;
                    }
                    prefix = pn.getPrefix();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return prefix;
    }

    private static String generatePrefix() {
        return "gp" + counter++;
    }

    public static String addSegment(String path, String segment) {
        String tmpSegment;
        if (path == null && segment == null) {
            return "";
        }
        if (path == null) {
            return segment.trim();
        }
        if (segment == null) {
            return path.trim();
        }
        StringBuffer tmp = new StringBuffer(path.trim());
        if (tmp.length() == 0 || tmp.charAt(tmp.length() - 1) != '/') {
            tmp.append("/");
        }
        if ((tmpSegment = segment.trim()).length() > 0 && tmpSegment.charAt(0) == '/') {
            if (tmpSegment.length() > 1) {
                tmp.append(tmpSegment.substring(1));
            }
        } else {
            tmp.append(tmpSegment);
        }
        return tmp.toString();
    }

    static {
        try {
            FileInputStream fin = new FileInputStream("JCRTree.properties");
            properties.load(fin);
            String p = null;
            p = (String)properties.get(P_WINDOWHEIGHT);
            if (p != null) {
                FRAME_WIDTH = Integer.parseInt((String)properties.get(P_WINDOWHEIGHT));
            }
            if ((p = (String)properties.get(P_WINDOWWIDTH)) != null) {
                FRAME_WIDTH = Integer.parseInt((String)properties.get(P_WINDOWWIDTH));
            }
            if ((p = (String)properties.get(P_WINDOWHEIGHT)) != null) {
                FRAME_HEIGHT = Integer.parseInt((String)properties.get(P_WINDOWHEIGHT));
            }
            if ((p = (String)properties.get(P_TBBC)) != null) {
                COLOR_TABLE_BACKGROUND = JCRTree.ColorFromRGB((String)properties.get(P_TBBC));
            }
            if ((p = (String)properties.get(P_TBFC)) != null) {
                COLOR_TABLE_FOREGROUND = JCRTree.ColorFromRGB((String)properties.get(P_TBFC));
            }
            if ((p = (String)properties.get(P_TRBC)) != null) {
                COLOR_TREE_BACKGROUND = JCRTree.ColorFromRGB((String)properties.get(P_TRBC));
            }
            if ((p = (String)properties.get(P_TRFC)) != null) {
                COLOR_TREE_FOREGROUND = JCRTree.ColorFromRGB((String)properties.get(P_TRFC));
            }
            if ((p = (String)properties.get(P_TBBCC1)) != null) {
                COLOR_TABLE_BACKGROUND_COLUMN1 = JCRTree.ColorFromRGB((String)properties.get(P_TBBCC1));
            }
            if ((p = (String)properties.get(P_TBFCC1)) != null) {
                COLOR_TABLE_FOREGROUND_COLUMN1 = JCRTree.ColorFromRGB((String)properties.get(P_TBFCC1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        counter = 1;
    }

    public class HistoryComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;
        public static final int MAX_MEM_LEN = 10;

        public HistoryComboBox() {
            this.setEditable(true);
            this.setFont(DIALOG_FONT);
            this.setMinimumSize(new Dimension(500, 10));
        }

        public void add(String item) {
            this.removeItem(item);
            this.insertItemAt(item, 0);
            this.setSelectedItem(item);
            if (this.getItemCount() > 10) {
                this.removeItemAt(this.getItemCount() - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(String fName) {
            BufferedReader fRdr = null;
            try {
                String urlEntry;
                File f;
                if (this.getItemCount() > 0) {
                    this.removeAllItems();
                }
                if (!(f = new File(fName)).exists()) {
                    return;
                }
                fRdr = new BufferedReader(new FileReader(fName));
                while ((urlEntry = fRdr.readLine()) != null) {
                    this.addItem(urlEntry);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (fRdr != null) {
                    try {
                        fRdr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(String fName) {
            BufferedWriter fWtr = null;
            try {
                fWtr = new BufferedWriter(new FileWriter(fName));
                for (int i = 0; i < this.getItemCount(); ++i) {
                    fWtr.write((String)this.getItemAt(i));
                    fWtr.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(MessageFormat.format(RB.getString("JCRTree.serialerr.fmt.txt"), e.toString()));
            }
            finally {
                if (fWtr != null) {
                    try {
                        fWtr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    class JCRTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;

        public JCRTreeModel(TreeNode node) {
            super(node);
        }

        public JCRTreeModel(TreeNode node, boolean asksAllowsChildren) {
            super(node, asksAllowsChildren);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            super.valueForPathChanged(path, newValue);
        }
    }

    protected class TreeExpansionHandler
    implements TreeExpansionListener {
        protected TreeExpansionHandler() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            TreePath path = evt.getPath();
            JTree tree = (JTree)evt.getSource();
            JCRTreeNode node = (JCRTreeNode)path.getLastPathComponent();
            try {
                if (node.populateCollections(JCRTree.this, true)) {
                    ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(node);
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
        }
    }

    protected class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            return c;
        }
    }

    protected class CustomBasicRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        Font fontPlain = new Font("SanSerif", 0, 11);
        Font fontBold = new Font("SanSerif", 1, 11);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setBackground(COLOR_TREE_BACKGROUND);
                l.setForeground(COLOR_TREE_FOREGROUND);
            }
            if (value instanceof JCRTreeNode) {
                boolean isLocked = ((JCRTreeNode)value).isLocked;
                if (((JCRTreeNode)value).isCollection) {
                    if (isLocked) {
                        this.setIcon(JCRTree.this.lockedColImage);
                    }
                    this.setFont(this.fontBold);
                } else {
                    boolean isCheckedOut = ((JCRTreeNode)value).isCheckedOut;
                    this.setIcon(JCRTree.this.resImage);
                    if (isCheckedOut) {
                        if (isLocked) {
                            this.setIcon(JCRTree.this.lockedCheckedOutResImage);
                        } else {
                            this.setIcon(JCRTree.this.checkedOutResImage);
                        }
                    } else if (isLocked) {
                        this.setIcon(JCRTree.this.lockedResImage);
                    }
                    this.setFont(this.fontPlain);
                }
            }
            return c;
        }
    }

    private class ProcessActions
    implements ActionListener {
        private ProcessActions() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCRTree.this.status.setText(">");
            Object object = e.getSource();
            if (object == JCRTree.this.miOpen) {
                JCRTree.this.miOpen_Action(e);
            } else if (object == JCRTree.this.miExit) {
                JCRTree.this.miExit_Action(e);
            } else if (object == JCRTree.this.miDelete) {
                JCRTree.this.miDelete_Action(e);
            } else if (object == JCRTree.this.miAdd) {
                JCRTree.this.miAdd_Action(e);
            } else if (object == JCRTree.this.miModify) {
                JCRTree.this.miModify_Action(e);
            } else if (object == JCRTree.this.miRefresh1) {
                JCRTree.this.miRefresh2_Action(e);
            } else if (object == JCRTree.this.miRefresh2) {
                JCRTree.this.miRefresh2_Action(e);
            } else if (object == JCRTree.this.miContents) {
                JCRTree.this.miContents_Action(e);
            } else if (object == JCRTree.this.miCopyClipboard) {
                JCRTree.this.miCopyClipboard_Action(e);
            } else if (object == JCRTree.this.miCopyUUIDClipboard) {
                JCRTree.this.miCopyUUIDClipboard_Action(e);
            } else if (object == JCRTree.this.miDetails) {
                JCRTree.this.miDetails_Action(e);
            } else if (object == JCRTree.this.miExport) {
                JCRTree.this.miExport_Action(e);
            } else if (object == JCRTree.this.miVersion) {
                JCRTree.this.miVersion_Action(e);
            } else if (object == JCRTree.this.miCheckout) {
                JCRTree.this.miCheckout_Action(e);
            } else if (object == JCRTree.this.miCheckin) {
                JCRTree.this.miCheckin_Action(e);
            } else if (object == JCRTree.this.miVHReport) {
                JCRTree.this.miVHReport_Action(e);
            } else if (object == JCRTree.this.miLock) {
                JCRTree.this.miLock_Action(e);
            } else if (object == JCRTree.this.miUnlock) {
                JCRTree.this.miUnlock_Action(e);
            } else if (object == JCRTree.this.miAbout) {
                JCRTree.this.miAbout_Action(e);
            }
        }
    }

    public class HexDisplayDlg
    extends JDialog {
        private static final long serialVersionUID = 3616732694617536056L;

        public HexDisplayDlg(Frame owner, String title, InputStream message) {
            super(owner, title, true);
            int DIALOG_WIDTH = 500;
            Font font = new Font("Monospaced", 0, 12);
            JTextArea txt = message != null ? new JTextArea(Utils.byteStreamToHex(message)) : new JTextArea("*** no content ***");
            txt.setFont(font);
            JScrollPane txtpane = new JScrollPane(txt);
            this.getContentPane().add(txtpane);
            this.setSize(500, 600);
            this.setLocation((JCRTree.this.screenWidth - DIALOG_WIDTH) / 2, this.getLocation().y);
            txt.setCaretPosition(0);
            txt.setEditable(false);
        }
    }

    public class VHDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JButton okButton;
        private JButton cancelButton;
        PropertyPanel pPanel;
        JTextArea txt;
        Map<String, String> origNV;
        List<Version> versionList;

        public VHDlg(Frame owner, List<Version> propsList, boolean modal) {
            super(owner, "Version History", modal);
            this.okButton = new JButton(RB.getString("JCRTree.ok.txt"));
            this.cancelButton = new JButton(RB.getString("JCRTree.cancel.txt"));
            this.txt = new JTextArea();
            this.origNV = new HashMap<String, String>();
            this.versionList = propsList;
            JPanel buttonsPanel = new JPanel();
            this.pPanel = new PropertyPanel(this.origNV);
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(new DrawingPane(this.versionList)), "Center");
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VHDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VHDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    VHDlg.this.okButton.requestFocus();
                }
            });
            this.pack();
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            this.setLocation(centredX, owner.getY() + 50);
            this.setSize(600, 750);
        }

        public Map<String, String> getSetUpdates() {
            return this.pPanel.getSetUpdates();
        }

        public Vector<String> getDelUpdates() {
            return this.pPanel.getDelUpdates();
        }

        public class DrawingPane
        extends JPanel {
            private static final long serialVersionUID = 1L;
            List<Version> versionList;
            private static final int WIDTH = 80;
            private static final int HEIGHT = 25;
            private static final int GAP = 15;

            public DrawingPane(List<Version> _versionList) {
                this.versionList = _versionList;
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(500, this.versionList.size() * 80 + 100);
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                try {
                    String path = this.versionList.get(0).getPath();
                    g.drawString(path, 5, 15);
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
                this.drawVersions(g2, this.versionList.get(0), 100, 20);
            }

            private void drawVersions(Graphics2D g, Version root, int x, int y) {
                try {
                    Font font = this.getFont();
                    FontRenderContext frc = g.getFontRenderContext();
                    g.drawRect(x - 40, y, 80, 25);
                    String text = root.getName();
                    double width = font.getStringBounds(text, frc).getWidth();
                    g.drawString(text, x - (int)width / 2, y + 18);
                    y += 25;
                    Version[] versions = root.getSuccessors();
                    for (int i = 0; i < versions.length; ++i) {
                        if (i == 0) {
                            g.drawLine(x, y, x, y + 25);
                        } else {
                            g.drawLine(x + 40, y - 12, x + i * 95, y - 12);
                            g.drawLine(x + i * 95, y - 12, x + i * 95, y + 25);
                        }
                        this.drawVersions(g, versions[i], x + i * 95, y + 25);
                    }
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class AboutDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JButton okButton;
        private JButton cancelButton;
        JTextArea details;

        public AboutDlg(Frame owner, boolean modal) {
            super(owner, "Repository details", modal);
            this.okButton = new JButton(RB.getString("JCRTree.ok.txt"));
            this.cancelButton = new JButton(RB.getString("JCRTree.cancel.txt"));
            this.details = new JTextArea();
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(this.details), "Center");
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    AboutDlg.this.okButton.requestFocus();
                }
            });
            this.pack();
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            this.setLocation(centredX, owner.getY() + 50);
            this.setSize(600, 750);
            StringBuffer sb = new StringBuffer(256);
            sb.append("Repository Descriptors\r\n");
            String[] dKeys = JCRTree.this.r.getDescriptorKeys();
            for (int i = 0; i < dKeys.length; ++i) {
                sb.append(dKeys[i] + " = " + JCRTree.this.r.getDescriptor(dKeys[i]) + "\r\n");
            }
            this.details.setText(sb.toString());
        }
    }

    public class OpenDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private String INITIAL_VALUE;
        private JButton okbutton;
        private JButton cfLabel;
        private JButton rhLabel;
        private JTextField cfField;
        private JTextField rhField;
        private final Frame _owner;

        public OpenDlg(Frame owner, String title, String message) {
            super(owner, title, true);
            this.INITIAL_VALUE = "c:\\temp\\jr-1.5\\repository\\repository.xml";
            this.cfLabel = new JButton("Configuration  file:");
            this.rhLabel = new JButton("Repository Home Directory:");
            this.cfField = new JTextField("");
            this.rhField = new JTextField("");
            this._owner = owner;
            Point topLeft = owner.getLocation();
            this.setLocation(topLeft.x + 20, topLeft.y + 50);
            this.okbutton = new JButton(RB.getString("JCRTree.ok.txt"));
            this.getContentPane().setLayout(new BorderLayout());
            JPanel fieldsPanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            fieldsPanel.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(3, 3, 3, 3);
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbl.setConstraints(this.cfLabel, gbc);
            fieldsPanel.add(this.cfLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(JCRTree.this.hCombo, gbc);
            fieldsPanel.add(JCRTree.this.hCombo);
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbl.setConstraints(this.rhLabel, gbc);
            fieldsPanel.add(this.rhLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(this.rhField, gbc);
            fieldsPanel.add(this.rhField);
            this.getContentPane().add((Component)fieldsPanel, "Center");
            this.getContentPane().add((Component)this.okbutton, "South");
            this.getRootPane().setDefaultButton(this.okbutton);
            this.okbutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cf = (String)JCRTree.this.hCombo.getSelectedItem();
                    JCRTree.this.hCombo.add(cf);
                    OpenDlg.this.cfField.setText(cf);
                    JCRTree.this.configFile = OpenDlg.this.cfField.getText();
                    File cfFile = new File(cf);
                    if (cfFile.exists()) {
                        OpenDlg.this.rhField.setText(cfFile.getParentFile().getAbsolutePath());
                        JCRTree.this.reposHome = OpenDlg.this.rhField.getText();
                    }
                    OpenDlg.this.dispose();
                }
            });
            this.cfLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(OpenDlg.this.cfField.getText());
                    int returnVal = chooser.showOpenDialog(OpenDlg.this._owner);
                    if (returnVal == 0) {
                        OpenDlg.this.cfField.setText(chooser.getSelectedFile().getAbsolutePath());
                        JCRTree.this.hCombo.setSelectedItem(chooser.getSelectedFile().getAbsolutePath());
                        JCRTree.this.configFile = OpenDlg.this.cfField.getText();
                    }
                }
            });
            this.rhLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(OpenDlg.this.rhField.getText());
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(OpenDlg.this._owner);
                    if (returnVal == 0) {
                        OpenDlg.this.rhField.setText(chooser.getSelectedFile().getAbsolutePath());
                        JCRTree.this.reposHome = OpenDlg.this.rhField.getText();
                        if (OpenDlg.this.INITIAL_VALUE.equals(OpenDlg.this.cfField.getText())) {
                            OpenDlg.this.cfField.setText(OpenDlg.this.rhField.getText() + File.separator + "repository.xml");
                            JCRTree.this.configFile = OpenDlg.this.cfField.getText();
                        }
                    }
                }
            });
            this.pack();
        }
    }

    public class CredentialsDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JTextField useridField;
        private JPasswordField passwordField;
        private JLabel usrLabel;
        private JLabel pwdLabel;
        private JButton okButton;
        private JButton cancelButton;

        public CredentialsDlg(Frame owner, boolean modal) {
            super(owner, modal);
            this.useridField = new JTextField(20);
            this.passwordField = new JPasswordField(20);
            this.usrLabel = new JLabel(RB.getString("JCRTree.user.txt"));
            this.pwdLabel = new JLabel(RB.getString("JCRTree.pw.txt"));
            this.okButton = new JButton(RB.getString("JCRTree.ok.txt"));
            this.cancelButton = new JButton(RB.getString("JCRTree.cancel.txt"));
            this.setTitle(RB.getString("JCRTree.crendentials.title.txt"));
            Point topLeft = owner.getLocation();
            this.setLocation(topLeft.x + 20, topLeft.y + 50);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel fieldsPanel = new JPanel();
            this.passwordField.setFont(this.useridField.getFont());
            GridBagLayout gbl = new GridBagLayout();
            fieldsPanel.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(3, 3, 3, 3);
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            gbl.setConstraints(this.usrLabel, gbc);
            fieldsPanel.add(this.usrLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbl.setConstraints(this.useridField, gbc);
            fieldsPanel.add(this.useridField);
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbl.setConstraints(this.pwdLabel, gbc);
            fieldsPanel.add(this.pwdLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(this.passwordField, gbc);
            fieldsPanel.add(this.passwordField);
            gbc.weighty = 1.0;
            JLabel filler = new JLabel("");
            gbl.setConstraints(filler, gbc);
            fieldsPanel.add(filler);
            this.getContentPane().add((Component)fieldsPanel, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCRTree.this.userid = CredentialsDlg.this.useridField.getText();
                    JCRTree.this.password = new String(CredentialsDlg.this.passwordField.getPassword());
                    CredentialsDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CredentialsDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    CredentialsDlg.this.okButton.requestFocus();
                }
            });
        }
    }

    public class AddDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JButton okButton;
        private JButton cancelButton;
        String nodeType;
        Map<String, String> origNV;
        PropertyPanel pPanel;
        JTextField name;
        JTextArea content;
        JTextField nodeTypeField;
        JPanel hdrPanel;

        public AddDlg(Frame owner, boolean modal) {
            super(owner, modal);
            this.okButton = new JButton(RB.getString("JCRTree.ok.txt"));
            this.cancelButton = new JButton(RB.getString("JCRTree.cancel.txt"));
            this.nodeType = "nt:unstructured";
            this.origNV = new HashMap<String, String>();
            this.name = new JTextField(20);
            this.content = new JTextArea();
            this.nodeTypeField = new JTextField("nt:unstructured");
            this.hdrPanel = new JPanel();
            this.hdrPanel.setLayout(new BorderLayout());
            this.hdrPanel.add((Component)this.name, "Center");
            this.hdrPanel.add((Component)this.nodeTypeField, "East");
            this.hdrPanel.add((Component)this.content, "South");
            JPanel buttonsPanel = new JPanel();
            this.pPanel = new PropertyPanel(this.origNV);
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.hdrPanel, "North");
            this.getContentPane().add((Component)this.pPanel, "Center");
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddDlg.this.nodeType = AddDlg.this.nodeTypeField.getText();
                    AddDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    AddDlg.this.okButton.requestFocus();
                }
            });
            this.pack();
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            this.setLocation(centredX, owner.getY() + 50);
        }

        public Map<String, String> getSetUpdates() {
            return this.pPanel.getSetUpdates();
        }
    }

    public class PropName {
        String ns = null;
        String name = null;
        String prefix = null;

        public PropName(String pname) {
            int p = pname.indexOf(125);
            if (p > 0) {
                this.name = pname.substring(p + 1);
                this.ns = pname.substring(1, p);
            } else {
                this.name = pname;
            }
            p = this.name.indexOf(":");
            if (p > 0) {
                this.prefix = this.name.substring(0, p);
                this.name = this.name.substring(p + 1);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getNS() {
            return this.ns;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public class ModDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JButton okButton;
        private JButton cancelButton;
        PropertyPanel pPanel;
        Map<String, String> origNV;

        public ModDlg(Frame owner, TreeMap<String, String> propsMap, boolean modal) {
            super(owner, modal);
            this.okButton = new JButton(RB.getString("JCRTree.ok.txt"));
            this.cancelButton = new JButton(RB.getString("JCRTree.cancel.txt"));
            this.origNV = new HashMap<String, String>();
            for (Map.Entry<String, String> me : propsMap.entrySet()) {
                this.origNV.put(me.getKey(), me.getValue());
            }
            JPanel buttonsPanel = new JPanel();
            this.pPanel = new PropertyPanel(this.origNV);
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.pPanel, "Center");
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    ModDlg.this.okButton.requestFocus();
                }
            });
            this.pack();
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            this.setLocation(centredX, owner.getY() + 50);
        }

        public Map<String, String> getSetUpdates() {
            return this.pPanel.getSetUpdates();
        }

        public Vector<String> getDelUpdates() {
            return this.pPanel.getDelUpdates();
        }
    }

    private class WebDAVTransferable
    implements Transferable,
    ClipboardOwner {
        private DataFlavor resourceFlavor = new DataFlavor(JCRTreeNode.class, "JCRTree.Resource");
        private DataFlavor[] flavors = new DataFlavor[]{this.resourceFlavor, DataFlavor.javaFileListFlavor};
        private List<DataFlavor> flavorList = Arrays.asList(this.flavors);
        transient Object m_obj;

        public WebDAVTransferable(JCRTreeNode node) {
            this.m_obj = node;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            boolean isOK = false;
            isOK = this.flavorList.contains(df);
            return isOK;
        }

        @Override
        public void lostOwnership(Clipboard c, Transferable t) {
            this.m_obj = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (df.equals(this.resourceFlavor)) {
                return this.m_obj;
            }
            if (df.equals(DataFlavor.javaFileListFlavor)) {
                if (JCRTree.this.dndFile == null) {
                    byte[] buffer = new byte[8192];
                    JCRTree.this.dndFile = new File(tmpdir + File.separator + ((JCRTreeNode)this.m_obj).resName);
                    JCRTree.this.dndFile.deleteOnExit();
                    OutputStream os = null;
                    InputStream is = null;
                    try {
                        Node jcrNode = ((JCRTreeNode)this.m_obj).JCRNode;
                        if (jcrNode.isNodeType("nt:file")) {
                            int len;
                            Node cn = jcrNode.getNode("jcr:content");
                            is = cn.getProperty("jcr:data").getBinary().getStream();
                            os = new FileOutputStream(JCRTree.this.dndFile);
                            while ((len = is.read(buffer, 0, buffer.length)) != -1) {
                                os.write(buffer, 0, len);
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        Object var6_10 = null;
                        return var6_10;
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    JCRTree.this.inDragDrop = true;
                }
                ArrayList<File> l = new ArrayList<File>();
                l.add(JCRTree.this.dndFile);
                return l;
            }
            return null;
        }
    }

    private class DNDTree
    extends JTree
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private static final long serialVersionUID = 1L;
        protected DragSource m_dragSource;
        protected DropTarget m_dropTarget;
        protected boolean m_drag;
        protected boolean m_drop;

        public DNDTree() {
            this.m_dragSource = null;
            this.m_dropTarget = null;
            this.Init(true, true);
        }

        public DNDTree(boolean drag, boolean drop) {
            this.m_dragSource = null;
            this.m_dropTarget = null;
            this.Init(drag, drop);
        }

        public DNDTree(TreeModel model, boolean drag, boolean drop) {
            super(model);
            this.m_dragSource = null;
            this.m_dropTarget = null;
            this.Init(drag, drop);
        }

        private void Init(boolean drag, boolean drop) {
            this.m_drag = drag;
            this.m_drop = drop;
            if (this.m_drag) {
                this.m_dragSource = new DragSource();
                this.m_dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            }
            this.m_dropTarget = new DropTarget(this, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (this.m_drop) {
                event.acceptDrag(event.getDropAction());
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            int x = event.getLocation().x;
            int y = event.getLocation().y;
            TreePath path = this.getPathForLocation(x, y);
            if (path != null) {
                JCRTreeNode xx = (JCRTreeNode)path.getLastPathComponent();
                if (xx.isCollection) {
                    event.acceptDrag(event.getDropAction());
                } else {
                    event.rejectDrag();
                }
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if ((event.getSourceActions() & 3) == 0) {
                event.rejectDrop();
                return;
            }
            event.acceptDrop(event.getDropAction());
            Transferable transferable = event.getTransferable();
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor dataFlavor = flavors[i];
                try {
                    if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                        int x = event.getLocation().x;
                        int y = event.getLocation().y;
                        TreePath tp = this.getPathForLocation(x, y);
                        if (tp != null) {
                            JCRTreeNode node = (JCRTreeNode)tp.getLastPathComponent();
                            List fileList = (List)transferable.getTransferData(dataFlavor);
                            for (int j = 0; j < fileList.size(); ++j) {
                                File f = (File)fileList.get(j);
                                Node jcrNode = node.JCRNode;
                                JCRTree.this.copySubTree(f, jcrNode);
                            }
                            node.populated = false;
                            node.removeAllChildren();
                            if (node.populateCollections(JCRTree.this, true)) {
                                ((DefaultTreeModel)JCRTree.this.jTree.getModel()).nodeStructureChanged(node);
                            }
                        }
                        event.dropComplete(true);
                        return;
                    }
                    if (!"JCRTree.Resource".equals(dataFlavor.getHumanPresentableName())) continue;
                    JCRTreeNode source = (JCRTreeNode)transferable.getTransferData(dataFlavor);
                    String s = source.fullName;
                    int x = event.getLocation().x;
                    int y = event.getLocation().y;
                    TreePath tp = this.getPathForLocation(x, y);
                    if (tp != null) {
                        URL _url;
                        JCRTreeNode node = (JCRTreeNode)tp.getLastPathComponent();
                        try {
                            _url = new URL(node.fullName);
                        }
                        catch (MalformedURLException e) {
                            _url = null;
                        }
                        if (_url != null) {
                            Node node2 = node.JCRNode;
                        }
                    }
                    event.dropComplete(true);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    event.dropComplete(false);
                    return;
                }
            }
            event.dropComplete(false);
        }

        protected boolean itemCanBeDroppedOn(Object ob) {
            return true;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            TreePath treepath = this.getSelectionPath();
            if (treepath != null) {
                Object o = treepath.getLastPathComponent();
                WebDAVTransferable wt = new WebDAVTransferable((JCRTreeNode)o);
                this.m_dragSource.startDrag(event, null, wt, this);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            JCRTree.this.dndFile = null;
            JCRTree.this.dndString = null;
            JCRTree.this.inDragDrop = false;
            if (event.getDropSuccess()) {
                // empty if block
            }
            JCRTree.this.inDragDrop = false;
        }

        @Override
        public void dragEnter(DragSourceDragEvent event) {
        }

        @Override
        public void dragExit(DragSourceEvent event) {
        }

        @Override
        public void dragOver(DragSourceDragEvent event) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent event) {
        }
    }

    public class PropertyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JScrollPane propPane;
        JPanel propPanel;
        GridBagLayout gbl;
        Map<String, String> _propertyMap;
        Vector<JTextField> labels = new Vector(25);
        Vector<JTextField> textfields = new Vector(25);
        private JButton newpropButton = new JButton(JCRTree.access$200().getString("JCRTree.newprop.txt"));

        public PropertyPanel(Map<String, String> propertyMap) {
            this._propertyMap = propertyMap;
            this.propPanel = new JPanel();
            this.propPane = new JScrollPane(this.propPanel, 22, 32);
            this.propPane.setSize(100, 100);
            this.gbl = new GridBagLayout();
            this.propPanel.setLayout(this.gbl);
            this.setLayout(new BorderLayout());
            this.add((Component)this.newpropButton, "North");
            this.add((Component)this.propPane, "Center");
            for (String key : this._propertyMap.keySet()) {
                this.addProperty(key, this._propertyMap.get(key), false);
            }
            this.newpropButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyPanel.this.addProperty("", "", true);
                    PropertyPanel.this.propPanel.doLayout();
                    PropertyPanel.this.propPane.doLayout();
                    if (PropertyPanel.this.getParent() != null) {
                        PropertyPanel.this.getParent().doLayout();
                    }
                }
            });
        }

        public Map<String, String> getSetUpdates() {
            HashMap<String, String> setUpdates = new HashMap<String, String>();
            for (int i = 0; i < this.labels.size(); ++i) {
                String label = this.labels.get(i).getText();
                String text = this.textfields.get(i).getText();
                if (label.length() == 0 || this._propertyMap.containsKey(label) && text.equals(this._propertyMap.get(label)) || text.length() <= 0) continue;
                setUpdates.put(label, text);
            }
            return setUpdates;
        }

        public Vector<String> getDelUpdates() {
            Vector<String> delUpdates = new Vector<String>(5);
            for (int i = 0; i < this.labels.size(); ++i) {
                String label = this.labels.get(i).getText();
                String text = this.textfields.get(i).getText();
                if (text.length() != 0) continue;
                delUpdates.add(label);
            }
            return delUpdates;
        }

        public void addProperty(String propName, String propVal, boolean nameEditable) {
            JTextField value = new JTextField(propVal, 30);
            JTextField name = new JTextField(propName, 20);
            name.setEditable(nameEditable);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            name.setSize(50, 21);
            this.propPanel.add((Component)name, gbc);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            value.setSize(80, 21);
            this.propPanel.add((Component)value, gbc);
            this.labels.add(name);
            this.textfields.add(value);
        }
    }
}

