/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.j2ee;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.server.SessionProvider;
import org.apereo.cas.client.util.AssertionHolder;
import org.apereo.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASSessionProviderImpl
implements SessionProvider {
    private static final Logger log = LoggerFactory.getLogger(SASSessionProviderImpl.class);
    private CredentialsProvider cp;
    private final Map<Session, SessionProvider> externalSessions = Collections.synchronizedMap(new HashMap());

    public SASSessionProviderImpl(CredentialsProvider cp) {
        this.cp = cp;
    }

    public Session getSession(HttpServletRequest request, final Repository repository, final String workspace) throws LoginException, RepositoryException, ServletException {
        Assertion assertion;
        SessionProvider provider;
        Session session = null;
        Object object = request.getAttribute(SessionProvider.class.getName());
        if (object instanceof SessionProvider && (session = (provider = (SessionProvider)object).getSession(request, repository, workspace)) != null) {
            this.externalSessions.put(session, provider);
        }
        if ((assertion = AssertionHolder.getAssertion()) != null) {
            final String userid = assertion.getPrincipal().getName();
            try {
                LoginContext ctx = new LoginContext("SASTRUSTED", new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (callback instanceof NameCallback) {
                                ((NameCallback)callback).setName(userid);
                                continue;
                            }
                            if (callback instanceof PasswordCallback) {
                                ((PasswordCallback)callback).setPassword("trustedauthentication".toCharArray());
                                continue;
                            }
                            throw new UnsupportedCallbackException(callback);
                        }
                    }
                });
                ctx.login();
                Subject s = ctx.getSubject();
                return Subject.doAs(s, new PrivilegedAction<Session>(){
                    Session session = null;

                    @Override
                    public Session run() {
                        try {
                            this.session = repository.login(workspace);
                        }
                        catch (LoginException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchWorkspaceException e) {
                            e.printStackTrace();
                        }
                        catch (RepositoryException e) {
                            e.printStackTrace();
                        }
                        return this.session;
                    }
                });
            }
            catch (javax.security.auth.login.LoginException e) {
                throw new LoginException((Throwable)e);
            }
        }
        Credentials creds = this.cp.getCredentials(request);
        if (session == null) {
            session = repository.login(creds, workspace);
        }
        return session;
    }

    public void releaseSession(Session session) {
        SessionProvider provider = this.externalSessions.remove(session);
        if (provider != null) {
            provider.releaseSession(session);
        } else {
            session.logout();
        }
    }
}

