/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.j2ee;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASRepositoryStartupServletConfig
implements ServletConfig {
    private static final Logger log = LoggerFactory.getLogger(SASRepositoryStartupServletConfig.class);
    ServletConfig config;

    public SASRepositoryStartupServletConfig(ServletConfig config) {
        this.config = config;
    }

    public String getInitParameter(String name) {
        String reposDir;
        if ("repository-home".equals(name) && (reposDir = System.getProperty("sas.scs.repository.dir")) != null) {
            File rh = new File(reposDir);
            File cf = new File(rh, "repository.xml");
            if (rh.exists() && cf.exists()) {
                log.info("Using repository home override - '" + reposDir + "'");
                return reposDir;
            }
            log.warn("Repository home option invalid - '" + reposDir + "'");
        }
        return this.config.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.config.getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public String getServletName() {
        return this.config.getServletName();
    }
}

