/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.j2ee;

import com.sas.contentserver.j2ee.filters.jasig.InternalCas20ProxyReceivingTicketValidationFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModCas20ProxyReceivingTicketValidationFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(ModCas20ProxyReceivingTicketValidationFilter.class);
    InternalCas20ProxyReceivingTicketValidationFilter filter = null;
    FilterConfig config;

    public void destroy() {
        if (this.filter != null) {
            this.filter.destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filter == null) {
            this.filter = new InternalCas20ProxyReceivingTicketValidationFilter();
            this.filter.init(new ModFilterConfig(request, this.config));
        }
        this.filter.doFilter(request, response, chain);
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    class ModFilterConfig
    implements FilterConfig {
        FilterConfig config;
        ServletRequest request;

        public ModFilterConfig(ServletRequest request, FilterConfig config) {
            this.config = config;
            this.request = request;
        }

        public String getFilterName() {
            return this.config.getFilterName();
        }

        public String getInitParameter(String name) {
            if ("casServerUrlPrefix".equals(name)) {
                return this.getCasServerUrlPrefix();
            }
            if ("serverName".equals(name)) {
                return this.getServerName();
            }
            return this.config.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        private String getCasServerUrlPrefix() {
            URI uri;
            String orig = this.config.getInitParameter("casServerUrlPrefix");
            try {
                uri = new URI(orig);
            }
            catch (URISyntaxException e) {
                ModCas20ProxyReceivingTicketValidationFilter.this.log.error("Failed to parse serverName");
                ModCas20ProxyReceivingTicketValidationFilter.this.log.error(e.getMessage());
                return orig;
            }
            String scheme = this.getParameter("sas.scs.cas.scheme", uri.getScheme());
            String host = this.getParameter("sas.scs.cas.host", uri.getHost());
            String port = this.getParameter("sas.scs.cas.port", uri.getPort() + "");
            if (port.startsWith(":")) {
                port = port.substring(1);
            }
            port = "".equals(port) || "-1".equals(port) || "80".equals(port) && "http".equals(scheme) || "443".equals(port) && "https".equals(scheme) ? "" : ":" + port;
            String path = orig.substring(orig.lastIndexOf("/") + 1);
            String result = scheme + "://" + host + port + "/" + path;
            ModCas20ProxyReceivingTicketValidationFilter.this.log.info("ModCas20ProxyReceivingTicketValidationFilter, casServerUrlPrefix=" + result);
            return result;
        }

        private String getServerName() {
            URI uri;
            String orig = this.config.getInitParameter("serverName");
            try {
                uri = new URI(orig);
            }
            catch (URISyntaxException e) {
                ModCas20ProxyReceivingTicketValidationFilter.this.log.error("Failed to parse serverName");
                ModCas20ProxyReceivingTicketValidationFilter.this.log.error(e.getMessage());
                return orig;
            }
            String scheme = this.getParameter("sas.scs.svc.scheme", uri.getScheme());
            String host = this.getParameter("sas.scs.svc.host", uri.getHost());
            String port = this.getParameter("sas.scs.svc.port", uri.getPort() + "");
            if (port.startsWith(":")) {
                port = port.substring(1);
            }
            port = "".equals(port) || "-1".equals(port) || "80".equals(port) && "http".equals(scheme) || "443".equals(port) && "https".equals(scheme) ? "" : ":" + port;
            String result = scheme + "://" + host + port;
            ModCas20ProxyReceivingTicketValidationFilter.this.log.info("ModCas20ProxyReceivingTicketValidationFilter, serverName=" + result);
            return result;
        }

        private String getParameter(String name, String defValue) {
            String result = System.getProperty(name);
            if (result == null) {
                result = defValue;
            }
            return result;
        }
    }
}

