/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.io;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.VersionHandler;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASVersionHandler
extends VersionHandler {
    private static Logger log = LoggerFactory.getLogger(SASVersionHandler.class);

    public boolean exportProperties(PropertyExportContext exportContext, boolean isCollection) throws RepositoryException {
        boolean ret = super.exportProperties(exportContext, isCollection);
        long cTime = -1L;
        Node contentNode = (Node)exportContext.getExportRoot();
        if (contentNode.hasProperty("jcr:created")) {
            cTime = contentNode.getProperty("jcr:created").getLong();
        }
        exportContext.setCreationTime(cTime);
        if (ret) {
            Node cn = this.getContentNode((ExportContext)exportContext, isCollection);
            PropertyIterator it = cn.getProperties();
            while (it.hasNext()) {
                Property p = it.nextProperty();
                String name = p.getName();
                PropertyDefinition def = p.getDefinition();
                if (def.isMultiple() || SASVersionHandler.isDefinedByFilteredNodeType((PropertyDefinition)def)) {
                    log.debug("Skip property '" + name + "': not added to webdav property set.");
                    continue;
                }
                if ("jcr:data".equals(name) || "jcr:mimeType".equals(name) || "jcr:encoding".equals(name) || "jcr:created".equals(name) || "jcr:owner".equals(name) || "jcr:lastModified".equals(name) || "jcr:frozenMixinTypes".equals(name) || "jcr:frozenNode".equals(name) || "jcr:frozenPrimaryType".equals(name) || "jcr:frozenUuid".equals(name)) continue;
                DavPropertyName davName = this.getDavName(name, p.getSession());
                exportContext.setProperty((Object)davName, (Object)p.getValue().getString());
            }
        }
        return ret;
    }
}

