/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.io;

import com.sas.contentserver.commons.SpecialNameChars;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.DirListingExportHandler;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASDirListingExportHandler
extends DirListingExportHandler {
    private static Logger log = LoggerFactory.getLogger(SASDirListingExportHandler.class);

    public boolean exportContent(ExportContext context, boolean isCollection) throws IOException {
        if (!this.canExport(context, isCollection)) {
            throw new IOException(this.getName() + ": Cannot export " + context.getExportRoot());
        }
        context.setModificationTime(new Date().getTime());
        context.setContentType("text/html", "UTF-8");
        context.setETag("");
        if (context.hasStream()) {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(context.getOutputStream(), "utf8"));
            try {
                Item item = context.getExportRoot();
                Repository rep = item.getSession().getRepository();
                String repName = rep.getDescriptor("jcr.repository.name");
                String repURL = rep.getDescriptor("jcr.repository.vendor.url");
                String repVersion = rep.getDescriptor("jcr.repository.version");
                writer.print("<html><head><title>");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repName));
                writer.print(" ");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repVersion));
                writer.print(" ");
                writer.print(SpecialNameChars.decode(Text.encodeIllegalHTMLCharacters((String)item.getPath())));
                writer.print("</title></head>");
                writer.print("<body><h2>");
                writer.print(SpecialNameChars.decode(Text.encodeIllegalHTMLCharacters((String)item.getPath())));
                writer.print("</h2><ul>");
                writer.print("<li><a href=\"..\">..</a></li>");
                if (item.isNode()) {
                    NodeIterator iter = ((Node)item).getNodes();
                    while (iter.hasNext()) {
                        Node child = iter.nextNode();
                        String label = SpecialNameChars.decode(Text.getName((String)child.getPath()));
                        writer.print("<li><a href=\"");
                        writer.print(Text.escape((String)Text.encodeIllegalHTMLCharacters((String)label)));
                        if (child.isNode()) {
                            writer.print("/");
                        }
                        writer.print("\">");
                        writer.print(Text.encodeIllegalHTMLCharacters((String)label));
                        writer.print("</a></li>");
                    }
                }
                writer.print("</ul><hr size=\"1\"><em>Powered by <a href=\"");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repURL));
                writer.print("\">");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repName));
                writer.print("</a> version ");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repVersion));
                writer.print("</em></body></html>");
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
            writer.close();
        }
        return true;
    }

    public boolean exportContent(ExportContext context, DavResource resource) throws IOException {
        if (!this.canExport(context, resource)) {
            throw new IOException(this.getName() + ": Cannot export " + context.getExportRoot());
        }
        context.setModificationTime(new Date().getTime());
        context.setContentType("text/html", "UTF-8");
        context.setETag("");
        if (context.hasStream()) {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(context.getOutputStream(), "utf8"));
            try {
                Item item = context.getExportRoot();
                Repository rep = item.getSession().getRepository();
                String repName = rep.getDescriptor("jcr.repository.name");
                String repURL = rep.getDescriptor("jcr.repository.vendor.url");
                String repVersion = rep.getDescriptor("jcr.repository.version");
                writer.print("<html><head><title>");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repName));
                writer.print(" ");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repVersion));
                writer.print(" ");
                writer.print(SpecialNameChars.decode(Text.encodeIllegalHTMLCharacters((String)resource.getResourcePath())));
                writer.print("</title></head>");
                writer.print("<body><h2>");
                writer.print(SpecialNameChars.decode(Text.encodeIllegalHTMLCharacters((String)resource.getResourcePath())));
                writer.print("</h2><ul>");
                writer.print("<li><a href=\"..\">..</a></li>");
                DavResourceIterator iter = resource.getMembers();
                while (iter.hasNext()) {
                    DavResource child = iter.nextResource();
                    String label = SpecialNameChars.decode(Text.getName((String)child.getResourcePath()));
                    writer.print("<li><a href=\"");
                    writer.print(Text.encodeIllegalHTMLCharacters((String)child.getHref()));
                    writer.print("\">");
                    writer.print(Text.encodeIllegalHTMLCharacters((String)label));
                    writer.print("</a></li>");
                }
                writer.print("</ul><hr size=\"1\"><em>Powered by <a href=\"");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repURL));
                writer.print("\">");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repName));
                writer.print("</a> version ");
                writer.print(Text.encodeIllegalHTMLCharacters((String)repVersion));
                writer.print("</em></body></html>");
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
            writer.close();
        }
        return true;
    }
}

