/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.io;

import com.sas.contentserver.commons.SpecialNameChars;
import com.sas.contentserver.core.session.SASSessionImpl;
import com.sas.contentserver.security.SASDefaultAccessManager;
import com.sas.contentserver.security.SASPrivilege;
import com.sas.contentserver.webdav.AclResourceImpl;
import com.sas.contentserver.webdav.SASDomUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.server.io.CopyMoveContext;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.PropertyImportContext;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.security.AclProperty;
import org.apache.jackrabbit.webdav.security.Principal;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class SASDefaultHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(SASDefaultHandler.class);
    private static final String GROUPS = "GROUPS\\";
    private List<String> disallowedMimeTypes = new ArrayList<String>();
    private List<String> disallowedFileExtensions = new ArrayList<String>();

    public SASDefaultHandler() {
        super(null, "nt:davcollection", "nt:file", "nt:unstructured");
    }

    public boolean exportProperties(PropertyExportContext exportContext, boolean isCollection) throws RepositoryException {
        boolean ret;
        block27: {
            Node contentNode;
            ret = super.exportProperties(exportContext, isCollection);
            if (isCollection) {
                long cTime = -1L;
                Node contentNode2 = (Node)exportContext.getExportRoot();
                if (contentNode2.hasProperty("jcr:created")) {
                    cTime = contentNode2.getProperty("jcr:created").getLong();
                }
                exportContext.setCreationTime(cTime);
            }
            if (ret) {
                exportContext.setProperty((Object)SecurityConstants.PRINCIPAL_URL, (Object)new HrefProperty(SecurityConstants.PRINCIPAL_URL, exportContext.getExportRoot().getPath(), false));
                exportContext.setProperty((Object)SecurityConstants.ALTERNATE_URI_SET, (Object)new HrefProperty(SecurityConstants.ALTERNATE_URI_SET, new String[0], false));
                exportContext.setProperty((Object)SecurityConstants.GROUP_MEMBER_SET, (Object)new HrefProperty(SecurityConstants.GROUP_MEMBER_SET, new String[0], false));
                exportContext.setProperty((Object)SecurityConstants.GROUP_MEMBERSHIP, (Object)new HrefProperty(SecurityConstants.GROUP_MEMBERSHIP, new String[0], false));
            }
            Node node = (Node)exportContext.getExportRoot();
            log.debug("Exporting Owner of " + node.getName());
            if (node.hasProperty("jcr:owner")) {
                String owner = node.getProperty("jcr:owner").getValue().getString();
                owner = this.jcrToHrefPrincipal((AclResourceImpl.SASPropertyExportCtx)exportContext, owner);
                HrefProperty davOwnerProp = new HrefProperty(SecurityConstants.OWNER, owner, false);
                exportContext.setProperty(null, (Object)davOwnerProp);
                log.debug("Owner of {} is {}.", (Object)node.getName(), (Object)davOwnerProp.toString());
            }
            if (node.hasProperty("jcr:auto-version")) {
                String value = node.getProperty("jcr:auto-version").getString();
                exportContext.setProperty((Object)VersionControlledResource.AUTO_VERSION, (Object)value);
            } else if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:autoVersion")) {
                String value = contentNode.getProperty("jcr:autoVersion").getString();
                exportContext.setProperty((Object)VersionControlledResource.AUTO_VERSION, (Object)value);
            }
            try {
                JackrabbitAccessControlList acl;
                block26: {
                    acl = null;
                    try {
                        acl = (JackrabbitAccessControlList)node.getSession().getAccessControlManager().getApplicablePolicies(node.getPath()).nextAccessControlPolicy();
                    }
                    catch (NoSuchElementException e) {
                        AccessControlPolicy[] acps = node.getSession().getAccessControlManager().getPolicies(node.getPath());
                        if (acps == null || acps.length <= 0) break block26;
                        acl = (JackrabbitAccessControlList)acps[0];
                    }
                }
                if (acl != null) {
                    AccessControlEntry[] aces = acl.getAccessControlEntries();
                    HashMap<String, Object> principalPrivs = new HashMap<String, Object>();
                    for (int i = 0; i < aces.length; ++i) {
                        Privilege[] privs = aces[i].getPrivileges();
                        ArrayList<String> privNames = new ArrayList<String>(privs.length);
                        for (int j = 0; j < privs.length; ++j) {
                            privNames.add(privs[j].getName().substring(privs[j].getName().lastIndexOf(58) + 1));
                        }
                        HashSet webdavPrivs = principalPrivs.containsKey(aces[i].getPrincipal().getName()) ? (HashSet)principalPrivs.get(aces[i].getPrincipal().getName()) : new HashSet();
                        if (privNames.contains(SASPrivilege.PRIVILEGE_READ.getName())) {
                            webdavPrivs.add(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_READ);
                        }
                        if (privNames.contains(SASPrivilege.PRIVILEGE_WRITE.getName())) {
                            webdavPrivs.add(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_WRITE);
                        }
                        if (privNames.contains(SASPrivilege.PRIVILEGE_DELETE.getName())) {
                            webdavPrivs.add(SASPrivilege.PRIVILEGE_DELETE);
                        }
                        if (privNames.contains(SASPrivilege.PRIVILEGE_ADMIN.getName())) {
                            webdavPrivs.add(SASPrivilege.PRIVILEGE_ADMIN);
                        }
                        if (privNames.contains(SASPrivilege.PRIVILEGE_INHERIT_READ.getName())) {
                            webdavPrivs.add(SASPrivilege.PRIVILEGE_INHERIT_READ);
                        }
                        if (privNames.contains(SASPrivilege.PRIVILEGE_INHERIT_WRITE.getName())) {
                            webdavPrivs.add(SASPrivilege.PRIVILEGE_INHERIT_WRITE);
                        }
                        if (privNames.contains(SASPrivilege.PRIVILEGE_INHERIT_DELETE.getName())) {
                            webdavPrivs.add(SASPrivilege.PRIVILEGE_INHERIT_DELETE);
                        }
                        if (privNames.contains(SASPrivilege.PRIVILEGE_INHERIT_ADMIN.getName())) {
                            webdavPrivs.add(SASPrivilege.PRIVILEGE_INHERIT_ADMIN);
                        }
                        principalPrivs.put(aces[i].getPrincipal().getName(), webdavPrivs);
                    }
                    ArrayList<String> remove = new ArrayList<String>();
                    for (String principal : principalPrivs.keySet()) {
                        if (((HashSet)principalPrivs.get(principal)).size() != 0) continue;
                        remove.add(principal);
                    }
                    for (String principal : remove) {
                        principalPrivs.remove(principal);
                    }
                    AclProperty.Ace[] webdavAces = new AclProperty.Ace[principalPrivs.size()];
                    int i = 0;
                    for (String principal : principalPrivs.keySet()) {
                        Principal prin = null;
                        prin = principal.equals("jcr:all") ? Principal.getAllPrincipal() : (principal.equals("jcr:authenticated") ? Principal.getAuthenticatedPrincipal() : (principal.equals("jcr:unauthenticated") ? Principal.getUnauthenticatedPrincipal() : (principal.equals("jcr:owner") ? Principal.getPropertyPrincipal((DavPropertyName)SecurityConstants.OWNER) : Principal.getHrefPrincipal((String)this.jcrToHrefPrincipal((AclResourceImpl.SASPropertyExportCtx)exportContext, SpecialNameChars.decode(principal))))));
                        webdavAces[i] = AclProperty.createGrantAce((Principal)prin, (org.apache.jackrabbit.webdav.security.Privilege[])((HashSet)principalPrivs.get(principal)).toArray(new org.apache.jackrabbit.webdav.security.Privilege[0]), (boolean)false, (boolean)false, null);
                        ++i;
                    }
                    AclProperty aclProp = new AclProperty(webdavAces);
                    exportContext.setProperty((Object)SecurityConstants.ACL, (Object)aclProp);
                }
            }
            catch (AccessDeniedException e) {
                log.info("user can't see access controls " + node.getPath());
            }
            catch (ItemNotFoundException e) {
                log.info("user can't see access controls " + node.getPath());
                DavPropertySet properties = ((AclResourceImpl.SASPropertyExportCtx)exportContext).getProperties();
                if (null == properties.get(SecurityConstants.ACL)) break block27;
                properties.remove(SecurityConstants.ACL);
            }
        }
        return ret;
    }

    private String jcrToHrefPrincipal(AclResourceImpl.SASPropertyExportCtx context, String jcrPrincipal) throws RepositoryException {
        return context.getDavResource().getLocator().getPrefix() + "/" + context.getExportRoot().getSession().getWorkspace().getName() + "/rep:security/rep:authorizables/rep:users/" + Text.escapePath((String)(jcrPrincipal.substring(0, 1) + "/" + jcrPrincipal.substring(0, 2) + "/" + jcrPrincipal));
    }

    private String davPrincipalToJcr(PropertyImportContext ctx, String davPrincipal) throws RepositoryException {
        if (davPrincipal == null || davPrincipal.length() == 0) {
            String msg = "Invalid access control element - a principal must be specified";
            log.error(msg);
            throw new RepositoryException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("Converting DAV princiapl URI: " + davPrincipal);
        }
        String jcrPrincipal = null;
        if (davPrincipal.startsWith(GROUPS)) {
            davPrincipal = "group/" + davPrincipal.substring(GROUPS.length());
        }
        try {
            String extidPart;
            int slashLoc;
            URI davURL = URI.create(davPrincipal);
            if (null != davURL.getFragment() || null != davURL.getQuery() || null != davURL.getUserInfo()) {
                throw new RepositoryException("Invalid principal Href: " + davURL.toString());
            }
            if (davURL.isAbsolute()) {
                String principalPath;
                String reposPath;
                URI reposURL = URI.create(((AclResourceImpl.SASPropertyImportCtx)ctx).getDavResource().getLocator().getPrefix());
                if (log.isDebugEnabled()) {
                    log.debug("Dav URL: " + davURL);
                    log.debug("Repos URL: " + reposURL);
                }
                if (!(reposPath = reposURL.getPath()).endsWith("/")) {
                    reposPath = reposPath + "/";
                }
                if (!(principalPath = davURL.getPath()).startsWith(reposPath)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Repos path (ensure trailing slash): " + reposPath);
                        log.debug("Principal path: " + principalPath);
                    }
                    String msg = "The supplied principal is not known to this repository: " + davURL.toString();
                    throw new RepositoryException(msg, (Throwable)new DavException(403, msg, null, SASDomUtil.RECOGNIZED_PRINCIPAL));
                }
                String principalFromRoot = principalPath.substring(reposPath.length()).substring(((AclResourceImpl.SASPropertyImportCtx)ctx).getImportRoot().getSession().getWorkspace().getName().length());
                if (!(principalFromRoot.startsWith("/rep:security/rep:authorizables/rep:users/") || principalFromRoot.startsWith("/rep:security/rep:authorizables/rep:groups/") || principalFromRoot.startsWith("/principals/"))) {
                    if (log.isDebugEnabled()) {
                        log.debug("Repos path (ensure trailing slash): " + reposPath);
                        log.debug("Principal path: " + principalPath);
                        log.debug("Principal from root: " + principalFromRoot);
                    }
                    String msg = "The supplied principal URL (" + davURL.toString() + ") must be rooted at: " + "/rep:security/rep:authorizables/rep:users/" + " or " + "/rep:security/rep:authorizables/rep:groups/";
                    throw new RepositoryException(msg, (Throwable)new DavException(403, msg, null, SASDomUtil.RECOGNIZED_PRINCIPAL));
                }
                jcrPrincipal = principalFromRoot.substring(principalFromRoot.lastIndexOf(47) + 1);
            } else {
                jcrPrincipal = URLDecoder.decode(davURL.getPath(), StandardCharsets.UTF_8.name());
            }
            if (log.isDebugEnabled()) {
                log.debug("Jcr principal is: " + jcrPrincipal);
            }
            if (!this.isPrincipalNameSafe(jcrPrincipal.substring(jcrPrincipal.indexOf(47) + 1))) {
                String msg = "Invalid principal name syntax: " + jcrPrincipal;
                throw new RepositoryException(msg, (Throwable)new DavException(403, msg, null, SASDomUtil.RECOGNIZED_PRINCIPAL));
            }
            if (!(!jcrPrincipal.startsWith("extid/") || (slashLoc = (extidPart = jcrPrincipal.substring(jcrPrincipal.indexOf(47) + 1)).indexOf(47)) >= 0 && this.isPrincipalNameSafe(extidPart.substring(0, slashLoc)) && this.isPrincipalNameSafe(extidPart.substring(slashLoc + 1)))) {
                String msg = "Invalid principal name syntax: " + jcrPrincipal;
                throw new RepositoryException(msg, (Throwable)new DavException(403, msg, null, SASDomUtil.RECOGNIZED_PRINCIPAL));
            }
        }
        catch (IllegalArgumentException ex) {
            String msg = "Invalid principal Href " + ex.getMessage();
            throw new RepositoryException(msg, (Throwable)new DavException(403, msg, null, SASDomUtil.RECOGNIZED_PRINCIPAL));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unsupported encoding " + e.getMessage();
            throw new RepositoryException(msg, (Throwable)e);
        }
        return jcrPrincipal;
    }

    private boolean isPrincipalNameSafe(String name) {
        int length = "/:\\<>[]\"'#%".length();
        for (int i = 0; i < length; ++i) {
            char reservedChar = "/:\\<>[]\"'#%".charAt(i);
            if (name.indexOf(reservedChar) < 0) continue;
            log.warn("Principal (" + name + ") not used because it contains the reserved character: " + Character.toString(reservedChar) + ".");
            return false;
        }
        return true;
    }

    public boolean importContent(ImportContext context, boolean isCollection) throws IOException {
        String extension = null;
        if (context.getSystemId().lastIndexOf(46) != -1) {
            extension = context.getSystemId().substring(context.getSystemId().lastIndexOf(46));
            extension = extension.equals(".") ? null : extension.substring(1);
        }
        if (extension != null && this.caseInsensitiveContains(extension, this.disallowedFileExtensions)) {
            return false;
        }
        return super.importContent(context, isCollection);
    }

    protected boolean importProperties(ImportContext context, boolean isCollection, Node contentNode) {
        if (this.caseInsensitiveContains(context.getMimeType(), this.disallowedMimeTypes)) {
            return false;
        }
        return super.importProperties(context, isCollection, contentNode);
    }

    private boolean caseInsensitiveContains(String string, List<String> list) {
        for (String s : list) {
            if (!s.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public Map importProperties(PropertyImportContext importContext, boolean isCollection) throws RepositoryException {
        Map failures = super.importProperties(importContext, isCollection);
        Item item = importContext.getImportRoot();
        if (!item.isNode()) {
            throw new RepositoryException("Resource must be a valid Node");
        }
        Node node = (Node)item;
        SessionImpl session = (SessionImpl)node.getSession();
        SASDefaultAccessManager acMan = (SASDefaultAccessManager)session.getAccessControlManager();
        for (PropEntry entry : importContext.getChangeList()) {
            if (entry instanceof AclProperty) {
                AclProperty aclProp = (AclProperty)entry;
                List webDavAces = aclProp.getValue();
                HashMap<java.security.Principal, List<Privilege>> aces = new HashMap<java.security.Principal, List<Privilege>>();
                for (AclProperty.Ace webDavAce : webDavAces) {
                    String principalName = webDavAce.getPrincipal().getHref();
                    Principal davPrincipal = webDavAce.getPrincipal();
                    if (principalName == null) {
                        if (davPrincipal.equals(Principal.getAllPrincipal())) {
                            principalName = "jcr:all";
                        } else if (davPrincipal.equals(Principal.getAuthenticatedPrincipal())) {
                            principalName = "jcr:authenticated";
                        } else if (davPrincipal.equals(Principal.getUnauthenticatedPrincipal())) {
                            principalName = "jcr:unauthenticated";
                        } else if (davPrincipal.equals(Principal.getPropertyPrincipal((DavPropertyName)SecurityConstants.OWNER))) {
                            principalName = "jcr:owner";
                        }
                    } else {
                        principalName = this.davPrincipalToJcr(importContext, davPrincipal.getHref());
                    }
                    principalName = principalName.substring(principalName.lastIndexOf(47) + 1);
                    ArrayList<Privilege> privs = new ArrayList<Privilege>();
                    for (int i = 0; i < webDavAce.getPrivileges().length; ++i) {
                        org.apache.jackrabbit.webdav.security.Privilege webdavPriv = webDavAce.getPrivileges()[i];
                        if (webdavPriv.getName().equals(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_READ.getName())) {
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read"));
                            continue;
                        }
                        if (webdavPriv.getName().equals(org.apache.jackrabbit.webdav.security.Privilege.PRIVILEGE_WRITE.getName())) {
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}write"));
                            continue;
                        }
                        if (webdavPriv.equals(SASPrivilege.PRIVILEGE_DELETE)) {
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}delete"));
                            continue;
                        }
                        if (webdavPriv.equals(SASPrivilege.PRIVILEGE_ADMIN)) {
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin"));
                            continue;
                        }
                        if (webdavPriv.equals(SASPrivilege.PRIVILEGE_INHERIT_READ)) {
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read"));
                            continue;
                        }
                        if (webdavPriv.equals(SASPrivilege.PRIVILEGE_INHERIT_WRITE)) {
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-write"));
                            continue;
                        }
                        if (webdavPriv.equals(SASPrivilege.PRIVILEGE_INHERIT_DELETE)) {
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-delete"));
                            continue;
                        }
                        if (!webdavPriv.equals(SASPrivilege.PRIVILEGE_INHERIT_ADMIN)) continue;
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin"));
                    }
                    aces.put((java.security.Principal)new PrincipalImpl(SpecialNameChars.encode(principalName)), privs);
                }
                acMan.setSASPermissions(node, aces, true);
                session.save();
                continue;
            }
            if (!(entry instanceof DefaultDavProperty)) continue;
            DefaultDavProperty davProp = (DefaultDavProperty)entry;
            if (davProp.getName().equals((Object)SecurityConstants.OWNER)) {
                log.debug("Importing owner of " + node.getName());
                org.w3c.dom.Node n = (org.w3c.dom.Node)davProp.getValue();
                NodeList list = n.getChildNodes();
                if (list.getLength() == 0) {
                    log.debug("No owner set");
                    throw new RepositoryException("Must set exactly one owner");
                }
                org.w3c.dom.Node hrefNode = list.item(0);
                String href = hrefNode.getTextContent();
                String owner = href.substring(href.lastIndexOf(47) + 1);
                node.addMixin("owner");
                node.setProperty("jcr:owner", owner);
                continue;
            }
            if (!davProp.getName().getName().equals("jcr:enforce-versionable".substring("jcr:enforce-versionable".indexOf(58) + 1))) continue;
            boolean value = Boolean.parseBoolean(davProp.getValue().toString());
            this.propagateEnforceVersionable(node, value, isCollection);
        }
        return failures;
    }

    public boolean copy(CopyMoveContext context, DavResource source, DavResource destination) throws DavException {
        boolean ret = super.copy(context, source, destination);
        if (ret) {
            try {
                SASSessionImpl session = (SASSessionImpl)context.getSession();
                session.doAdmin();
                session.refresh(false);
                SASDefaultAccessManager adminAcMan = (SASDefaultAccessManager)session.getAccessControlManager();
                Node node = session.getNode(destination.getResourcePath().replace(destination.getLocator().getWorkspacePath(), ""));
                adminAcMan.propagateSASInheritedPrivileges((Session)session, node);
            }
            catch (Exception e) {
                throw new DavException(500, (Throwable)e);
            }
            finally {
                ((SASSessionImpl)context.getSession()).endAdmin();
            }
        }
        return ret;
    }

    private void propagateEnforceVersionable(Node node, boolean value, boolean isCollection) throws RepositoryException {
        if (!node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file") && !node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}folder")) {
            return;
        }
        node.addMixin("enforce-versionable");
        node.setProperty("jcr:enforce-versionable", value);
        if (!isCollection) {
            node.addMixin("mix:versionable");
            node.addMixin("auto-version");
            node.setProperty("jcr:auto-version", "checkout-unlocked-checkin");
        } else if (node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}folder")) {
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                Node childNode = iter.nextNode();
                this.propagateEnforceVersionable(childNode, value, childNode.isNodeType("{http://www.jcp.org/jcr/nt/1.0}folder"));
            }
        }
    }

    public void setDisallowedMimeTypes(String mimetypes) {
        String[] types = mimetypes.split(",");
        this.disallowedMimeTypes = Arrays.asList(types);
    }

    public void setDisallowedFileExtensions(String fileExtensions) {
        String[] extensions = fileExtensions.split(",");
        this.disallowedFileExtensions = Arrays.asList(extensions);
    }
}

