/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.fs.db;

import com.sas.contentserver.fs.db.TenantDbFileSystem;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantTeradataFileSystem
extends TenantDbFileSystem {
    private static Logger log = LoggerFactory.getLogger(TenantTeradataFileSystem.class);

    public TenantTeradataFileSystem() {
        this.schema = "teradata";
        this.driver = "com.teradata.jdbc.TeraDriver";
        this.schemaObjectPrefix = "";
        this.initialized = false;
    }

    public InputStream getInputStream(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)filePath);
        String parentDir = FileSystemPathUtil.getParentDir((String)filePath);
        String name = FileSystemPathUtil.getName((String)filePath);
        String string = this.selectDataSQL;
        synchronized (string) {
            try {
                final ResultSet rs = this.conHelper.exec(this.selectDataSQL, new Object[]{parentDir, name}, false, 0);
                if (!rs.next()) {
                    throw new FileSystemException("no such file: " + filePath);
                }
                InputStream in = rs.getMetaData().getColumnType(1) == 2004 ? rs.getBlob(1).getBinaryStream() : rs.getBinaryStream(1);
                return new FilterInputStream(in){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        DbUtility.close((ResultSet)rs);
                    }
                };
            }
            catch (SQLException e) {
                String msg = "failed to retrieve data of file: " + filePath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, (Throwable)e);
            }
        }
    }
}

