/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.fs.db;

import com.sas.contentserver.db.util.TenantOracleConnectionHelper;
import com.sas.contentserver.fs.db.TenantDbFileSystem;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;

public class TenantOracleFileSystem
extends TenantDbFileSystem {
    protected static final String DEFAULT_TABLESPACE_CLAUSE = "";
    protected static final String TABLESPACE_VARIABLE = "${tablespace}";
    protected static final String INDEX_TABLESPACE_VARIABLE = "${indexTablespace}";
    protected String tablespace;
    protected String indexTablespace;

    public TenantOracleFileSystem() {
        this.schema = "oracle";
        this.driver = "oracle.jdbc.OracleDriver";
        this.schemaObjectPrefix = DEFAULT_TABLESPACE_CLAUSE;
        this.tablespace = DEFAULT_TABLESPACE_CLAUSE;
        this.indexTablespace = DEFAULT_TABLESPACE_CLAUSE;
        this.initialized = false;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespaceName) {
        this.tablespace = this.buildTablespaceClause(tablespaceName);
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(String tablespaceName) {
        this.indexTablespace = this.buildTablespaceClause(tablespaceName);
    }

    private String buildTablespaceClause(String tablespaceName) {
        if (tablespaceName == null || tablespaceName.trim().length() == 0) {
            return DEFAULT_TABLESPACE_CLAUSE;
        }
        return "tablespace " + tablespaceName.trim();
    }

    @Override
    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        TenantOracleConnectionHelper helper = new TenantOracleConnectionHelper(dataSrc, false);
        helper.init();
        return helper;
    }

    @Override
    protected CheckSchemaOperation createCheckSchemaOperation() {
        if (DEFAULT_TABLESPACE_CLAUSE.equals(this.indexTablespace) && !DEFAULT_TABLESPACE_CLAUSE.equals(this.tablespace)) {
            this.indexTablespace = this.tablespace;
        }
        return super.createCheckSchemaOperation().addVariableReplacement(TABLESPACE_VARIABLE, this.tablespace).addVariableReplacement(INDEX_TABLESPACE_VARIABLE, this.indexTablespace);
    }

    @Override
    protected void buildSQLStatements() {
        this.insertFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) values (?, ?, ?, ?, ?, ?)";
        this.insertFolderSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) values (?, nvl(?, ' '), ?, null, ?)";
        this.updateDataSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.updateLastModifiedSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and TENANT_ID = ?";
        this.selectFileExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectFolderExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and TENANT_ID = ? and FSENTRY_LENGTH is null";
        this.selectFileNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME != ' ' and TENANT_ID = ? and FSENTRY_LENGTH is null";
        this.selectFileAndFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME != ' ' TENANT_ID = ?";
        this.selectChildCountSQL = "select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  and FSENTRY_NAME != ' ' and TENANT_ID = ?";
        this.selectDataSQL = "select nvl(FSENTRY_DATA, empty_blob()) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectLastModifiedSQL = "select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and TENANT_ID = ?";
        this.selectLengthSQL = "select nvl(FSENTRY_LENGTH, 0) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.deleteFileSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.deleteFolderSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where (FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null) or (FSENTRY_PATH = ?) or (FSENTRY_PATH like ?) and TENANT_ID = ?";
        this.copyFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) select ?, ?, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.copyFilesSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) select ?, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
    }
}

