/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.fs.db;

import com.sas.contentserver.db.util.TenantConnectionHelper;
import com.sas.framework.commons.holders.TenantHolder;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;

public class TenantDbFileSystem
extends DbFileSystem {
    private Map<Integer, Boolean> tenantsInitialized = new HashMap<Integer, Boolean>();

    public void init() throws FileSystemException {
        int tenantId = TenantHolder.get().getId();
        Boolean tenantInitialized = this.tenantsInitialized.get(tenantId);
        this.initialized = tenantInitialized == null ? false : tenantInitialized;
        try {
            super.init();
            this.tenantsInitialized.put(tenantId, Boolean.TRUE);
        }
        catch (FileSystemException e) {
            this.tenantsInitialized.put(tenantId, Boolean.FALSE);
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            this.tenantsInitialized.put(tenantId, Boolean.FALSE);
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new TenantConnectionHelper(dataSrc, false);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream in = TenantDbFileSystem.class.getResourceAsStream(this.getSchema() + ".ddl");
        return new CheckSchemaOperation(this.conHelper, in, this.schemaObjectPrefix + "FSENTRY").addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    protected void buildSQLStatements() {
        this.insertFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) values (?, ?, ?, ?, ?, ?)";
        this.insertFolderSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) values (?, ?, ?, 0, ?)";
        this.updateDataSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.updateLastModifiedSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.selectExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ?";
        this.selectFileExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.selectFolderExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is null";
        this.selectFileNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.selectFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ? and FSENTRY_DATA is null";
        this.selectFileAndFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ?";
        this.selectChildCountSQL = "select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ?";
        this.selectDataSQL = "select FSENTRY_DATA from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.selectLastModifiedSQL = "select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? TENANT_ID = ?";
        this.selectLengthSQL = "select FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.deleteFileSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.deleteFolderSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where (FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is null) or (FSENTRY_PATH = ?) or (FSENTRY_PATH like ?) and TENANT_ID = ?";
        this.copyFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) select ?, ?, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
        this.copyFilesSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) select ?, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ? and FSENTRY_DATA is not null";
    }
}

