/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.session;

import com.sas.contentserver.core.SASItemManager;
import com.sas.contentserver.core.session.SASSessionContext;
import java.util.Collections;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateListener;

public class SASSystemSession
extends SystemSession {
    public static SystemSession create(RepositoryContext repositoryContext, WorkspaceConfig wspConfig) throws RepositoryException {
        Set<SystemPrincipal> principals = Collections.singleton(new SystemPrincipal());
        Subject subject = new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
        return new SASSystemSession(repositoryContext, subject, wspConfig);
    }

    protected SASSystemSession(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws RepositoryException {
        super(repositoryContext, subject, wspConfig);
    }

    protected SessionContext createSessionContext(RepositoryContext repositoryContext, SessionImpl session, WorkspaceConfig wspConfig) throws RepositoryException {
        return new SASSessionContext(repositoryContext, session, wspConfig);
    }

    protected ItemManager createItemManager() {
        SASItemManager mgr = new SASItemManager(this.context);
        this.context.getItemStateManager().addListener((ItemStateListener)mgr);
        return mgr;
    }
}

