/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.session;

import com.sas.contentserver.core.SASItemManager;
import com.sas.contentserver.core.session.SASSessionContext;
import com.sas.framework.commons.holders.TenantHolder;
import com.sas.services.security.login.OMIServerPrincipal;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateListener;

public class SASSessionImpl
extends XASessionImpl {
    private static final Principal adminPrincipal = new AdminPrincipal("admin");
    private AtomicInteger actingAdmin = new AtomicInteger(0);
    private boolean isSystemOrAdmin = false;

    public SASSessionImpl(RepositoryContext repositoryContext, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this(repositoryContext, loginContext.getSubject(), wspConfig);
    }

    public SASSessionImpl(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(repositoryContext, subject, wspConfig);
        this.isSystemOrAdmin = SASSessionImpl.isSystemOrAdmin(subject);
    }

    protected SessionContext createSessionContext(RepositoryContext repositoryContext, SessionImpl session, WorkspaceConfig wspConfig) throws RepositoryException {
        return new SASSessionContext(repositoryContext, session, wspConfig);
    }

    protected ItemManager createItemManager() {
        SASItemManager mgr = new SASItemManager(this.context);
        this.context.getItemStateManager().addListener((ItemStateListener)mgr);
        return mgr;
    }

    public static boolean isSystemOrAdmin(Subject subject) {
        if (subject == null) {
            return false;
        }
        Set<OMIServerPrincipal> principals = null;
        principals = subject.getPrincipals(OMIServerPrincipal.class);
        if (!principals.isEmpty()) {
            for (OMIServerPrincipal p : principals) {
                String[] keywords = p.getUserClass().split(",");
                for (int k = 0; k < keywords.length; ++k) {
                    String keyword = keywords[k].trim();
                    if (!keyword.equalsIgnoreCase("Unrestricted") && !keyword.equalsIgnoreCase("Trusted")) continue;
                    return true;
                }
            }
        }
        return !subject.getPrincipals(SystemPrincipal.class).isEmpty() || !subject.getPrincipals(AdminPrincipal.class).isEmpty();
    }

    public void doAdmin() {
        if (!(this.isAdmin() && this.isSystem() || this.subject.isReadOnly())) {
            this.subject.getPrincipals().add(adminPrincipal);
            this.actingAdmin.getAndIncrement();
        }
    }

    public void endAdmin() {
        if (!(this.isAdmin() && this.isSystem() || this.actingAdmin.get() <= 0 || this.subject.isReadOnly())) {
            this.subject.getPrincipals().remove(adminPrincipal);
            this.actingAdmin.getAndDecrement();
        }
    }

    public boolean isAdmin() {
        if (this.actingAdmin != null && this.actingAdmin.get() > 0) {
            return true;
        }
        return this.isSystemOrAdmin;
    }

    public synchronized void logout() {
        super.logout();
        TenantHolder.clear();
    }
}

