/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.query.lucene;

import com.sas.contentserver.core.query.lucene.TenantQueryImpl;
import com.sas.framework.commons.holders.TenantHolder;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantSearchIndex
extends SearchIndex {
    private static final Logger log = LoggerFactory.getLogger(TenantSearchIndex.class);
    private static final String REINDEX_FILE_NAME = "REINDEX_ME";

    protected Document createDocument(NodeState node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        Document doc = super.createDocument(node, nsMappings, indexFormatVersion);
        NumericField field = new NumericField("TENANT_ID", Field.Store.YES, true);
        field.setIntValue(TenantHolder.get().getId());
        doc.add((Fieldable)field);
        return doc;
    }

    public ExecutableQuery createExecutableQuery(SessionContext sessionContext, String statement, String language) throws InvalidQueryException {
        TenantQueryImpl query = new TenantQueryImpl(sessionContext, this, this.getContext().getPropertyTypeRegistry(), statement, language, (QueryNodeFactory)this.getQueryNodeFactory());
        query.setRespectDocumentOrder(super.isDocumentOrder());
        return query;
    }

    public void initNewTenant() throws IOException {
        HashSet<NodeId> excludedIDs = new HashSet<NodeId>();
        if (super.getContext().getExcludedNodeId() != null) {
            excludedIDs.add(super.getContext().getExcludedNodeId());
        }
        Path rootPath = excludedIDs.isEmpty() ? JCR_SYSTEM_PATH : ROOT_PATH;
        try {
            long count = 0L;
            this.index.executeAndLog((MultiIndex.Action)new MultiIndex.Start(-1L));
            NodeState rootState = (NodeState)super.getContext().getItemStateManager().getItemState((ItemId)super.getContext().getRootId());
            count = this.index.createIndex(rootState, rootPath, super.getContext().getItemStateManager(), count);
            this.index.executeAndLog((MultiIndex.Action)new MultiIndex.Commit(this.index.getTransactionId()));
            log.debug("Created initial index for {} nodes for tenant {}", (Object)count, (Object)TenantHolder.get().getId());
            this.index.releaseMultiReader();
            this.index.scheduleFlushTask();
        }
        catch (Exception e) {
            String msg = "Error indexing workspace";
            IOException ex = new IOException(msg);
            ex.initCause(e);
            throw ex;
        }
    }

    protected void doInit() throws IOException {
        File indexPath;
        this.checkForceReindex();
        String extraction = System.getProperty("scs.override.text.extraction");
        if (extraction != null && (extraction.equals("forceReindex") || extraction.equals("noReindex"))) {
            this.setTikaConfigPath(TenantSearchIndex.class.getResource("override-extraction.xml").getPath());
        }
        super.doInit();
        if (extraction != null && extraction.equals("forceReindex") && (indexPath = new File(this.getPath())).exists()) {
            File reindexFlag = new File(indexPath.getParent() + File.separator + REINDEX_FILE_NAME);
            reindexFlag.createNewFile();
        }
    }

    private void checkForceReindex() throws IOException {
        File index = new File(this.getPath());
        File reindexFlag = new File(index.getParent() + File.separator + REINDEX_FILE_NAME);
        if (reindexFlag.exists()) {
            try {
                FileUtils.deleteDirectory((File)index);
                reindexFlag.delete();
            }
            catch (IOException e) {
                try {
                    log.warn("Initial index delete attempt failed with error: " + e.getMessage());
                    log.warn("This may be the result of a previous instance still shutting down. Waiting 60 seconds to retry...");
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e1) {
                    throw new IOException("Failed to delete index", e1);
                }
                FileUtils.deleteQuietly((File)index);
                reindexFlag.delete();
            }
        }
    }
}

