/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.lock;

import java.security.Principal;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.lock.LockInfo;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLockManagerImpl
extends LockManagerImpl {
    private static final Logger log = LoggerFactory.getLogger(SASLockManagerImpl.class);

    public SASLockManagerImpl(SessionImpl session, FileSystem fs, ScheduledExecutorService executor) throws RepositoryException {
        super(session, fs, executor);
    }

    protected void checkUnlock(LockInfo info, Session session) throws LockException, RepositoryException {
        if (!(((SessionImpl)session).isAdmin() || info.isLockHolder(session) || SASLockManagerImpl.isLockOwner(info.getId().toString(), (SessionImpl)session))) {
            throw new LockException("Node not locked by user: " + info.getId());
        }
    }

    protected void checkLock(LockInfo info, Session session) throws LockException, RepositoryException {
        if (!(((SessionImpl)session).isAdmin() || info.isLockHolder(session) || SASLockManagerImpl.isLockOwner(info.getId().toString(), (SessionImpl)session))) {
            throw new LockException("Node locked.");
        }
    }

    public static boolean isLockOwner(String nodeId, SessionImpl session) throws ItemNotFoundException, RepositoryException {
        Node node = session.getNodeByIdentifier(nodeId);
        if (!node.hasProperty("jcr:uniquelockOwner")) {
            return false;
        }
        Property sasLockOwnerProp = node.getProperty("jcr:uniquelockOwner");
        String sasLockOwner = sasLockOwnerProp.getString();
        Set<Principal> principals = session.getSubject().getPrincipals();
        for (Principal principal : principals) {
            if (principal instanceof GroupPrincipal || !principal.getName().equals(sasLockOwner)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLockProperties(NodeImpl node, String lockOwner, boolean isDeep) throws RepositoryException {
        LocalItemStateManager stateMgr;
        boolean success = false;
        SessionImpl editingSession = (SessionImpl)node.getSession();
        WorkspaceImpl wsp = (WorkspaceImpl)editingSession.getWorkspace();
        LocalItemStateManager localItemStateManager = stateMgr = wsp.getItemStateManager();
        synchronized (localItemStateManager) {
            if (stateMgr.inEditMode()) {
                throw new RepositoryException("Unable to write lock properties.");
            }
            stateMgr.edit();
            try {
                PropertyState propState;
                NodeId nodeId = node.getNodeId();
                NodeState nodeState = (NodeState)stateMgr.getItemState((ItemId)nodeId);
                if (!nodeState.hasPropertyName(NameConstants.JCR_LOCKOWNER)) {
                    propState = stateMgr.createNew(NameConstants.JCR_LOCKOWNER, nodeId);
                    propState.setType(1);
                    propState.setMultiValued(false);
                } else {
                    propState = (PropertyState)stateMgr.getItemState((ItemId)new PropertyId(nodeId, NameConstants.JCR_LOCKOWNER));
                }
                propState.setValues(new InternalValue[]{InternalValue.create((String)lockOwner)});
                nodeState.addPropertyName(NameConstants.JCR_LOCKOWNER);
                stateMgr.store((ItemState)nodeState);
                if (!nodeState.hasPropertyName(NameConstants.JCR_LOCKISDEEP)) {
                    propState = stateMgr.createNew(NameConstants.JCR_LOCKISDEEP, nodeId);
                    propState.setType(6);
                    propState.setMultiValued(false);
                } else {
                    propState = (PropertyState)stateMgr.getItemState((ItemId)new PropertyId(nodeId, NameConstants.JCR_LOCKISDEEP));
                }
                propState.setValues(new InternalValue[]{InternalValue.create((boolean)isDeep)});
                nodeState.addPropertyName(NameConstants.JCR_LOCKISDEEP);
                stateMgr.store((ItemState)nodeState);
                Set<Principal> principals = editingSession.getSubject().getPrincipals();
                String sasLockOwner = null;
                for (Principal principal : principals) {
                    if (principal instanceof GroupPrincipal) continue;
                    sasLockOwner = principal.getName();
                    break;
                }
                if (sasLockOwner != null) {
                    Name uniqueLockOwner = ((SessionImpl)node.getSession()).getQName("jcr:uniquelockOwner");
                    if (!nodeState.hasPropertyName(uniqueLockOwner)) {
                        propState = stateMgr.createNew(uniqueLockOwner, nodeId);
                        propState.setType(1);
                        propState.setMultiValued(false);
                    } else {
                        propState = (PropertyState)stateMgr.getItemState((ItemId)new PropertyId(nodeId, uniqueLockOwner));
                    }
                    propState.setValues(new InternalValue[]{InternalValue.create((String)sasLockOwner)});
                    nodeState.addPropertyName(uniqueLockOwner);
                    stateMgr.store((ItemState)nodeState);
                }
                stateMgr.update();
                success = true;
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Error while creating lock.", (Throwable)e);
            }
            finally {
                if (!success) {
                    stateMgr.cancel();
                    try {
                        this.unlock(node);
                    }
                    catch (RepositoryException e) {
                        log.error("error while cleaning up after failed lock attempt", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLockProperties(NodeImpl node) throws RepositoryException {
        LocalItemStateManager stateMgr;
        boolean success = false;
        SessionImpl editingSession = (SessionImpl)node.getSession();
        WorkspaceImpl wsp = (WorkspaceImpl)editingSession.getWorkspace();
        LocalItemStateManager localItemStateManager = stateMgr = wsp.getItemStateManager();
        synchronized (localItemStateManager) {
            try {
                Name uniqueLockOwner;
                PropertyState propState;
                NodeId nodeId = node.getNodeId();
                NodeState nodeState = (NodeState)stateMgr.getItemState((ItemId)nodeId);
                if (stateMgr.inEditMode()) {
                    throw new RepositoryException("Unable to remove lock properties.");
                }
                stateMgr.edit();
                if (nodeState.hasPropertyName(NameConstants.JCR_LOCKOWNER)) {
                    propState = (PropertyState)stateMgr.getItemState((ItemId)new PropertyId(nodeId, NameConstants.JCR_LOCKOWNER));
                    nodeState.removePropertyName(NameConstants.JCR_LOCKOWNER);
                    stateMgr.destroy((ItemState)propState);
                    stateMgr.store((ItemState)nodeState);
                }
                if (nodeState.hasPropertyName(NameConstants.JCR_LOCKISDEEP)) {
                    propState = (PropertyState)stateMgr.getItemState((ItemId)new PropertyId(nodeId, NameConstants.JCR_LOCKISDEEP));
                    nodeState.removePropertyName(NameConstants.JCR_LOCKISDEEP);
                    stateMgr.destroy((ItemState)propState);
                    stateMgr.store((ItemState)nodeState);
                }
                if (nodeState.hasPropertyName(uniqueLockOwner = ((SessionImpl)node.getSession()).getQName("jcr:uniquelockOwner"))) {
                    PropertyState propState2 = (PropertyState)stateMgr.getItemState((ItemId)new PropertyId(nodeId, uniqueLockOwner));
                    nodeState.removePropertyName(uniqueLockOwner);
                    stateMgr.destroy((ItemState)propState2);
                    stateMgr.store((ItemState)nodeState);
                }
                stateMgr.update();
                success = true;
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Error while removing lock.", (Throwable)e);
            }
            finally {
                if (!success) {
                    stateMgr.cancel();
                }
            }
        }
    }

    protected boolean internalUnlock(NodeImpl node) throws LockException, RepositoryException {
        return super.internalUnlock(node);
    }
}

