/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.lock;

import com.sas.contentserver.core.lock.SASLockManagerImpl;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockImpl;

class SASLockImpl
implements Lock {
    private Lock lock;

    public SASLockImpl(Lock lock) {
        this.lock = lock;
    }

    public String getLockOwner() {
        return this.lock.getLockOwner();
    }

    public String getLockToken() {
        try {
            if (!this.isSessionScoped() && (this.isAdminUser(this.getNode().getSession()) || this.lock.isLockOwningSession() || SASLockManagerImpl.isLockOwner(this.getNode().getIdentifier(), (SessionImpl)this.getNode().getSession()))) {
                return ((LockImpl)this.lock).getLockInfo().getLockToken();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    public Node getNode() {
        return this.lock.getNode();
    }

    public long getSecondsRemaining() throws RepositoryException {
        return this.lock.getSecondsRemaining();
    }

    public boolean isDeep() {
        return this.lock.isDeep();
    }

    public boolean isLive() throws RepositoryException {
        return this.lock.isLive();
    }

    public boolean isLockOwningSession() {
        return this.lock.isLockOwningSession();
    }

    public boolean isSessionScoped() {
        return this.lock.isSessionScoped();
    }

    public void refresh() throws LockException, RepositoryException {
        this.lock.refresh();
    }

    private boolean isAdminUser(Session session) {
        if (session instanceof SessionImpl) {
            return ((SessionImpl)session).isAdmin();
        }
        return "admin".equals(session.getUserID());
    }
}

