/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.jndi.provider;

import com.sas.contentserver.core.jndi.provider.InMemoryContextFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.apache.commons.dbcp2.BasicDataSource;

public class InMemoryDataSourceFactory {
    private static Context context = null;

    public static BasicDataSource registerDataSource(String jndiName, String driver, String jdbcUrl, String user, String password) {
        if (context == null) {
            System.setProperty("java.naming.factory.initial", InMemoryContextFactory.class.getName());
            System.setProperty("java.naming.factory.url.pkgs", "org.apache.jackrabbit.core.jndi.provider.inmemory");
            try {
                context = new InitialContext();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(driver);
        ds.setUrl(jdbcUrl);
        ds.setUsername(user);
        ds.setPassword(password);
        try {
            try {
                context.createSubcontext("sas");
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                // empty catch block
            }
            try {
                context.createSubcontext("sas/jdbc");
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                // empty catch block
            }
            context.rebind(jndiName, (Object)ds);
            return ds;
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

