/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.jndi.provider;

import com.sas.contentserver.core.jndi.provider.NamingExceptionWrapper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;

public class InMemoryContext
implements Context {
    protected static final NameParser myParser = new NameParser(){
        private final Properties syntax = new Properties();
        {
            this.syntax.put("jndi.syntax.direction", "left_to_right");
            this.syntax.put("jndi.syntax.separator", "/");
            this.syntax.put("jndi.syntax.ignorecase", "false");
            this.syntax.put("jndi.syntax.escape", "\\");
            this.syntax.put("jndi.syntax.beginquote", "'");
        }

        @Override
        public Name parse(String name) throws NamingException {
            return new CompoundName(name, this.syntax);
        }
    };
    protected Hashtable env = null;
    protected Hashtable bindings = new Hashtable();
    protected InMemoryContext parent = null;
    protected String myAtomicName = null;

    public InMemoryContext(Hashtable env) {
        this.env = env != null ? (Hashtable)env.clone() : null;
    }

    public InMemoryContext() {
        this(null);
    }

    protected InMemoryContext(InMemoryContext parent, String name, Hashtable env, Hashtable bindings) {
        this(env);
        this.parent = parent;
        this.myAtomicName = name;
        this.bindings = (Hashtable)bindings.clone();
    }

    protected Context createCtx(InMemoryContext parent, String name, Hashtable env) {
        return new InMemoryContext(parent, name, env, new Hashtable(11));
    }

    protected Context cloneCtx() {
        return new InMemoryContext(this.parent, this.myAtomicName, this.env, this.bindings);
    }

    protected Name getMyComponents(Name name) {
        return name;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Name nm;
        String atom;
        if (name.isEmpty()) {
            return this.cloneCtx();
        }
        if (name.toString().startsWith("java:comp/env/")) {
            name.remove(0);
            name.remove(0);
        }
        if ((atom = (nm = this.getMyComponents(name)).get(0)).startsWith("java:")) {
            atom = atom.substring(5);
        }
        Object inter = this.bindings.get(atom);
        if (nm.size() == 1) {
            if (inter == null) {
                throw new NameNotFoundException(name + " not found");
            }
            try {
                return NamingManager.getObjectInstance(inter, new CompositeName().add(atom), this, this.env);
            }
            catch (Exception e) {
                throw new NamingExceptionWrapper("getObjectInstance failed", e);
            }
        }
        if (!(inter instanceof Context)) {
            throw new NotContextException(atom + " does not name a context");
        }
        return ((Context)inter).lookup(nm.getSuffix(1));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        Object inter = this.bindings.get(atom);
        if (nm.size() == 1) {
            if (inter != null) {
                throw new NameAlreadyBoundException("Use rebind to override");
            }
            obj = NamingManager.getStateToBind(obj, new CompositeName().add(atom), this, this.env);
            this.bindings.put(atom, obj);
        } else {
            if (!(inter instanceof Context)) {
                throw new NotContextException(atom + " does not name a context");
            }
            ((Context)inter).bind(nm.getSuffix(1), obj);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        if (nm.size() == 1) {
            obj = NamingManager.getStateToBind(obj, new CompositeName().add(atom), this, this.env);
            this.bindings.put(atom, obj);
        } else {
            Object inter;
            if (atom.startsWith("java:")) {
                atom = atom.substring(5);
            }
            if (!((inter = this.bindings.get(atom)) instanceof Context)) {
                throw new NotContextException(atom + " does not name a context");
            }
            ((Context)inter).rebind(nm.getSuffix(1), obj);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        if (nm.size() == 1) {
            this.bindings.remove(atom);
        } else {
            Object inter = this.bindings.get(atom);
            if (!(inter instanceof Context)) {
                throw new NotContextException(atom + " does not name a context");
            }
            ((Context)inter).unbind(nm.getSuffix(1));
        }
    }

    @Override
    public void rename(String oldname, String newname) throws NamingException {
        this.rename(new CompositeName(oldname), new CompositeName(newname));
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        if (oldname.isEmpty() || newname.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        Name oldnm = this.getMyComponents(oldname);
        Name newnm = this.getMyComponents(newname);
        if (oldnm.size() != newnm.size()) {
            throw new OperationNotSupportedException("Do not support rename across different contexts");
        }
        String oldatom = oldnm.get(0);
        String newatom = newnm.get(0);
        if (oldnm.size() == 1) {
            if (this.bindings.get(newatom) != null) {
                throw new NameAlreadyBoundException(newname.toString() + " is already bound");
            }
            Object oldBinding = this.bindings.remove(oldatom);
            if (oldBinding == null) {
                throw new NameNotFoundException(oldname.toString() + " not bound");
            }
            this.bindings.put(newatom, oldBinding);
        } else {
            if (!oldatom.equals(newatom)) {
                throw new OperationNotSupportedException("Do not support rename across different contexts");
            }
            Object inter = this.bindings.get(oldatom);
            if (!(inter instanceof Context)) {
                throw new NotContextException(oldatom + " does not name a context");
            }
            ((Context)inter).rename(oldnm.getSuffix(1), newnm.getSuffix(1));
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfNames(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfBindings(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot destroy context using empty name");
        }
        this.unbind(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        Object inter = this.bindings.get(atom);
        if (nm.size() == 1) {
            if (inter != null) {
                throw new NameAlreadyBoundException("Use rebind to override");
            }
            Context child = this.createCtx(this, atom, this.env);
            this.bindings.put(atom, child);
            return child;
        }
        if (!(inter instanceof Context)) {
            throw new NotContextException(atom + " does not name a context");
        }
        return ((Context)inter).createSubcontext(nm.getSuffix(1));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            ((Context)obj).close();
        }
        return myParser;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (!(name instanceof CompositeName) && !(prefix instanceof CompositeName)) {
            Name result = (Name)prefix.clone();
            result.addAll(name);
            return new CompositeName().add(result.toString());
        }
        throw new OperationNotSupportedException("Do not support composing composite names");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(5, 0.75f);
        }
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.env == null) {
            return null;
        }
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env == null ? new Hashtable(3, 0.75f) : (Hashtable)this.env.clone();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        InMemoryContext ancestor = this.parent;
        if (ancestor == null) {
            return "";
        }
        Name name = myParser.parse("");
        name.add(this.myAtomicName);
        while (ancestor != null && ancestor.myAtomicName != null) {
            name.add(0, ancestor.myAtomicName);
            ancestor = ancestor.parent;
        }
        return name.toString();
    }

    public String toString() {
        return this.myAtomicName != null ? this.myAtomicName : "ROOT CONTEXT";
    }

    @Override
    public void close() throws NamingException {
    }

    public void clear() {
        this.bindings.clear();
    }

    class ListOfNames
    implements NamingEnumeration {
        protected Enumeration names;

        public ListOfNames(Enumeration names) {
            this.names = names;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            String className = InMemoryContext.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        @Override
        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        @Override
        public void close() {
            InMemoryContext.this.env.clear();
            InMemoryContext.this.bindings.clear();
        }
    }

    class ListOfBindings
    extends ListOfNames {
        public ListOfBindings(Enumeration names) {
            super(names);
        }

        @Override
        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            Object obj = InMemoryContext.this.bindings.get(name);
            try {
                obj = NamingManager.getObjectInstance(obj, new CompositeName().add(name), InMemoryContext.this, InMemoryContext.this.env);
            }
            catch (Exception e) {
                throw new NamingExceptionWrapper("getObjectInstance failed", e);
            }
            return new Binding(name, obj);
        }
    }
}

