/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.jndi;

import com.sas.contentserver.core.jndi.BindableTenantRepositoryFactory;
import com.sas.contentserver.core.jndi.provider.InMemoryDataSourceFactory;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.util.Arrays;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.jackrabbit.api.JackrabbitRepository;

public class SASRegistryHelper {
    public static void registerRepository(Context ctx, String name, String configFilePath, String repHomeDir, boolean overwrite) throws NamingException, RepositoryException {
        Reference reference = new Reference(Repository.class.getName(), BindableTenantRepositoryFactory.class.getName(), null);
        reference.add(new StringRefAddr("configFilePath", configFilePath));
        reference.add(new StringRefAddr("repHomeDir", repHomeDir));
        Object obj = new BindableTenantRepositoryFactory().getObjectInstance(reference, null, null, null);
        if (overwrite) {
            ctx.rebind(name, obj);
        } else {
            ctx.bind(name, obj);
        }
    }

    public static void unregisterRepository(Context ctx, String name) throws NamingException {
        ((JackrabbitRepository)ctx.lookup(name)).shutdown();
        ctx.unbind(name);
    }

    public static void registerJNDIDataSources() {
        char[] pwd;
        String user;
        String driver;
        String jdbcUrl;
        System.setProperty("java.naming.factory.url.pkgs", "com.sas.contentserver.core.jndi.provider:javax.naming.spi");
        System.setProperty("java.naming.factory.initial", "com.sas.contentserver.core.jndi.provider.InMemoryContextFactory");
        System.setProperty("java.naming.provider.url", "localhost");
        String jndiName = System.getProperty("scs.jndi.jndiName");
        if (jndiName != null && jndiName.length() > 0) {
            jdbcUrl = System.getProperty("scs.jndi.jdbcUrl");
            driver = System.getProperty("scs.jndi.driver");
            user = System.getProperty("scs.jndi.user");
            pwd = System.getProperty("scs.jndi.pwd", "").toCharArray();
            try {
                pwd = SasPasswordString.decodeChars((char[])pwd);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
            InMemoryDataSourceFactory.registerDataSource(jndiName, driver, jdbcUrl, user, String.valueOf(pwd));
            Arrays.fill(pwd, '0');
        }
        if ((jndiName = System.getProperty("scs.jndi.jndiName2")) != null && jndiName.length() > 0) {
            jdbcUrl = System.getProperty("scs.jndi.jdbcUrl2");
            driver = System.getProperty("scs.jndi.driver2");
            user = System.getProperty("scs.jndi.user2");
            pwd = System.getProperty("scs.jndi.pwd2", "").toCharArray();
            try {
                pwd = SasPasswordString.decodeChars((char[])pwd);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
            InMemoryDataSourceFactory.registerDataSource(jndiName, driver, jdbcUrl, user, String.valueOf(pwd));
            Arrays.fill(pwd, '0');
        }
    }

    public static class RepositoryStatus {
        private String jndiName;
        private boolean workspaceExisted;

        public RepositoryStatus(String jndiName, boolean workspaceExisted) {
            this.jndiName = jndiName;
            this.workspaceExisted = workspaceExisted;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public boolean workspaceExisted() {
            return this.workspaceExisted;
        }
    }
}

