/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.data;

import com.sas.contentserver.core.data.TenantDataStore;
import com.sas.framework.commons.TenantIdentifier;
import com.sas.framework.commons.holders.TenantHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantGarbageCollector
extends GarbageCollector {
    private static Logger log = LoggerFactory.getLogger(TenantGarbageCollector.class);

    public TenantGarbageCollector(RepositoryContext context, DataStore dataStore, IterablePersistenceManager[] list, SessionImpl[] sessionList) {
        super(context, dataStore, list, sessionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(Integer tenantId) throws RepositoryException {
        log.info("Marking DataStore for tenant id = " + tenantId + " for garbage collection.");
        long start = System.currentTimeMillis();
        TenantIdentifier initId = TenantHolder.get();
        try {
            TenantHolder.set((TenantIdentifier)new TenantIdentifier(tenantId.intValue(), "Server"));
            super.mark();
        }
        finally {
            TenantHolder.set((TenantIdentifier)initId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Time taken to mark for tenant id = " + tenantId + " = " + (System.currentTimeMillis() - start) + " ms");
        }
        log.info("Finished marking DataStore for tenant id = " + tenantId + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sweep(Integer tenantId) throws RepositoryException {
        log.info("Sweeping DataStore for tenant id = " + tenantId + ".");
        TenantIdentifier initId = TenantHolder.get();
        long start = System.currentTimeMillis();
        try {
            TenantHolder.set((TenantIdentifier)new TenantIdentifier(tenantId.intValue(), "Server"));
            int ret = super.sweep();
            if (log.isDebugEnabled()) {
                log.debug("Time taken to sweep for tenant id = " + tenantId + " = " + (System.currentTimeMillis() - start) + " ms");
            }
            log.info("Finished sweeping DataStore for tenant id = " + tenantId + ".");
            int n = ret;
            return n;
        }
        finally {
            TenantHolder.set((TenantIdentifier)initId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAll() throws RepositoryException {
        log.info("Marking DataStore for all tenant ids.");
        TenantIdentifier initId = TenantHolder.get();
        long start = System.currentTimeMillis();
        try {
            DataStore store = this.getDataStore();
            if (store instanceof TenantDataStore) {
                Set<Integer> ids = ((TenantDataStore)store).getInitializedTenantIds();
                for (Integer id : ids) {
                    TenantHolder.set((TenantIdentifier)new TenantIdentifier(id.intValue(), "Server"));
                    this.mark(id);
                }
            }
        }
        finally {
            TenantHolder.set((TenantIdentifier)initId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Time taken to mark for all tenant ids = " + (System.currentTimeMillis() - start) + " ms");
        }
        log.info("Finished marking DataStore for all tenant ids.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Integer> sweepAll() throws RepositoryException {
        log.info("Sweeping DataStore for all tenant ids.");
        TenantIdentifier initId = TenantHolder.get();
        long start = System.currentTimeMillis();
        try {
            DataStore store = this.getDataStore();
            HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
            if (store instanceof TenantDataStore) {
                Set<Integer> ids = ((TenantDataStore)store).getInitializedTenantIds();
                for (Integer id : ids) {
                    TenantHolder.set((TenantIdentifier)new TenantIdentifier(id.intValue(), "Server"));
                    this.getDataStore().clearInUse();
                    ret.put(id, this.sweep(id));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Time taken to sweep for all tenant ids = " + (System.currentTimeMillis() - start) + " ms");
            }
            log.info("Finished sweeping DataStore for all tenant ids.");
            HashMap<Integer, Integer> hashMap = ret;
            return hashMap;
        }
        finally {
            TenantHolder.set((TenantIdentifier)initId);
        }
    }
}

