/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.data;

import com.sas.contentserver.core.data.TenantDataStore;
import com.sas.contentserver.db.util.TenantConnectionHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.util.Text;

public class TenantDbDataStore
extends DbDataStore
implements TenantDataStore {
    String selectAllTenantIds = "SELECT DISTINCT TENANT_ID FROM ${tablePrefix}${table}";

    public synchronized void init(String homeDir) throws DataStoreException {
        this.createTableSQL = "CREATE TABLE ${tablePrefix}${table}(ID VARCHAR(255) PRIMARY KEY, LENGTH BIGINT, LAST_MODIFIED BIGINT, DATA BLOB, TENANT_ID BIGINT NOT NULL)";
        this.insertTempSQL = "INSERT INTO ${tablePrefix}${table} VALUES(?, 0, ?, NULL, ?)";
        this.updateDataSQL = "UPDATE ${tablePrefix}${table} SET DATA=? WHERE ID=? AND TENANT_ID=?";
        this.updateLastModifiedSQL = "UPDATE ${tablePrefix}${table} SET LAST_MODIFIED=? WHERE ID=? AND LAST_MODIFIED<? AND TENANT_ID=?";
        this.updateSQL = "UPDATE ${tablePrefix}${table} SET ID=?, LENGTH=?, LAST_MODIFIED=? WHERE ID=? AND LAST_MODIFIED=? AND TENANT_ID=?";
        this.deleteSQL = "DELETE FROM ${tablePrefix}${table} WHERE ID=? AND TENANT_ID=?";
        this.deleteOlderSQL = "DELETE FROM ${tablePrefix}${table} WHERE LAST_MODIFIED<? AND TENANT_ID=?";
        this.selectMetaSQL = "SELECT LENGTH, LAST_MODIFIED FROM ${tablePrefix}${table} WHERE ID=? AND TENANT_ID=?";
        this.selectAllSQL = "SELECT ID FROM ${tablePrefix}${table} WHERE TENANT_ID=?";
        this.selectDataSQL = "SELECT ID, DATA FROM ${tablePrefix}${table} WHERE ID=? AND TENANT_ID=?";
        super.init(homeDir);
        this.selectAllTenantIds = Text.replace((String)this.selectAllTenantIds, (String)"${table}", (String)this.tableSQL).trim();
        this.selectAllTenantIds = Text.replace((String)this.selectAllTenantIds, (String)"${tablePrefix}", (String)(this.tablePrefix + this.schemaObjectPrefix)).trim();
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new TenantConnectionHelper(dataSrc, false);
    }

    @Override
    public Set<Integer> getInitializedTenantIds() throws RepositoryException {
        HashSet<Integer> hashSet;
        ResultSet rs = null;
        try {
            rs = this.conHelper.query(this.selectAllTenantIds, new Object[0]);
            HashSet<Integer> ret = new HashSet<Integer>();
            while (rs.next()) {
                ret.add(rs.getInt(1));
            }
            hashSet = ret;
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)rs);
        return hashSet;
    }
}

