/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.framework.commons.holders.TenantHolder;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ReferentialIntegrityException;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.NodeIdFactory;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantSharedItemStateManager
extends SharedItemStateManager {
    private static Logger log = LoggerFactory.getLogger(TenantSharedItemStateManager.class);
    private Map<Integer, SharedItemStateManager> initializedTenants;
    private PersistenceManager persistMgr;
    private NodeId rootNodeId;
    private NodeTypeRegistry ntReg;
    private boolean usesReferences;
    private ItemStateCacheFactory cacheFactory;
    private ISMLocking locking;
    private NodeIdFactory nodeIdFactory;
    private boolean tenantManagerInitialized = false;

    public TenantSharedItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, boolean usesReferences, ItemStateCacheFactory cacheFactory, ISMLocking locking, NodeIdFactory nodeIdFactory) throws ItemStateException {
        super(persistMgr, rootNodeId, ntReg, usesReferences, cacheFactory, locking, nodeIdFactory);
        if (this.initializedTenants == null) {
            this.initializedTenants = new HashMap<Integer, SharedItemStateManager>();
        }
        this.persistMgr = persistMgr;
        this.rootNodeId = rootNodeId;
        this.ntReg = ntReg;
        this.usesReferences = usesReferences;
        this.cacheFactory = cacheFactory;
        this.locking = locking;
        this.nodeIdFactory = nodeIdFactory;
        this.tenantManagerInitialized = true;
        this.initializedTenants.put(TenantHolder.get().getId(), this);
    }

    public void setCheckReferences(boolean checkReferences) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.setCheckReferences(checkReferences);
        } else {
            isMan.setCheckReferences(checkReferences);
        }
    }

    public void setEventChannel(UpdateEventChannel eventChannel) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.setEventChannel(eventChannel);
        } else {
            isMan.setEventChannel(eventChannel);
        }
    }

    public void setISMLocking(ISMLocking ismLocking) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.setISMLocking(ismLocking);
        } else {
            isMan.setISMLocking(ismLocking);
        }
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            return super.getItemState(id);
        }
        return isMan.getItemState(id);
    }

    public boolean hasItemState(ItemId id) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            return super.hasItemState(id);
        }
        return isMan.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            return super.getNodeReferences(id);
        }
        return isMan.getNodeReferences(id);
    }

    public boolean hasNodeReferences(NodeId id) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            return super.hasNodeReferences(id);
        }
        return isMan.hasNodeReferences(id);
    }

    public void stateCreated(ItemState created) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.stateCreated(created);
        } else {
            isMan.stateCreated(created);
        }
    }

    public void stateModified(ItemState modified) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.stateModified(modified);
        } else {
            isMan.stateModified(modified);
        }
    }

    public void stateDestroyed(ItemState destroyed) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.stateDestroyed(destroyed);
        } else {
            isMan.stateDestroyed(destroyed);
        }
    }

    public void stateDiscarded(ItemState discarded) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.stateDiscarded(discarded);
        } else {
            isMan.stateDiscarded(discarded);
        }
    }

    public String toString() {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            return super.toString();
        }
        return isMan.toString();
    }

    public void dispose() {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.dispose();
        } else {
            isMan.dispose();
        }
    }

    public void addVirtualItemStateProvider(VirtualItemStateProvider prov) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.addVirtualItemStateProvider(prov);
        } else {
            isMan.addVirtualItemStateProvider(prov);
        }
    }

    public void addListener(ItemStateListener listener) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.addListener(listener);
        } else {
            isMan.addListener(listener);
        }
    }

    public void removeListener(ItemStateListener listener) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.removeListener(listener);
        } else {
            isMan.removeListener(listener);
        }
    }

    public NodeIdFactory getNodeIdFactory() {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            return super.getNodeIdFactory();
        }
        return isMan.getNodeIdFactory();
    }

    private SharedItemStateManager getTenantSharedItemStateManager() {
        SharedItemStateManager isMan;
        if (!this.tenantManagerInitialized) {
            return this;
        }
        if (this.initializedTenants == null) {
            this.initializedTenants = new HashMap<Integer, SharedItemStateManager>();
        }
        if ((isMan = this.initializedTenants.get(TenantHolder.get().getId())) == null) {
            try {
                isMan = new SharedItemStateManager(this.persistMgr, this.rootNodeId, this.ntReg, this.usesReferences, this.cacheFactory, this.locking, this.nodeIdFactory);
            }
            catch (ItemStateException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            this.initializedTenants.put(TenantHolder.get().getId(), isMan);
        }
        return isMan;
    }

    public SharedItemStateManager.Update beginUpdate(ChangeLog local, EventStateCollectionFactory factory, VirtualItemStateProvider virtualProvider) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            return super.beginUpdate(local, factory, virtualProvider);
        }
        return isMan.beginUpdate(local, factory, virtualProvider);
    }

    public void externalUpdate(ChangeLog external, EventStateCollection events) {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.externalUpdate(external, events);
        } else {
            isMan.externalUpdate(external, events);
        }
    }

    public void update(ChangeLog local, EventStateCollectionFactory factory) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        SharedItemStateManager isMan = this.getTenantSharedItemStateManager();
        if (isMan instanceof TenantSharedItemStateManager) {
            super.update(local, factory);
        } else {
            isMan.update(local, factory);
        }
    }
}

