/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import java.io.File;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;

public class TenantPersistenceManagerFactory {
    private File homeDir;
    private FileSystem fs;
    private PersistenceManagerConfig pmConfig;
    private NodeId rootNodeId;
    private NamespaceRegistry nsReg;
    private NodeTypeRegistry ntReg;
    private DataStore ds;
    private RepositoryStatisticsImpl repoStats;

    TenantPersistenceManagerFactory(File homeDir, FileSystem fs, PersistenceManagerConfig pmConfig, NodeId rootNodeId, NamespaceRegistry nsReg, NodeTypeRegistry ntReg, DataStore ds, RepositoryStatisticsImpl repoStats) {
        this.homeDir = homeDir;
        this.fs = fs;
        this.pmConfig = pmConfig;
        this.rootNodeId = rootNodeId;
        this.nsReg = nsReg;
        this.ntReg = ntReg;
        this.ds = ds;
        this.repoStats = repoStats;
    }

    protected PersistenceManager get() throws RepositoryException {
        try {
            PersistenceManager pm = (PersistenceManager)this.pmConfig.newInstance(PersistenceManager.class);
            pm.init(new PMContext(this.homeDir, this.fs, this.rootNodeId, this.nsReg, this.ntReg, this.ds, this.repoStats));
            return pm;
        }
        catch (Exception e) {
            String msg = "Cannot instantiate persistence manager " + this.pmConfig.getClassName();
            throw new RepositoryException(msg, (Throwable)e);
        }
    }
}

